/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.net;

import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.TCSocketAddress;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.ChannelManager;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.MessageChannelInternal;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeRefusedMessage;
import com.tc.object.net.DSOChannelManager;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.object.net.NoSuchChannelException;
import com.tc.util.concurrent.CopyOnWriteSequentialMap;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSOChannelManagerImpl
implements DSOChannelManager,
DSOChannelManagerMBean {
    private static final Logger logger = LoggerFactory.getLogger(DSOChannelManager.class);
    private final CopyOnWriteSequentialMap<NodeID, MessageChannel> activeChannels = new CopyOnWriteSequentialMap(new CopyOnWriteSequentialMap.TypedArrayFactory(){

        public MessageChannel[] createTypedArray(int size) {
            return new MessageChannel[size];
        }
    });
    private final List<ChannelManagerEventListener> eventListeners = new CopyOnWriteArrayList<ChannelManagerEventListener>();
    private final ChannelManager genericChannelManager;
    private final String serverVersion;

    public DSOChannelManagerImpl(ChannelManager genericChannelManager, String serverVersion) {
        this.genericChannelManager = genericChannelManager;
        this.genericChannelManager.addEventListener(new GenericChannelEventListener());
        this.serverVersion = serverVersion;
    }

    @Override
    public MessageChannel getActiveChannel(NodeID id) throws NoSuchChannelException {
        MessageChannel rv = this.activeChannels.get(id);
        if (rv == null) {
            throw new NoSuchChannelException("No such channel: " + id);
        }
        return rv;
    }

    @Override
    public void closeAll(Collection<? extends NodeID> clientIDs) {
        for (NodeID nodeID : clientIDs) {
            if (nodeID instanceof ClientID) {
                ClientID id = (ClientID)nodeID;
                MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(id.toLong()));
                if (channel == null) continue;
                channel.close();
                continue;
            }
            logger.info("Ignoring close for " + nodeID);
        }
    }

    @Override
    public MessageChannel[] getActiveChannels() {
        return (MessageChannel[])this.activeChannels.valuesToArray();
    }

    @Override
    public boolean isActiveID(NodeID nodeID) {
        return this.activeChannels.containsKey(nodeID);
    }

    @Override
    public String getChannelAddress(NodeID nid) {
        try {
            MessageChannel channel = this.getActiveChannel(nid);
            InetSocketAddress addr = channel.getRemoteAddress();
            return TCSocketAddress.getStringForm(addr);
        }
        catch (NoSuchChannelException e) {
            return "no longer connected";
        }
    }

    private ClientHandshakeRefusedMessage newClientHandshakeRefusedMessage(ClientID clientID) throws NoSuchChannelException {
        MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(clientID.toLong()));
        if (channel == null) {
            throw new NoSuchChannelException();
        }
        return (ClientHandshakeRefusedMessage)channel.createMessage(TCMessageType.CLIENT_HANDSHAKE_REFUSED_MESSAGE);
    }

    private ClientHandshakeAckMessage newClientHandshakeAckMessage(ClientID clientID) throws NoSuchChannelException {
        MessageChannelInternal channel = this.genericChannelManager.getChannel(new ChannelID(clientID.toLong()));
        if (channel == null) {
            throw new NoSuchChannelException();
        }
        return (ClientHandshakeAckMessage)channel.createMessage(TCMessageType.CLIENT_HANDSHAKE_ACK_MESSAGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeChannelActive(ClientID clientID) {
        try {
            ClientHandshakeAckMessage ackMsg = this.newClientHandshakeAckMessage(clientID);
            MessageChannel channel = ackMsg.getChannel();
            CopyOnWriteSequentialMap<NodeID, MessageChannel> copyOnWriteSequentialMap = this.activeChannels;
            synchronized (copyOnWriteSequentialMap) {
                this.activeChannels.put(clientID, channel);
                ackMsg.initialize(this.getAllActiveClientIDs(), clientID, this.serverVersion);
                if (!ackMsg.send()) {
                    logger.warn("Not sending handshake message to disconnected client: " + clientID);
                }
            }
            this.fireChannelCreatedEvent(channel);
        }
        catch (NoSuchChannelException nsce) {
            logger.warn("Not sending handshake message to disconnected client: " + clientID, (Throwable)nsce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void makeChannelRefuse(ClientID clientID, String message) {
        try {
            ClientHandshakeRefusedMessage handshakeRefuseMsg = this.newClientHandshakeRefusedMessage(clientID);
            CopyOnWriteSequentialMap<NodeID, MessageChannel> copyOnWriteSequentialMap = this.activeChannels;
            synchronized (copyOnWriteSequentialMap) {
                handshakeRefuseMsg.initialize(message);
                if (!handshakeRefuseMsg.send()) {
                    logger.warn("Not sending handshake rejected message to disconnected client: " + clientID);
                }
            }
        }
        catch (NoSuchChannelException nsce) {
            logger.warn("Not sending handshake rejected message to disconnected client: " + clientID);
        }
    }

    private Set<? extends NodeID> getAllActiveClientIDs() {
        HashSet<NodeID> clientIDs = new HashSet<NodeID>();
        for (NodeID cid : this.activeChannels.keySet()) {
            clientIDs.add(cid);
        }
        return clientIDs;
    }

    @Override
    public void makeChannelActiveNoAck(MessageChannel channel) {
        this.activeChannels.put(this.getClientIDFor(channel.getChannelID()), channel);
    }

    @Override
    public void addEventListener(ChannelManagerEventListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener cannot be be null");
        }
        this.eventListeners.add(listener);
    }

    @Override
    public Set<NodeID> getAllClientIDs() {
        Set<ChannelID> channelIDs = this.genericChannelManager.getAllChannelIDs();
        HashSet<NodeID> clientIDs = new HashSet<NodeID>(channelIDs.size());
        for (ChannelID cid : channelIDs) {
            clientIDs.add(this.getClientIDFor(cid));
        }
        return clientIDs;
    }

    private void fireChannelCreatedEvent(MessageChannel channel) {
        for (ChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelCreated(channel);
        }
    }

    private void fireChannelRemovedEvent(MessageChannel channel) {
        for (ChannelManagerEventListener eventListener : this.eventListeners) {
            eventListener.channelRemoved(channel);
        }
    }

    @Override
    public ClientID getClientIDFor(ChannelID channelID) {
        return new ClientID(channelID.toLong());
    }

    private class GenericChannelEventListener
    implements ChannelManagerEventListener {
        private GenericChannelEventListener() {
        }

        @Override
        public void channelCreated(MessageChannel channel) {
            if (channel.getProductID() == ProductID.DIAGNOSTIC) {
                DSOChannelManagerImpl.this.fireChannelCreatedEvent(channel);
            }
        }

        @Override
        public void channelRemoved(MessageChannel channel) {
            DSOChannelManagerImpl.this.fireChannelRemovedEvent(channel);
            DSOChannelManagerImpl.this.activeChannels.remove(DSOChannelManagerImpl.this.getClientIDFor(channel.getChannelID()));
        }
    }
}

