/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.Collections;
import java.util.Random;
import java.util.stream.IntStream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;

public class Testing {
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final UID A_UID = UID.newUID(new Random(0L));
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final UID[] C_UIDS = (UID[])IntStream.range(0, 10).mapToObj(idx -> UID.newUID(new Random(idx))).toArray(UID[]::new);
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final UID[] S_UIDS = (UID[])IntStream.range(10, 20).mapToObj(idx -> UID.newUID(new Random(idx))).toArray(UID[]::new);
    @SuppressFBWarnings(value={"MS_PKGPROTECT"})
    public static final UID[] N_UIDS = (UID[])IntStream.range(20, 30).mapToObj(idx -> UID.newUID(new Random(idx))).toArray(UID[]::new);

    public static Cluster newTestCluster(String name, Stripe ... stripes) {
        return new Cluster(Arrays.asList(stripes)).setUID(C_UIDS[0]).setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster() {
        return Testing.newTestCluster((String)null);
    }

    public static Cluster newTestCluster(String name) {
        return new Cluster(Collections.emptyList()).setUID(C_UIDS[0]).setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster(Stripe ... stripes) {
        return new Cluster(stripes).setUID(C_UIDS[0]).setFailoverPriority(FailoverPriority.availability());
    }

    public static Stripe newTestStripe(String name) {
        return Testing.newTestStripe(name, S_UIDS[1]);
    }

    public static Stripe newTestStripe(String name, UID uid) {
        return new Stripe().setUID(uid).setName(name);
    }

    public static Node newTestNode(String name, String hostname, int port) {
        return Testing.newTestNode(name, hostname, port, N_UIDS[1]);
    }

    public static Node newTestNode(String name, String hostname) {
        return Testing.newTestNode(name, hostname, N_UIDS[1]);
    }

    public static Node newTestNode(String name, String hostname, int port, UID uid) {
        return new Node().setUID(uid).setName(name).setPort(port).setHostname(hostname);
    }

    public static Node newTestNode(String name, String hostname, UID uid) {
        return new Node().setUID(uid).setName(name).setHostname(hostname);
    }

    public static void replaceUIDs(Cluster cluster) {
        if (cluster.getUID() != null) {
            cluster.setUID(C_UIDS[0]);
        }
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripes().get(stripeId - 1);
            if (stripe.getUID() != null) {
                stripe.setUID(S_UIDS[stripeId]);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNodes().get(nodeId - 1);
                if (node.getUID() != null) {
                    node.setUID(N_UIDS[stripeId * cluster.getStripeCount() + nodeId]);
                }
            });
        });
    }

    public static void replaceRequiredUIDs(Cluster cluster, UID uid) {
        if (cluster.getUID() != null) {
            cluster.setUID(uid);
        }
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripes().get(stripeId - 1);
            if (stripe.getUID() != null) {
                stripe.setUID(uid);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNodes().get(nodeId - 1);
                if (node.getUID() != null) {
                    node.setUID(uid);
                }
            });
        });
    }

    public static void replaceRequiredNames(Cluster cluster, String name) {
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripes().get(stripeId - 1);
            if (stripe.getName() != null) {
                stripe.setName(name);
            }
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNodes().get(nodeId - 1);
                if (node.getName() != null) {
                    node.setName(name);
                }
            });
        });
    }

    public static void resetRequiredUIDs(Cluster cluster, UID uid) {
        cluster.setUID(uid);
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripes().get(stripeId - 1);
            stripe.setUID(uid);
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNodes().get(nodeId - 1);
                node.setUID(uid);
            });
        });
    }

    public static void resetRequiredNames(Cluster cluster, String name) {
        IntStream.rangeClosed(1, cluster.getStripeCount()).forEach(stripeId -> {
            Stripe stripe = cluster.getStripes().get(stripeId - 1);
            stripe.setName(name);
            IntStream.rangeClosed(1, stripe.getNodeCount()).forEach(nodeId -> {
                Node node = stripe.getNodes().get(nodeId - 1);
                node.setName(name);
            });
        });
    }
}

