/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.groups;

import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.StripeID;
import java.io.IOException;

public class NodeIDSerializer
implements TCSerializable<NodeIDSerializer> {
    private NodeID nodeID;

    public NodeIDSerializer() {
    }

    public NodeIDSerializer(NodeID nodeID) {
        this.nodeID = nodeID;
    }

    public NodeID getNodeID() {
        return this.nodeID;
    }

    private static NodeID getImpl(byte type) {
        switch (type) {
            case 1: {
                return new ClientID();
            }
            case 2: {
                return new ServerID();
            }
            case 4: {
                return new StripeID();
            }
        }
        throw new AssertionError((Object)("Unknown type : " + type));
    }

    @Override
    public NodeIDSerializer deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        byte type = serialInput.readByte();
        this.nodeID = NodeIDSerializer.getImpl(type);
        this.nodeID.deserializeFrom(serialInput);
        return this;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        serialOutput.writeByte(this.nodeID.getNodeType());
        this.nodeID.serializeTo(serialOutput);
    }
}

