/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.logging.LossyTCLogger;
import com.tc.net.CommStackMismatchException;
import com.tc.net.MaxConnectionsExceededException;
import com.tc.net.ReconnectionRejectedException;
import com.tc.net.TCSocketAddress;
import com.tc.net.protocol.NetworkStackID;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.NoActiveException;
import com.tc.net.protocol.transport.ReconnectionRejectedHandler;
import com.tc.net.protocol.transport.RestoreConnectionCallback;
import com.tc.net.protocol.transport.TransportRedirect;
import com.tc.properties.TCPropertiesImpl;
import com.tc.util.Assert;
import com.tc.util.CompositeIterator;
import com.tc.util.TCTimeoutException;
import com.tc.util.Util;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionEstablisher {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientConnectionEstablisher.class);
    private static final long CONNECT_RETRY_INTERVAL;
    private static final long MIN_RETRY_INTERVAL = 1000L;
    public static final String RECONNECT_THREAD_NAME = "ConnectionEstablisher";
    private Iterable<InetSocketAddress> serverAddresses;
    private final Set<InetSocketAddress> redirects = new LinkedHashSet<InetSocketAddress>();
    private final AtomicBoolean asyncReconnecting = new AtomicBoolean(false);
    private final AtomicBoolean allowReconnects = new AtomicBoolean(true);
    private volatile AsyncReconnect asyncReconnect;
    private final ReconnectionRejectedHandler reconnectionRejectedHandler;

    public ClientConnectionEstablisher(ReconnectionRejectedHandler reconnectionRejectedHandler) {
        this.reconnectionRejectedHandler = reconnectionRejectedHandler;
        this.asyncReconnect = new AsyncReconnect(this);
    }

    public void reset() {
        this.quitReconnectAttempts();
        this.asyncReconnect = new AsyncReconnect(this);
    }

    AsyncReconnect getAsyncReconnectThread() {
        return this.asyncReconnect;
    }

    void setAsyncReconnectingForTests(boolean val) {
        this.asyncReconnecting.set(val);
    }

    void disableReconnectThreadSpawn() {
        this.asyncReconnect.disableThreadSpawn();
    }

    void setAllowReconnects(boolean val) {
        this.allowReconnects.set(val);
    }

    boolean getAllowReconnects() {
        return this.allowReconnects.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetworkStackID open(Iterable<InetSocketAddress> serverAddresses, ClientMessageTransport cmt, ClientConnectionErrorListener reporter) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.assertNotNull(cmt);
        Assert.assertNotNull(reporter);
        Assert.assertNotNull(serverAddresses);
        AtomicBoolean atomicBoolean = this.asyncReconnecting;
        synchronized (atomicBoolean) {
            Assert.eval("Can't call open() while asynch reconnect occurring", !this.asyncReconnecting.get());
            this.allowReconnects.set(true);
            this.serverAddresses = serverAddresses;
            return this.connectTryAllOnce(serverAddresses, cmt, reporter);
        }
    }

    NetworkStackID connectTryAllOnce(Iterable<InetSocketAddress> serverAddresses, ClientMessageTransport cmt, ClientConnectionErrorListener reporter) throws TCTimeoutException, IOException, MaxConnectionsExceededException, CommStackMismatchException {
        Assert.assertFalse(cmt.isConnected());
        CompositeIterator<InetSocketAddress> serverAddressIterator = this.getServerAddressIterator();
        InetSocketAddress target = null;
        while (target != null || serverAddressIterator.hasNext()) {
            if (target == null) {
                target = ClientConnectionEstablisher.nextServerAddress(serverAddressIterator);
            }
            try {
                return cmt.open(target);
            }
            catch (TransportRedirect redirect) {
                reporter.onError(target, redirect);
                target = InetSocketAddress.createUnresolved(redirect.getHostname(), redirect.getPort());
                this.redirects.add(target);
            }
            catch (NoActiveException noactive) {
                reporter.onError(target, noactive);
                target = null;
                LOGGER.debug("Connection attempt failed: ", (Throwable)noactive);
                if (serverAddressIterator.hasNext()) continue;
                throw new IOException(noactive);
            }
            catch (TCTimeoutException | IOException e) {
                reporter.onError(target, e);
                target = null;
                if (serverAddressIterator.hasNext()) continue;
                throw e;
            }
        }
        throw new IOException("active not available");
    }

    public String toString() {
        return "ClientConnectionEstablisher[" + this.serverAddresses + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect(ClientMessageTransport cmt, Supplier<Boolean> stopCheck) throws MaxConnectionsExceededException {
        try {
            LossyTCLogger connectionErrorLossyLogger = new LossyTCLogger(cmt.getLogger(), 10000L, LossyTCLogger.LossyTCLoggerType.TIME_BASED, true);
            boolean connected = cmt.isConnected();
            if (!cmt.getProductID().isReconnectEnabled() && !this.isReconnectBetweenL2s()) {
                cmt.getLogger().info("Got reconnect request for ClientMessageTransport that does not support it.  skipping");
                return;
            }
            this.asyncReconnecting.set(true);
            boolean reconnectionRejected = false;
            InetSocketAddress target = null;
            int i = 0;
            while (this.tryToConnect(connected) && !stopCheck.get().booleanValue()) {
                CompositeIterator<InetSocketAddress> serverAddressIterator = this.getServerAddressIterator();
                while ((target != null || serverAddressIterator.hasNext()) && this.tryToConnect(connected)) {
                    if (reconnectionRejected) {
                        if (this.reconnectionRejectedHandler.isRetryOnReconnectionRejected()) {
                            LOGGER.info("Reconnection rejected by L2, trying again to reconnect - " + cmt);
                        } else {
                            LOGGER.info("Reconnection rejected by L2, no more trying to reconnect - " + cmt);
                            return;
                        }
                    }
                    if (target == null) {
                        target = ClientConnectionEstablisher.nextServerAddress(serverAddressIterator);
                    }
                    if (i == 0) {
                        String previousConnectHost = "";
                        int previousConnectHostPort = -1;
                        if (cmt.getRemoteAddress() != null) {
                            previousConnectHost = cmt.getRemoteAddress().getAddress().getHostAddress();
                            previousConnectHostPort = cmt.getRemoteAddress().getPort();
                        }
                        String connectingToHost = "";
                        try {
                            connectingToHost = this.getHostByName(target);
                        }
                        catch (UnknownHostException e) {
                            this.handleConnectException(e, true, connectionErrorLossyLogger);
                            target = null;
                            continue;
                        }
                        int connectingToHostPort = target.getPort();
                        if (serverAddressIterator.hasNext() && previousConnectHost.equals(connectingToHost) && previousConnectHostPort == connectingToHostPort) {
                            target = null;
                            continue;
                        }
                    }
                    try {
                        if (i % 20 == 0 && i > 0) {
                            cmt.getLogger().info("Reconnect attempt " + i + " to " + target);
                        }
                        cmt.reopen(target);
                        connected = cmt.getConnectionID().isValid();
                    }
                    catch (TransportRedirect redirect) {
                        target = InetSocketAddress.createUnresolved(redirect.getHostname(), redirect.getPort());
                    }
                    catch (NoActiveException noactive) {
                        target = null;
                        this.handleConnectException(new IOException(noactive), false, connectionErrorLossyLogger);
                    }
                    catch (MaxConnectionsExceededException e) {
                        target = null;
                        this.reset();
                        throw e;
                    }
                    catch (ReconnectionRejectedException e) {
                        target = null;
                        this.reset();
                        reconnectionRejected = true;
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (CommStackMismatchException e) {
                        target = null;
                        this.reset();
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (TCTimeoutException e) {
                        target = null;
                        this.handleConnectException(e, true, connectionErrorLossyLogger);
                    }
                    catch (IOException e) {
                        target = null;
                        this.handleConnectException(e, false, connectionErrorLossyLogger);
                    }
                    catch (Exception e) {
                        target = null;
                        this.handleConnectException(e, true, connectionErrorLossyLogger);
                    }
                }
                ++i;
            }
        }
        finally {
            this.asyncReconnecting.set(false);
        }
    }

    private CompositeIterator<InetSocketAddress> getServerAddressIterator() {
        return new CompositeIterator<InetSocketAddress>(Arrays.asList(this.serverAddresses.iterator(), new LinkedHashSet<InetSocketAddress>(this.redirects).iterator()));
    }

    private static InetSocketAddress nextServerAddress(Iterator<InetSocketAddress> serverAddressIterator) {
        InetSocketAddress serverAddress = serverAddressIterator.next();
        if (serverAddress.getPort() <= 0) {
            serverAddress = InetSocketAddress.createUnresolved(serverAddress.getHostString(), 9410);
        }
        return serverAddress;
    }

    String getHostByName(InetSocketAddress serverAddress) throws UnknownHostException {
        return InetAddress.getByName(serverAddress.getHostName()).getHostAddress();
    }

    boolean isReconnectBetweenL2s() {
        return this.reconnectionRejectedHandler.isRetryOnReconnectionRejected();
    }

    private boolean tryToConnect(boolean connected) {
        return !connected && !this.asyncReconnect.isStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreConnection(ClientMessageTransport cmt, TCSocketAddress sa, long timeoutMillis, RestoreConnectionCallback callback) throws MaxConnectionsExceededException {
        long deadline = System.currentTimeMillis() + timeoutMillis;
        boolean connected = cmt.isConnected();
        if (connected) {
            cmt.getLogger().info("Got restoreConnection request for ClientMessageTransport that is connected.  skipping");
            return;
        }
        this.asyncReconnecting.set(true);
        try {
            boolean reconnectionRejected = false;
            while (this.tryToConnect(connected)) {
                if (reconnectionRejected) {
                    if (this.reconnectionRejectedHandler.isRetryOnReconnectionRejected()) {
                        LOGGER.info("Reconnection rejected by L2, trying again to restore connection - " + cmt);
                    } else {
                        LOGGER.info("Reconnection rejected by L2, no more trying to restore connection - " + cmt);
                        return;
                    }
                }
                try {
                    cmt.reconnect(sa);
                    connected = true;
                }
                catch (TransportRedirect redirect) {
                    Assert.fail();
                }
                catch (NoActiveException noactive) {
                    Assert.fail();
                }
                catch (IllegalStateException closed) {
                    callback.restoreConnectionFailed(cmt);
                    this.reset();
                }
                catch (MaxConnectionsExceededException e) {
                    callback.restoreConnectionFailed(cmt);
                    this.reset();
                    throw e;
                }
                catch (TCTimeoutException e) {
                    this.handleConnectException(e, true, cmt.getLogger());
                }
                catch (ReconnectionRejectedException e) {
                    reconnectionRejected = true;
                    this.reset();
                    this.handleConnectException(e, false, cmt.getLogger());
                }
                catch (CommStackMismatchException e) {
                    this.reset();
                    this.handleConnectException(e, false, cmt.getLogger());
                }
                catch (IOException e) {
                    this.handleConnectException(e, false, cmt.getLogger());
                }
                catch (Exception e) {
                    this.handleConnectException(e, true, cmt.getLogger());
                }
                if (!connected && System.currentTimeMillis() <= deadline) continue;
            }
            if (!connected && !reconnectionRejected) {
                callback.restoreConnectionFailed(cmt);
            }
        }
        finally {
            this.asyncReconnecting.set(false);
        }
    }

    private void handleConnectException(Exception e, boolean logFullException, Logger logger) {
        if (logger.isDebugEnabled() || logFullException) {
            logger.error("Connect Exception", (Throwable)e);
        }
        if (CONNECT_RETRY_INTERVAL > 0L) {
            try {
                Thread.sleep(CONNECT_RETRY_INTERVAL);
            }
            catch (InterruptedException e1) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void asyncReconnect(ClientMessageTransport cmt, Supplier<Boolean> stopCheck) {
        if (cmt.getConnectionID().isValid()) {
            this.putConnectionRequest(ConnectionRequest.newReconnectRequest(cmt, stopCheck));
        }
    }

    public void asyncRestoreConnection(ClientMessageTransport cmt, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
        this.putConnectionRequest(ConnectionRequest.newRestoreConnectionRequest(cmt, sa, callback, timeoutMillis));
    }

    private void putConnectionRequest(ConnectionRequest request) {
        if (!this.allowReconnects.get() || this.asyncReconnect.isStopped()) {
            LOGGER.info("Ignoring connection request: " + request + " as allowReconnects: " + this.allowReconnects.get() + ", asyncReconnect.isStopped(): " + this.asyncReconnect.isStopped());
            return;
        }
        if (request.getClientMessageTransport() != null && request.getClientMessageTransport().wasOpened()) {
            this.asyncReconnect.putConnectionRequest(request);
        } else {
            LOGGER.info("Ignoring connection request as transport was not connected even once");
        }
    }

    public void quitReconnectAttempts() {
        this.allowReconnects.set(false);
        this.asyncReconnect.stop();
        if (!this.isReconnectBetweenL2s()) {
            this.asyncReconnect.awaitTermination(true);
        }
    }

    int connectionRequestQueueSize() {
        return 0;
    }

    static {
        Logger logger = LoggerFactory.getLogger(ClientConnectionEstablisher.class);
        long value = TCPropertiesImpl.getProperties().getLong("l1.socket.reconnect.waitInterval");
        if (value < 1000L) {
            logger.info("Forcing reconnect wait interval to 1000 (configured value was " + value + ")");
            value = 1000L;
        }
        CONNECT_RETRY_INTERVAL = value;
    }

    static class RestoreConnectionRequest
    extends ConnectionRequest {
        private final RestoreConnectionCallback callback;
        private final long timeoutMillis;
        private final TCSocketAddress sa;

        public RestoreConnectionRequest(ClientMessageTransport cmt, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
            super(ConnectionRequestType.RESTORE_CONNECTION, cmt, () -> false);
            this.callback = callback;
            this.timeoutMillis = timeoutMillis;
            this.sa = sa;
        }

        public TCSocketAddress getSocketAddress() {
            return this.sa;
        }

        public RestoreConnectionCallback getCallback() {
            return this.callback;
        }

        public long getTimeoutMillis() {
            return this.timeoutMillis;
        }

        @Override
        public String toString() {
            return "RestoreConnectionRequest [type=" + (Object)((Object)this.getType()) + ", clientMessageTransport=" + this.getClientMessageTransport() + ", callback=" + this.callback + ", timeoutMillis=" + this.timeoutMillis + ", sa=" + this.sa + "]";
        }
    }

    static class ConnectionRequest {
        private final ConnectionRequestType type;
        private final ClientMessageTransport cmt;
        private final Supplier<Boolean> stopCheck;

        ConnectionRequest(ConnectionRequestType requestType) {
            this(requestType, null, () -> false);
        }

        ConnectionRequest(ConnectionRequestType requestType, ClientMessageTransport cmt, Supplier<Boolean> stopCheck) {
            this.cmt = cmt;
            this.type = requestType;
            this.stopCheck = stopCheck;
        }

        ConnectionRequestType getType() {
            return this.type;
        }

        ClientMessageTransport getClientMessageTransport() {
            return this.cmt;
        }

        boolean checkForStop() {
            return this.stopCheck.get();
        }

        public static ConnectionRequest newReconnectRequest(ClientMessageTransport cmtParam, Supplier<Boolean> stopCheck) {
            return new ConnectionRequest(ConnectionRequestType.RECONNECT, cmtParam, stopCheck);
        }

        public static ConnectionRequest newRestoreConnectionRequest(ClientMessageTransport cmtParam, TCSocketAddress sa, RestoreConnectionCallback callback, long timeoutMillis) {
            return new RestoreConnectionRequest(cmtParam, sa, callback, timeoutMillis);
        }

        public String toString() {
            return "ConnectionRequest [type=" + (Object)((Object)this.type) + ", cmt=" + this.cmt + "]";
        }
    }

    static enum ConnectionRequestType {
        RECONNECT,
        RESTORE_CONNECTION;

    }

    static class AsyncReconnect {
        private static final Logger logger = LoggerFactory.getLogger(AsyncReconnect.class);
        private final ClientConnectionEstablisher cce;
        private boolean stopped = false;
        private Thread connectionEstablisherThread;
        private boolean disableThreadSpawn = false;

        public AsyncReconnect(ClientConnectionEstablisher cce) {
            this.cce = cce;
        }

        public synchronized boolean isStopped() {
            return this.stopped;
        }

        synchronized void disableThreadSpawn() {
            this.disableThreadSpawn = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForThread(Thread oldThread, boolean mayInterruptIfRunning) {
            boolean isInterrupted = false;
            try {
                if (Thread.currentThread() != oldThread && oldThread != null) {
                    if (mayInterruptIfRunning) {
                        oldThread.interrupt();
                    }
                    oldThread.join();
                }
            }
            catch (InterruptedException e) {
                LOGGER.info("Got interrupted while waiting for connectionEstablisherThread to complete");
                isInterrupted = true;
            }
            finally {
                Util.selfInterruptIfNeeded(isInterrupted);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void awaitTermination(boolean mayInterruptIfRunning) {
            AsyncReconnect asyncReconnect = this;
            synchronized (asyncReconnect) {
                if (!this.stopped) {
                    throw new AssertionError((Object)"not stopped");
                }
                LOGGER.debug("waiting for connection establisher to finish " + this.connectionEstablisherThread);
                this.notifyAll();
            }
            this.waitForThread(this.connectionEstablisherThread, mayInterruptIfRunning);
        }

        public synchronized void stop() {
            logger.debug("Connection establisher stopping " + System.identityHashCode(this));
            this.stopped = true;
            this.notifyAll();
        }

        public synchronized Thread getConnectionThread() {
            return this.connectionEstablisherThread;
        }

        public void putConnectionRequest(ConnectionRequest request) {
            if (!this.isStopped()) {
                Thread oldThread = this.getConnectionThread();
                this.waitForThread(oldThread, true);
                this.startThreadIfNecessary(request);
            }
        }

        private synchronized void startThreadIfNecessary(ConnectionRequest request) {
            if (!this.disableThreadSpawn) {
                Thread thread = new Thread(() -> this.execute(request), "ConnectionEstablisher-" + this.cce.serverAddresses.toString() + "-" + System.identityHashCode(request));
                thread.setDaemon(true);
                thread.start();
                this.connectionEstablisherThread = thread;
            }
        }

        public void execute(ConnectionRequest request) {
            block8: {
                logger.debug("Connection establisher starting. " + System.identityHashCode(this));
                if (request != null) {
                    logger.info("Handling connection request: " + request);
                    ClientMessageTransport cmt = request.getClientMessageTransport();
                    try {
                        switch (request.getType()) {
                            case RECONNECT: {
                                this.cce.reconnect(cmt, request::checkForStop);
                                break;
                            }
                            case RESTORE_CONNECTION: {
                                RestoreConnectionRequest req = (RestoreConnectionRequest)request;
                                this.cce.restoreConnection(req.getClientMessageTransport(), req.getSocketAddress(), req.getTimeoutMillis(), req.getCallback());
                                break;
                            }
                            default: {
                                throw new AssertionError((Object)("Unknown connection request type - " + (Object)((Object)request.getType())));
                            }
                        }
                    }
                    catch (MaxConnectionsExceededException e) {
                        String connInfo = cmt == null ? "" : cmt.getLocalAddress() + "->" + cmt.getRemoteAddress() + " ";
                        cmt.getLogger().error(connInfo + e.getMessage());
                        return;
                    }
                    catch (Throwable t) {
                        if (cmt == null) break block8;
                        cmt.getLogger().warn("Reconnect failed !", t);
                    }
                }
            }
            logger.info("Connection establisher exiting." + System.identityHashCode(this));
        }
    }
}

