/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.version;

import com.tc.util.version.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionRange {
    private static final String VERSION_PATTERN_STR = "^(\\d+(?:\\.\\d+(?:\\.\\d+(?:-\\w+)?)?)?)$";
    private static final Pattern SINGLE_COMMA = Pattern.compile("^([^,]+)?,([^,]+)?$");
    private static final Pattern VERSION = Pattern.compile("^(\\d+(?:\\.\\d+(?:\\.\\d+(?:-\\w+)?)?)?)$");
    private final String minVersion;
    private final String maxVersion;
    private final boolean minIsInclusive;
    private final boolean maxIsInclusive;

    public VersionRange(String versionString) {
        if (versionString == null) {
            throw new NullPointerException();
        }
        if (this.isRange(versionString = versionString.trim())) {
            this.minIsInclusive = versionString.startsWith("[");
            this.maxIsInclusive = versionString.endsWith("]");
            versionString = versionString.replaceFirst("^[\\[(]", "");
            versionString = versionString.replaceFirst("[\\])]$", "");
            if ((versionString = versionString.trim()).endsWith(",")) {
                this.minVersion = this.verifyVersionFormat(versionString.replaceFirst(",$", ""));
                this.maxVersion = "";
            } else if (versionString.startsWith(",")) {
                this.maxVersion = this.verifyVersionFormat(versionString.replaceFirst("^,", ""));
                this.minVersion = "";
            } else {
                String[] pair = versionString.split(",");
                if (pair.length != 2) {
                    throw new AssertionError((Object)("Unexpected number of elements (" + pair.length + "): " + versionString));
                }
                for (int i = 0; i < pair.length; ++i) {
                    pair[i] = pair[i].trim();
                }
                this.minVersion = this.verifyVersionFormat(pair[0]);
                this.maxVersion = this.verifyVersionFormat(pair[1]);
            }
        } else {
            this.minVersion = this.verifyVersionFormat(versionString);
            this.maxVersion = this.verifyVersionFormat(versionString);
            this.minIsInclusive = true;
            this.maxIsInclusive = true;
        }
    }

    private String verifyVersionFormat(String ver) {
        Matcher matcher = VERSION.matcher(ver);
        if (matcher.matches()) {
            return ver;
        }
        throw new IllegalArgumentException("Unexpected version string format: " + ver);
    }

    private boolean isRange(String ver) {
        if (ver.startsWith("[") || ver.startsWith("(")) {
            if (ver.endsWith("]") || ver.endsWith(")")) {
                Matcher matcher = SINGLE_COMMA.matcher(ver);
                if (matcher.matches()) {
                    return true;
                }
                throw new IllegalArgumentException("Apparent version range missing single comma: " + ver);
            }
            throw new IllegalArgumentException("Version string missing proper trailing character: " + ver);
        }
        return false;
    }

    public String getMinVersion() {
        return this.minVersion;
    }

    public String getMaxVersion() {
        return this.maxVersion;
    }

    public boolean isMinInclusive() {
        return this.minIsInclusive;
    }

    public boolean isMaxInclusive() {
        return this.maxIsInclusive;
    }

    public boolean contains(String otherVersionStr) {
        if (!Version.isValidVersionString(otherVersionStr)) {
            return false;
        }
        Version otherVersion = new Version(otherVersionStr);
        int compareMin = this.isMinUnbounded() ? 1 : otherVersion.compareTo(new Version(this.minVersion));
        int compareMax = this.isMaxUnbounded() ? -1 : otherVersion.compareTo(new Version(this.maxVersion));
        boolean greaterThanMin = compareMin > 0 || this.isMinInclusive() && compareMin == 0;
        boolean lessThanMax = compareMax < 0 || this.isMaxInclusive() && compareMax == 0;
        return greaterThanMin && lessThanMax;
    }

    public boolean isMaxUnbounded() {
        return this.maxVersion.length() == 0;
    }

    public boolean isMinUnbounded() {
        return this.minVersion.length() == 0;
    }
}

