/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.runnel.decoding.fields;

import java.io.PrintStream;
import org.terracotta.runnel.decoding.fields.AbstractField;
import org.terracotta.runnel.decoding.fields.Field;
import org.terracotta.runnel.utils.ReadBuffer;

public class ArrayField
extends AbstractField {
    private final Field arrayedField;

    public ArrayField(String name, int index, Field arrayedField) {
        super(name, index);
        this.arrayedField = arrayedField;
    }

    public Field subField() {
        return this.arrayedField;
    }

    @Override
    public void dump(ReadBuffer parentBuffer, PrintStream out, int depth) {
        int fieldSize = parentBuffer.getVlqInt();
        out.append(" size: ").append(Integer.toString(fieldSize));
        ReadBuffer readBuffer = parentBuffer.limit(fieldSize);
        out.append(" type: ").append(this.getClass().getSimpleName());
        int length = readBuffer.getVlqInt();
        out.append(" length: ").append(Integer.toString(length));
        Field subField = this.subField();
        for (int i = 0; i < length; ++i) {
            out.append("\n  ");
            for (int j = 0; j < depth; ++j) {
                out.append("  ");
            }
            subField.dump(readBuffer, out, depth + 1);
        }
    }
}

