/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.utilities.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;

public final class CapturedPrintStream
extends PrintStream {
    private CapturedPrintStream() throws UnsupportedEncodingException {
        super((OutputStream)new LocalBufferedOutputStream(4096), false, StandardCharsets.UTF_8.name());
    }

    public static CapturedPrintStream getInstance() {
        try {
            return new CapturedPrintStream();
        }
        catch (UnsupportedEncodingException e) {
            throw new AssertionError("Unexpected exception creating CapturedPrintStream", e);
        }
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.toByteArray()), StandardCharsets.UTF_8), 4096);
    }

    public void reset() {
        this.flush();
        ((LocalBufferedOutputStream)this.out).reset();
    }

    public byte[] toByteArray() {
        this.flush();
        return ((LocalBufferedOutputStream)this.out).toByteArray();
    }

    private static final class LocalBufferedOutputStream
    extends BufferedOutputStream {
        LocalBufferedOutputStream(int size) {
            super(new ByteArrayOutputStream(size), size);
        }

        void reset() {
            ((ByteArrayOutputStream)this.out).reset();
        }

        byte[] toByteArray() {
            return ((ByteArrayOutputStream)this.out).toByteArray();
        }
    }
}

