/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.entity;

import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.InvocationCallback;

public interface Invocation<R> {
    public Task invoke(InvocationCallback<R> var1, Set<InvocationCallback.Types> var2);

    default public Future<R> invoke() {
        return this.invokeAnd(InvocationCallback.Types.COMPLETE);
    }

    default public Future<R> invokeAndRetire() {
        return this.invokeAnd(InvocationCallback.Types.RETIRED);
    }

    default public Future<R> invokeAnd(final InvocationCallback.Types waitFor) {
        final CompletableFuture future = new CompletableFuture();
        final Task task = this.invoke(new InvocationCallback<R>(){
            private volatile R response;

            @Override
            public void sent() {
                this.notify(InvocationCallback.Types.SENT);
            }

            @Override
            public void received() {
                this.notify(InvocationCallback.Types.RECEIVED);
            }

            @Override
            public void result(R response) {
                this.response = response;
                this.notify(InvocationCallback.Types.RESULT);
            }

            @Override
            public void complete() {
                this.notify(InvocationCallback.Types.COMPLETE);
            }

            @Override
            public void retired() {
                this.notify(InvocationCallback.Types.RETIRED);
            }

            private void notify(InvocationCallback.Types callback) {
                if (callback.equals((Object)waitFor)) {
                    future.complete(this.response);
                }
            }

            @Override
            public void failure(Throwable failure) {
                future.completeExceptionally(failure);
            }
        }, EnumSet.of(InvocationCallback.Types.RESULT, InvocationCallback.Types.FAILURE, waitFor));
        return new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return task.cancel() && future.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return future.isCancelled();
            }

            @Override
            public boolean isDone() {
                return future.isDone();
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return future.get();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return future.get(timeout, unit);
            }
        };
    }

    public static <R> R synchronouslyGet(Future<R> future) throws InterruptedException {
        return Invocation.synchronouslyGet(future, RuntimeException.class);
    }

    public static <R, T extends Throwable> R synchronouslyGet(Future<R> future, Class<T> propagate) throws InterruptedException, T {
        try {
            return future.get();
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (propagate.isInstance(cause)) {
                throw (Throwable)propagate.cast(cause);
            }
            throw new RuntimeException(cause);
        }
    }

    public static <R> R synchronouslyGet(Future<R> future, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        return Invocation.synchronouslyGet(future, timeout, unit, RuntimeException.class);
    }

    public static <R, T extends Throwable> R synchronouslyGet(Future<R> future, long timeout, TimeUnit unit, Class<T> propagate) throws InterruptedException, TimeoutException, T {
        try {
            return future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            if (propagate.isInstance(cause)) {
                throw (Throwable)propagate.cast(cause);
            }
            throw new RuntimeException(cause);
        }
    }

    public static <R> R uninterruptiblyGet(Future<R> future) {
        return Invocation.uninterruptiblyGet(future, RuntimeException.class);
    }

    public static <R, T extends Throwable> R uninterruptiblyGet(Future<R> future, Class<T> propagate) throws T {
        boolean interrupted = Thread.interrupted();
        while (true) {
            try {
                R r = Invocation.synchronouslyGet(future, propagate);
                return r;
            }
            catch (InterruptedException e) {
                interrupted = true;
                continue;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static interface Task {
        public boolean cancel();
    }
}

