/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.common.struct;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.terracotta.common.struct.Unit;

public enum TimeUnit implements Unit<TimeUnit>
{
    MILLISECONDS("ms", BigInteger.ONE),
    SECONDS("s", BigInteger.valueOf(1000L)),
    MINUTES("m", BigInteger.valueOf(60000L)),
    HOURS("h", BigInteger.valueOf(3600000L));

    private final String shortName;
    private final BigInteger factor;

    private TimeUnit(String shortName, BigInteger factor) {
        this.shortName = shortName;
        this.factor = factor;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public BigInteger convert(BigInteger quantity, TimeUnit unit) {
        if (this == unit) {
            return quantity;
        }
        return quantity.multiply(unit.factor).divide(this.factor);
    }

    @Override
    public TimeUnit getBaseUnit() {
        return SECONDS;
    }

    public String toString() {
        return this.getShortName();
    }

    public long toMillis(long quantity) {
        return MILLISECONDS.convert(quantity, this);
    }

    public long toSeconds(long quantity) {
        return SECONDS.convert(quantity, this);
    }

    public long toMinutes(long quantity) {
        return MINUTES.convert(quantity, this);
    }

    public long toHours(long quantity) {
        return HOURS.convert(quantity, this);
    }

    public static Optional<TimeUnit> from(String shortName) {
        return Arrays.stream(TimeUnit.values()).filter(timeUnit -> timeUnit.shortName.equals(shortName)).findFirst();
    }

    public static Optional<TimeUnit> from(java.util.concurrent.TimeUnit jdkTimeUnit) {
        return Stream.of(TimeUnit.values()).filter(unit -> unit.name().equals(jdkTimeUnit.name())).findFirst();
    }
}

