/*
 * Decompiled with CFR 0.152.
 */
package com.tc.entity;

import com.tc.bytes.TCByteBuffer;
import com.tc.entity.VoltronEntityMessage;
import com.tc.io.TCByteBufferInput;
import com.tc.io.TCByteBufferOutput;
import com.tc.io.TCSerializable;
import com.tc.net.ClientID;
import com.tc.object.EntityDescriptor;
import com.tc.object.tx.TransactionID;
import com.tc.util.Assert;
import java.io.IOException;
import org.terracotta.entity.EntityMessage;

public class ResendVoltronEntityMessage
implements VoltronEntityMessage,
TCSerializable<ResendVoltronEntityMessage> {
    private ClientID source;
    private TransactionID transactionID;
    private EntityDescriptor entityDescriptor;
    private VoltronEntityMessage.Type type;
    private boolean requiresReplication;
    private TCByteBuffer extendedData;
    private TransactionID oldestTransactionPending;

    public ResendVoltronEntityMessage() {
    }

    public ResendVoltronEntityMessage(ClientID source, TransactionID transactionID, EntityDescriptor entityDescriptor, VoltronEntityMessage.Type type, boolean requiresReplication, TCByteBuffer extendedData, TransactionID oldestTransactionPending) {
        this.source = source;
        this.transactionID = transactionID;
        this.entityDescriptor = entityDescriptor;
        this.type = type;
        this.requiresReplication = requiresReplication;
        this.extendedData = extendedData == null || extendedData.isReadOnly() ? extendedData : extendedData.asReadOnlyBuffer();
        this.oldestTransactionPending = oldestTransactionPending;
    }

    @Override
    public ClientID getSource() {
        Assert.assertNotNull(this.source);
        return this.source;
    }

    @Override
    public TransactionID getTransactionID() {
        Assert.assertNotNull(this.transactionID);
        return this.transactionID;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        Assert.assertNotNull(this.entityDescriptor);
        return this.entityDescriptor;
    }

    @Override
    public boolean doesRequireReplication() {
        return this.requiresReplication;
    }

    @Override
    public boolean doesRequestReceived() {
        return false;
    }

    @Override
    public boolean doesRequestRetired() {
        return false;
    }

    @Override
    public VoltronEntityMessage.Type getVoltronType() {
        Assert.assertNotNull((Object)this.type);
        return this.type;
    }

    @Override
    public TCByteBuffer getExtendedData() {
        Assert.assertNotNull(this.extendedData);
        return this.extendedData.duplicate();
    }

    @Override
    public TransactionID getOldestTransactionOnClient() {
        return this.oldestTransactionPending;
    }

    @Override
    public void serializeTo(TCByteBufferOutput serialOutput) {
        this.source.serializeTo(serialOutput);
        serialOutput.writeLong(this.transactionID.toLong());
        this.entityDescriptor.serializeTo(serialOutput);
        serialOutput.writeInt(this.type.ordinal());
        serialOutput.writeBoolean(this.requiresReplication);
        serialOutput.writeInt(this.extendedData.remaining());
        serialOutput.write(this.extendedData.duplicate());
        serialOutput.writeLong(this.oldestTransactionPending.toLong());
    }

    @Override
    public ResendVoltronEntityMessage deserializeFrom(TCByteBufferInput serialInput) throws IOException {
        this.source = ClientID.readFrom(serialInput);
        this.transactionID = new TransactionID(serialInput.readLong());
        this.entityDescriptor = EntityDescriptor.readFrom(serialInput);
        this.type = VoltronEntityMessage.Type.values()[serialInput.readInt()];
        this.requiresReplication = serialInput.readBoolean();
        int bufferLength = serialInput.readInt();
        this.extendedData = serialInput.read(bufferLength);
        this.oldestTransactionPending = new TransactionID(serialInput.readLong());
        return this;
    }

    @Override
    public EntityMessage getEntityMessage() {
        return null;
    }
}

