/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.entity.topology.common;

import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Properties;
import java.util.stream.IntStream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.service.ClusterFactory;
import org.terracotta.dynamic_config.api.service.Props;
import org.terracotta.dynamic_config.entity.topology.common.Message;
import org.terracotta.dynamic_config.entity.topology.common.Response;
import org.terracotta.dynamic_config.entity.topology.common.Type;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.runnel.EnumMappingBuilder;
import org.terracotta.runnel.Struct;
import org.terracotta.runnel.StructBuilder;
import org.terracotta.runnel.decoding.StructDecoder;
import org.terracotta.runnel.encoding.StructEncoder;

public class Codec
implements MessageCodec<Message, Response> {
    private static final DateTimeFormatter DT_FORMATTER = DateTimeFormatter.ofPattern("yyyy/MM/dd", Locale.ENGLISH);
    private final Struct struct = StructBuilder.newStructBuilder().enm("type", 10, EnumMappingBuilder.newEnumMappingBuilder(Type.class).mapping(Type.REQ_LICENSE, 1).mapping(Type.REQ_HAS_INCOMPLETE_CHANGE, 2).mapping(Type.REQ_MUST_BE_RESTARTED, 3).mapping(Type.REQ_RUNTIME_CLUSTER, 4).mapping(Type.REQ_UPCOMING_CLUSTER, 5).mapping(Type.EVENT_NODE_ADDITION, 6).mapping(Type.EVENT_NODE_REMOVAL, 7).mapping(Type.EVENT_SETTING_CHANGED, 8).mapping(Type.EVENT_STRIPE_ADDITION, 9).mapping(Type.EVENT_STRIPE_REMOVAL, 10).build()).struct(Type.REQ_LICENSE.name(), 20, StructBuilder.newStructBuilder().string("date", 10).structs("limits", 20, StructBuilder.newStructBuilder().string("name", 10).int64("value", 20).build()).structs("flags", 30, StructBuilder.newStructBuilder().string("name", 10).bool("value", 20).build()).build()).bool(Type.REQ_HAS_INCOMPLETE_CHANGE.name(), 30).bool(Type.REQ_MUST_BE_RESTARTED.name(), 40).string(Type.REQ_RUNTIME_CLUSTER.name(), 50).string(Type.REQ_UPCOMING_CLUSTER.name(), 60).struct(Type.EVENT_NODE_ADDITION.name(), 70, StructBuilder.newStructBuilder().string("stripeUID", 10).string("node", 20).build()).struct(Type.EVENT_NODE_REMOVAL.name(), 80, StructBuilder.newStructBuilder().string("stripeUID", 10).string("node", 20).build()).struct(Type.EVENT_SETTING_CHANGED.name(), 90, StructBuilder.newStructBuilder().string("configuration", 10).string("cluster", 20).build()).string(Type.EVENT_STRIPE_ADDITION.name(), 100).string(Type.EVENT_STRIPE_REMOVAL.name(), 110).build();

    @Override
    public byte[] encodeMessage(Message message) throws MessageCodecException {
        try {
            return ((StructEncoder)this.struct.encoder().enm("type", (Object)message.getType())).encode().array();
        }
        catch (RuntimeException e) {
            throw new MessageCodecException(e.getMessage(), e);
        }
    }

    @Override
    public Message decodeMessage(byte[] bytes) throws MessageCodecException {
        try {
            return new Message((Type)((Object)this.struct.decoder(ByteBuffer.wrap(bytes)).enm("type").get()));
        }
        catch (RuntimeException e) {
            throw new MessageCodecException(e.getMessage(), e);
        }
    }

    @Override
    public byte[] encodeResponse(Response response) throws MessageCodecException {
        try {
            Type type = response.getType();
            StructEncoder<Void> encoder = this.struct.encoder();
            encoder.enm("type", (Object)type);
            switch (type) {
                case REQ_LICENSE: {
                    License license = (License)response.getPayload();
                    if (license == null) break;
                    ((StructEncoder)encoder.struct(type.name()).string("date", license.getExpiryDate().format(DT_FORMATTER))).structs("limits", license.getCapabilityLimitMap().entrySet(), (entryEncoder, entry) -> ((StructEncoder)entryEncoder.string("name", (String)entry.getKey())).int64("value", (Long)entry.getValue())).structs("flags", license.getFlagsMap().entrySet(), (entryEncoder, entry) -> ((StructEncoder)entryEncoder.string("name", (String)entry.getKey())).bool("value", (Boolean)entry.getValue()));
                    break;
                }
                case REQ_HAS_INCOMPLETE_CHANGE: 
                case REQ_MUST_BE_RESTARTED: {
                    encoder.bool(type.name(), (Boolean)response.getPayload());
                    break;
                }
                case REQ_RUNTIME_CLUSTER: 
                case REQ_UPCOMING_CLUSTER: {
                    encoder.string(type.name(), this.encodeCluster((Cluster)response.getPayload()));
                    break;
                }
                case EVENT_NODE_ADDITION: 
                case EVENT_NODE_REMOVAL: {
                    List oo = (List)response.getPayload();
                    ((StructEncoder)encoder.struct(type.name()).string("stripeUID", oo.get(0).toString())).string("node", this.encodeNode((Node)oo.get(1)));
                    break;
                }
                case EVENT_SETTING_CHANGED: {
                    List oo = (List)response.getPayload();
                    ((StructEncoder)encoder.struct(type.name()).string("configuration", this.encodeConfiguration((Configuration)oo.get(0)))).string("cluster", this.encodeCluster((Cluster)oo.get(1)));
                    break;
                }
                case EVENT_STRIPE_ADDITION: 
                case EVENT_STRIPE_REMOVAL: {
                    encoder.string(type.name(), this.encodeStripe((Stripe)response.getPayload()));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(type.name());
                }
            }
            return encoder.encode().array();
        }
        catch (RuntimeException e) {
            throw new MessageCodecException(e.getMessage(), e);
        }
    }

    @Override
    public Response decodeResponse(byte[] bytes) throws MessageCodecException {
        try {
            StructDecoder<Void> decoder = this.struct.decoder(ByteBuffer.wrap(bytes));
            Type type = (Type)((Object)decoder.enm("type").get());
            switch (type) {
                case REQ_LICENSE: {
                    StructDecoder<StructDecoder<Void>> payload = decoder.struct(type.name());
                    if (payload == null) {
                        return new Response(type, null);
                    }
                    LocalDate expiryDate = LocalDate.parse(payload.string("date"), DT_FORMATTER);
                    HashMap<String, Long> limits = new HashMap<String, Long>();
                    payload.structs("limits").forEachRemaining(entry -> limits.put(entry.string("name"), entry.int64("value")));
                    HashMap<String, Boolean> flags = new HashMap<String, Boolean>();
                    payload.structs("flags").forEachRemaining(entry -> flags.put(entry.string("name"), entry.bool("value")));
                    return new Response(type, new License(limits, flags, expiryDate));
                }
                case REQ_HAS_INCOMPLETE_CHANGE: 
                case REQ_MUST_BE_RESTARTED: {
                    return new Response(type, decoder.bool(type.name()));
                }
                case REQ_RUNTIME_CLUSTER: 
                case REQ_UPCOMING_CLUSTER: {
                    return new Response(type, this.decodeCluster(decoder.string(type.name())));
                }
                case EVENT_NODE_ADDITION: 
                case EVENT_NODE_REMOVAL: {
                    StructDecoder<StructDecoder<Void>> event = decoder.struct(type.name());
                    return new Response(type, Arrays.asList(UID.valueOf(event.string("stripeUID")), this.decodeNode(event.string("node"))));
                }
                case EVENT_SETTING_CHANGED: {
                    StructDecoder<StructDecoder<Void>> event = decoder.struct(type.name());
                    return new Response(type, Arrays.asList(this.decodeConfiguration(event.string("configuration")), this.decodeCluster(event.string("cluster"))));
                }
                case EVENT_STRIPE_ADDITION: 
                case EVENT_STRIPE_REMOVAL: {
                    return new Response(type, this.decodeStripe(decoder.string(type.name())));
                }
            }
            throw new UnsupportedOperationException(type.name());
        }
        catch (RuntimeException e) {
            throw new MessageCodecException(e.getMessage(), e);
        }
    }

    private String encodeCluster(Cluster cluster) {
        Objects.requireNonNull(cluster);
        return Props.toString(cluster.toProperties(false, false, true));
    }

    private Cluster decodeCluster(String payload) {
        Objects.requireNonNull(payload);
        return new ClusterFactory().create(Props.load(payload), configuration -> {});
    }

    private String encodeNode(Node node) {
        Objects.requireNonNull(node);
        return Props.toString(node.toProperties(false, false, true));
    }

    private Node decodeNode(String payload) {
        Objects.requireNonNull(payload);
        Properties properties = Props.load(payload);
        Node node = new Node();
        Cluster cluster = new Cluster(new Stripe().addNode(node));
        properties.stringPropertyNames().forEach(key -> Configuration.valueOf("stripe.1.node.1." + key, properties.getProperty((String)key)).apply(cluster));
        return node;
    }

    private String encodeStripe(Stripe stripe) {
        Objects.requireNonNull(stripe);
        Properties props = stripe.toProperties(false, false, true);
        props.setProperty("nodes", String.valueOf(stripe.getNodeCount()));
        return Props.toString(props);
    }

    private Stripe decodeStripe(String payload) {
        Objects.requireNonNull(payload);
        Properties properties = Props.load(payload);
        int count = Integer.parseInt(properties.remove("nodes").toString());
        Stripe stripe = new Stripe();
        Cluster cluster = new Cluster(stripe);
        IntStream.rangeClosed(1, count).forEach(idx -> stripe.addNode(new Node()));
        properties.stringPropertyNames().forEach(key -> Configuration.valueOf("stripe.1." + key, properties.getProperty((String)key)).apply(cluster));
        return stripe;
    }

    private String encodeConfiguration(Configuration configuration) {
        Objects.requireNonNull(configuration);
        return configuration.toString();
    }

    private Configuration decodeConfiguration(String payload) {
        Objects.requireNonNull(payload);
        return Configuration.valueOf(payload);
    }
}

