/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.UID;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.service.Props;

public class Stripe
implements Cloneable,
PropertyHolder {
    private List<Node> nodes = new CopyOnWriteArrayList<Node>();
    private UID uid;
    private String name;

    public List<Node> getNodes() {
        return Collections.unmodifiableList(this.nodes);
    }

    public Stripe setNodes(List<Node> nodes) {
        this.nodes = new CopyOnWriteArrayList<Node>(nodes);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Stripe setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    @Override
    public UID getUID() {
        return this.uid;
    }

    public Stripe setUID(UID uid) {
        this.uid = Objects.requireNonNull(uid);
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Stripe stripe = (Stripe)o;
        return this.nodes.equals(stripe.nodes) && Objects.equals(this.name, stripe.name) && Objects.equals(this.uid, stripe.uid);
    }

    public int hashCode() {
        return Objects.hash(this.nodes, this.name, this.uid);
    }

    public String toString() {
        return Props.toString(this.toProperties(false, false, true));
    }

    public String toShapeString() {
        return this.name + ":" + this.uid + " ( " + this.nodes.stream().map(Node::toShapeString).collect(Collectors.joining(", ")) + " )";
    }

    public Optional<Node> getSingleNode() throws IllegalStateException {
        if (this.nodes.size() > 1) {
            throw new IllegalStateException();
        }
        if (this.nodes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.nodes.iterator().next());
    }

    public Optional<Node> getNode(UID uid) {
        return this.nodes.stream().filter(node -> node.getUID().equals(uid)).findAny();
    }

    public Optional<Node> getNode(String nodeName) {
        return this.nodes.stream().filter(node -> node.getName().equals(nodeName)).findAny();
    }

    public boolean containsNode(UID uid) {
        return this.nodes.stream().anyMatch(node -> node.getUID().equals(uid));
    }

    public boolean containsNode(String nodeName) {
        return this.nodes.stream().anyMatch(node -> node.getName().equals(nodeName));
    }

    public Collection<Node.Endpoint> getEndpoints(InetSocketAddress initiator) {
        Function<Node, Node.Endpoint> fetcher = this.getEndpointFetcher(initiator);
        return this.getNodes().stream().map(fetcher).collect(Collectors.toList());
    }

    public Collection<Node.Endpoint> getSimilarEndpoints(Node.Endpoint initiator) {
        return this.getNodes().stream().map(node -> node.getSimilarEndpoints(initiator)).collect(Collectors.toList());
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Stripe clone() {
        Stripe copy = new Stripe();
        copy.nodes = this.nodes.stream().map(Node::clone).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
        copy.name = this.name;
        copy.uid = this.uid;
        return copy;
    }

    public boolean removeNode(UID uid) {
        return this.nodes.removeIf(node -> node.getUID().equals(uid));
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public Stripe addNode(Node source) {
        this.nodes.add(source);
        return this;
    }

    public Stripe addNodes(Node ... sources) {
        for (Node source : sources) {
            this.addNode(source);
        }
        return this;
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues, boolean includeHiddenSettings, Version version) {
        Properties properties = Setting.modelToProperties(this, expanded, includeDefaultValues, includeHiddenSettings, version);
        for (int i = 0; i < this.nodes.size(); ++i) {
            String prefix = "node." + (i + 1) + ".";
            Properties props = this.nodes.get(i).toProperties(expanded, includeDefaultValues, includeHiddenSettings, version);
            props.stringPropertyNames().forEach(key -> properties.setProperty(prefix + key, props.getProperty((String)key)));
        }
        return properties;
    }

    @Override
    public Stream<? extends PropertyHolder> descendants() {
        return this.nodes.stream();
    }

    @Override
    public Scope getScope() {
        return Scope.STRIPE;
    }

    private Function<Node, Node.Endpoint> getEndpointFetcher(InetSocketAddress initiator) {
        boolean publicAddressConfigured = true;
        for (Node node : this.getNodes()) {
            if (node.getInternalAddress().equals(initiator)) {
                return Node::getInternalEndpoint;
            }
            Optional<InetSocketAddress> publicAddress = node.getPublicAddress();
            publicAddressConfigured &= publicAddress.isPresent();
            if (!publicAddress.isPresent() || !publicAddress.get().equals(initiator)) continue;
            return n -> n.getPublicEndpoint().get();
        }
        return publicAddressConfigured ? n -> n.getPublicEndpoint().get() : Node::getInternalEndpoint;
    }
}

