/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.terracotta.dynamic_config.api.model.OptionalConfig;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.RawPath;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Substitutor;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.inet.InetSocketAddressUtils;

public class Node
implements Cloneable,
PropertyHolder {
    private String uid;
    private String name;
    private String hostname;
    private String publicHostname;
    private Integer port;
    private Integer publicPort;
    private Integer groupPort;
    private String bindAddress;
    private String groupBindAddress;
    private RawPath metadataDir;
    private RawPath logDir;
    private RawPath backupDir;
    private RawPath securityDir;
    private RawPath securityAuditLogDir;
    private Map<String, String> tcProperties;
    private Map<String, String> loggerOverrides;
    private Map<String, RawPath> dataDirs;

    @Override
    public Scope getScope() {
        return Scope.NODE;
    }

    @Override
    public String getUID() {
        return this.uid;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getHostname() {
        return this.hostname;
    }

    public OptionalConfig<String> getPublicHostname() {
        return OptionalConfig.of(Setting.NODE_PUBLIC_HOSTNAME, this.publicHostname);
    }

    public OptionalConfig<Integer> getPort() {
        return OptionalConfig.of(Setting.NODE_PORT, this.port);
    }

    public OptionalConfig<Integer> getPublicPort() {
        return OptionalConfig.of(Setting.NODE_PUBLIC_PORT, this.publicPort);
    }

    public OptionalConfig<Integer> getGroupPort() {
        return OptionalConfig.of(Setting.NODE_GROUP_PORT, this.groupPort);
    }

    public OptionalConfig<String> getBindAddress() {
        return OptionalConfig.of(Setting.NODE_BIND_ADDRESS, this.bindAddress);
    }

    public OptionalConfig<String> getGroupBindAddress() {
        return OptionalConfig.of(Setting.NODE_GROUP_BIND_ADDRESS, this.groupBindAddress);
    }

    public OptionalConfig<RawPath> getMetadataDir() {
        return OptionalConfig.of(Setting.NODE_METADATA_DIR, this.metadataDir);
    }

    public OptionalConfig<RawPath> getLogDir() {
        return OptionalConfig.of(Setting.NODE_LOG_DIR, this.logDir);
    }

    public OptionalConfig<RawPath> getBackupDir() {
        return OptionalConfig.of(Setting.NODE_BACKUP_DIR, this.backupDir);
    }

    public OptionalConfig<RawPath> getSecurityDir() {
        return OptionalConfig.of(Setting.SECURITY_DIR, this.securityDir);
    }

    public OptionalConfig<RawPath> getSecurityAuditLogDir() {
        return OptionalConfig.of(Setting.SECURITY_AUDIT_LOG_DIR, this.securityAuditLogDir);
    }

    public OptionalConfig<Map<String, RawPath>> getDataDirs() {
        return OptionalConfig.of(Setting.DATA_DIRS, this.dataDirs);
    }

    public OptionalConfig<Map<String, String>> getLoggerOverrides() {
        return OptionalConfig.of(Setting.NODE_LOGGER_OVERRIDES, this.loggerOverrides);
    }

    public OptionalConfig<Map<String, String>> getTcProperties() {
        return OptionalConfig.of(Setting.TC_PROPERTIES, this.tcProperties);
    }

    public Node setUID(String uid) {
        this.uid = Objects.requireNonNull(uid);
        return this;
    }

    public Node setName(String name) {
        this.name = Objects.requireNonNull(name);
        return this;
    }

    public Node setHostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname);
        return this;
    }

    public Node setPublicHostname(String publicHostname) {
        this.publicHostname = publicHostname;
        return this;
    }

    public Node setPort(Integer port) {
        this.port = port;
        return this;
    }

    public Node setPublicPort(Integer publicPort) {
        this.publicPort = publicPort;
        return this;
    }

    public Node setGroupPort(Integer groupPort) {
        this.groupPort = groupPort;
        return this;
    }

    public Node setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
        return this;
    }

    public Node setGroupBindAddress(String groupBindAddress) {
        this.groupBindAddress = groupBindAddress;
        return this;
    }

    public Node setMetadataDir(RawPath metadataDir) {
        this.metadataDir = metadataDir;
        return this;
    }

    public Node setLogDir(RawPath logDir) {
        this.logDir = logDir;
        return this;
    }

    public Node setBackupDir(RawPath backupDir) {
        this.backupDir = backupDir;
        return this;
    }

    public Node setSecurityDir(RawPath securityDir) {
        this.securityDir = securityDir;
        return this;
    }

    public Node setSecurityAuditLogDir(RawPath securityAuditLogDir) {
        this.securityAuditLogDir = securityAuditLogDir;
        return this;
    }

    public Node putLoggerOverride(String logger, String level) {
        return this.putLoggerOverrides(Collections.singletonMap(logger, level));
    }

    public Node putLoggerOverrides(Map<String, String> loggerOverrides) {
        if (this.loggerOverrides == null) {
            this.setLoggerOverrides(Optional.ofNullable(Setting.NODE_LOGGER_OVERRIDES.getDefaultValue()).orElse(Collections.emptyMap()));
        }
        this.loggerOverrides.putAll(loggerOverrides);
        return this;
    }

    public Node setLoggerOverrides(Map<String, String> loggerOverrides) {
        this.loggerOverrides = loggerOverrides == null ? null : new ConcurrentHashMap<String, String>(loggerOverrides);
        return this;
    }

    public Node removeLoggerOverride(String logger) {
        Map def;
        if (this.loggerOverrides == null && (def = (Map)Setting.NODE_LOGGER_OVERRIDES.getDefaultValue()) != null && def.containsKey(logger)) {
            this.setLoggerOverrides(def);
        }
        if (this.loggerOverrides != null) {
            this.loggerOverrides.remove(logger);
        }
        return this;
    }

    public Node unsetLoggerOverrides() {
        if (this.loggerOverrides != null) {
            this.setLoggerOverrides(Collections.emptyMap());
        } else {
            Map def = (Map)Setting.NODE_LOGGER_OVERRIDES.getDefaultValue();
            if (def != null && !def.isEmpty()) {
                this.setLoggerOverrides(Collections.emptyMap());
            }
        }
        return this;
    }

    public Node putTcProperty(String key, String value) {
        return this.putTcProperties(Collections.singletonMap(key, value));
    }

    public Node putTcProperties(Map<String, String> tcProperties) {
        if (this.tcProperties == null) {
            this.setTcProperties(Optional.ofNullable(Setting.TC_PROPERTIES.getDefaultValue()).orElse(Collections.emptyMap()));
        }
        this.tcProperties.putAll(tcProperties);
        return this;
    }

    public Node setTcProperties(Map<String, String> tcProperties) {
        this.tcProperties = tcProperties == null ? null : new ConcurrentHashMap<String, String>(tcProperties);
        return this;
    }

    public Node removeTcProperty(String key) {
        Map def;
        if (this.tcProperties == null && (def = (Map)Setting.TC_PROPERTIES.getDefaultValue()) != null && def.containsKey(key)) {
            this.setTcProperties(def);
        }
        if (this.tcProperties != null) {
            this.tcProperties.remove(key);
        }
        return this;
    }

    public Node unsetTcProperties() {
        if (this.tcProperties != null) {
            this.setTcProperties(Collections.emptyMap());
        } else {
            Map def = (Map)Setting.TC_PROPERTIES.getDefaultValue();
            if (def != null && !def.isEmpty()) {
                this.setTcProperties(Collections.emptyMap());
            }
        }
        return this;
    }

    public Node putDataDir(String name, RawPath path) {
        return this.putDataDirs(Collections.singletonMap(name, path));
    }

    public Node putDataDirs(Map<String, RawPath> dataDirs) {
        if (this.dataDirs == null) {
            this.setDataDirs(Optional.ofNullable(Setting.DATA_DIRS.getDefaultValue()).orElse(Collections.emptyMap()));
        }
        this.dataDirs.putAll(dataDirs);
        return this;
    }

    public Node setDataDirs(Map<String, RawPath> dataDirs) {
        this.dataDirs = dataDirs == null ? null : new ConcurrentHashMap<String, RawPath>(dataDirs);
        return this;
    }

    public Node removeDataDir(String key) {
        Map def;
        if (this.dataDirs == null && (def = (Map)Setting.DATA_DIRS.getDefaultValue()) != null && def.containsKey(key)) {
            this.setDataDirs(def);
        }
        if (this.dataDirs != null) {
            this.dataDirs.remove(key);
        }
        return this;
    }

    public Node unsetDataDirs() {
        if (this.dataDirs != null) {
            this.setDataDirs(Collections.emptyMap());
        } else {
            Map def = (Map)Setting.DATA_DIRS.getDefaultValue();
            if (def != null && !def.isEmpty()) {
                this.setDataDirs(Collections.emptyMap());
            }
        }
        return this;
    }

    public boolean hasAddress(InetSocketAddress address) {
        return InetSocketAddressUtils.areEqual(address, this.getInternalAddress()) || this.getPublicAddress().map(addr -> InetSocketAddressUtils.areEqual(address, addr)).orElse(false) != false;
    }

    public InetSocketAddress getAddress() {
        return this.getPublicAddress().orElseGet(this::getInternalAddress);
    }

    public InetSocketAddress getInternalAddress() {
        String hostname = this.getHostname();
        Integer port = this.getPort().orDefault();
        if (hostname == null || Substitutor.containsSubstitutionParams(hostname)) {
            throw new AssertionError((Object)("Node " + this.name + " is not correctly defined with internal address: " + hostname + ":" + port));
        }
        return InetSocketAddress.createUnresolved(hostname, port);
    }

    public Optional<InetSocketAddress> getPublicAddress() {
        if (this.publicHostname == null || this.publicPort == null) {
            return Optional.empty();
        }
        if (Substitutor.containsSubstitutionParams(this.publicHostname)) {
            throw new AssertionError((Object)("Node " + this.name + " is not correctly defined with public address: " + this.publicHostname + ":" + this.publicPort));
        }
        return Optional.of(InetSocketAddress.createUnresolved(this.publicHostname, this.publicPort));
    }

    @SuppressFBWarnings(value={"CN_IDIOM_NO_SUPER_CALL"})
    public Node clone() {
        Node clone = new Node();
        clone.dataDirs = this.dataDirs == null ? null : new ConcurrentHashMap<String, RawPath>(this.dataDirs);
        clone.backupDir = this.backupDir;
        clone.bindAddress = this.bindAddress;
        clone.groupBindAddress = this.groupBindAddress;
        clone.groupPort = this.groupPort;
        clone.hostname = this.hostname;
        clone.logDir = this.logDir;
        clone.loggerOverrides = this.loggerOverrides == null ? null : new ConcurrentHashMap<String, String>(this.loggerOverrides);
        clone.metadataDir = this.metadataDir;
        clone.name = this.name;
        clone.port = this.port;
        clone.publicHostname = this.publicHostname;
        clone.publicPort = this.publicPort;
        clone.securityAuditLogDir = this.securityAuditLogDir;
        clone.securityDir = this.securityDir;
        clone.tcProperties = this.tcProperties == null ? null : new ConcurrentHashMap<String, String>(this.tcProperties);
        clone.uid = this.uid;
        return clone;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Node node = (Node)o;
        return Objects.equals(this.port, node.port) && Objects.equals(this.groupPort, node.groupPort) && Objects.equals(this.name, node.name) && Objects.equals(this.uid, node.uid) && Objects.equals(this.hostname, node.hostname) && Objects.equals(this.publicHostname, node.publicHostname) && Objects.equals(this.publicPort, node.publicPort) && Objects.equals(this.bindAddress, node.bindAddress) && Objects.equals(this.groupBindAddress, node.groupBindAddress) && Objects.equals(this.metadataDir, node.metadataDir) && Objects.equals(this.logDir, node.logDir) && Objects.equals(this.backupDir, node.backupDir) && Objects.equals(this.loggerOverrides, node.loggerOverrides) && Objects.equals(this.tcProperties, node.tcProperties) && Objects.equals(this.securityDir, node.securityDir) && Objects.equals(this.securityAuditLogDir, node.securityAuditLogDir) && Objects.equals(this.dataDirs, node.dataDirs);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.hostname, this.publicHostname, this.port, this.publicPort, this.groupPort, this.bindAddress, this.groupBindAddress, this.tcProperties, this.loggerOverrides, this.metadataDir, this.logDir, this.backupDir, this.securityDir, this.securityAuditLogDir, this.dataDirs, this.uid);
    }

    public String toString() {
        return "Node{name='" + this.name + '\'' + ", hostname='" + this.hostname + '\'' + ", port=" + this.port + ", uid=" + this.uid + ", publicHostname='" + this.publicHostname + '\'' + ", publicPort=" + this.publicPort + ", groupPort=" + this.groupPort + ", bindAddress='" + this.bindAddress + '\'' + ", groupBindAddress='" + this.groupBindAddress + '\'' + ", metadataDir='" + this.metadataDir + '\'' + ", logDir='" + this.logDir + '\'' + ", backupDir='" + this.backupDir + '\'' + ", loggers='" + this.loggerOverrides + '\'' + ", tcProperties='" + this.tcProperties + '\'' + ", securityDir='" + this.securityDir + '\'' + ", securityAuditLogDir='" + this.securityAuditLogDir + '\'' + ", dataDirs=" + this.dataDirs + '}';
    }

    @Override
    public Properties toProperties(boolean expanded, boolean includeDefaultValues, boolean includeHiddenSettings, Version version) {
        return Setting.modelToProperties(this, expanded, includeDefaultValues, includeHiddenSettings, version);
    }
}

