/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.service;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Version;
import org.terracotta.dynamic_config.api.service.ClusterValidator;
import org.terracotta.dynamic_config.api.service.ConfigurationParser;
import org.terracotta.dynamic_config.api.service.IParameterSubstitutor;
import org.terracotta.dynamic_config.api.service.Props;

public class ClusterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterFactory.class);
    private final Version version;

    public ClusterFactory() {
        this(Version.CURRENT);
    }

    public ClusterFactory(Version version) {
        this.version = version;
    }

    public Cluster create(Path configFile) {
        return this.create(Props.load(configFile));
    }

    public Cluster create(Properties properties) {
        TreeSet<Configuration> defaultsAdded = new TreeSet<Configuration>(Comparator.comparing(Configuration::toString));
        Cluster cluster = this.create(properties, defaultsAdded::add);
        LOGGER.trace(String.format("%sRead the following configurations: %s%sAdded the following defaults: %s", System.lineSeparator(), this.toDisplayParams(properties), System.lineSeparator(), this.toDisplayParams(defaultsAdded)));
        return this.validated(cluster);
    }

    public Cluster create(Properties properties, Consumer<Configuration> added) {
        return ConfigurationParser.parsePropertyConfiguration(properties, this.version, added);
    }

    public Cluster create(Map<Setting, String> paramValueMap, IParameterSubstitutor parameterSubstitutor) {
        paramValueMap = new HashMap<Setting, String>(paramValueMap);
        TreeSet<Configuration> defaultsAdded = new TreeSet<Configuration>(Comparator.comparing(Configuration::toString));
        Cluster cluster = ConfigurationParser.parseCommandLineParameters(paramValueMap, parameterSubstitutor, defaultsAdded::add);
        LOGGER.trace(String.format("%sRead the following parameters: %s%sAdded the following defaults: %s", System.lineSeparator(), this.toDisplayParams("--", paramValueMap, parameterSubstitutor), System.lineSeparator(), this.toDisplayParams("--", defaultsAdded.stream().filter(configuration -> configuration.getValue().isPresent()).collect(Collectors.toMap(Configuration::getSetting, cfg -> cfg.getValue().get())), parameterSubstitutor)));
        return this.validated(cluster);
    }

    private Cluster validated(Cluster cluster) {
        new ClusterValidator(cluster).validate(this.version);
        return cluster;
    }

    private String toDisplayParams(String prefix, Map<Setting, String> supplied, IParameterSubstitutor parameterSubstitutor) {
        String suppliedParameters = supplied.entrySet().stream().filter(e -> e.getValue() != null).sorted(Map.Entry.comparingByKey()).map(entry -> prefix + entry.getKey() + "=" + parameterSubstitutor.substitute((String)entry.getValue())).collect(Collectors.joining(System.lineSeparator() + "    ", "    ", ""));
        suppliedParameters = suppliedParameters.trim().isEmpty() ? "[]" : System.lineSeparator() + suppliedParameters;
        return suppliedParameters;
    }

    private String toDisplayParams(Properties properties) {
        String suppliedParameters = properties.entrySet().stream().filter(e -> e.getValue() != null && !e.getValue().equals("")).sorted(Comparator.comparing(e -> e.getKey().toString())).map(entry -> entry.getKey() + "=" + entry.getValue()).collect(Collectors.joining(System.lineSeparator() + "    ", "    ", ""));
        suppliedParameters = suppliedParameters.trim().isEmpty() ? "[]" : System.lineSeparator() + suppliedParameters;
        return suppliedParameters;
    }

    private String toDisplayParams(Collection<Configuration> configurations) {
        String suppliedParameters = configurations.stream().filter(c -> c.getValue().isPresent()).map(Configuration::toString).sorted().collect(Collectors.joining(System.lineSeparator() + "    ", "    ", ""));
        suppliedParameters = suppliedParameters.trim().isEmpty() ? "[]" : System.lineSeparator() + suppliedParameters;
        return suppliedParameters;
    }
}

