/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.inet;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.terracotta.inet.HostAndIpValidator;

public class InetSocketAddressConverter {
    private static final String INVALID_HOST_OR_IP_MESSAGE = "Server must be an RFC 1123 compliant hostname or a valid IP address";

    public static InetSocketAddress getInetSocketAddress(String server) {
        return InetSocketAddressConverter.getInetSocketAddress(server, 9410);
    }

    public static InetSocketAddress getInetSocketAddress(String hostPort, int defaultPort) {
        int lastColon = hostPort.lastIndexOf(":");
        if (lastColon == -1) {
            if (!HostAndIpValidator.isValidIPv4(hostPort) && !HostAndIpValidator.isValidHost(hostPort)) {
                throw new IllegalArgumentException(INVALID_HOST_OR_IP_MESSAGE);
            }
            return InetSocketAddress.createUnresolved(hostPort, defaultPort);
        }
        if (HostAndIpValidator.isValidIPv6(hostPort)) {
            return InetSocketAddress.createUnresolved(hostPort, defaultPort);
        }
        int port = Integer.parseInt(hostPort.substring(lastColon + 1));
        String hostOrIp = hostPort.substring(0, lastColon);
        if (!(HostAndIpValidator.isValidIPv4(hostOrIp) || HostAndIpValidator.isValidHost(hostOrIp) || HostAndIpValidator.isValidIPv6(hostOrIp, true))) {
            throw new IllegalArgumentException(INVALID_HOST_OR_IP_MESSAGE);
        }
        return InetSocketAddress.createUnresolved(hostOrIp, port);
    }

    public static List<InetSocketAddress> getInetSocketAddresses(String[] servers) {
        return InetSocketAddressConverter.getInetSocketAddresses(servers, 0);
    }

    public static List<InetSocketAddress> getInetSocketAddresses(String[] servers, int defaultPort) {
        ArrayList<InetSocketAddress> serversList = new ArrayList<InetSocketAddress>();
        for (String server : servers) {
            serversList.add(InetSocketAddressConverter.getInetSocketAddress(server, defaultPort));
        }
        return serversList;
    }

    public static String toHostPort(InetSocketAddress address) {
        if (HostAndIpValidator.isValidIPv6(address.getHostName(), false)) {
            return "[" + address.getHostName() + "]:" + address.getPort();
        }
        return address.getHostName() + ":" + address.getPort();
    }
}

