/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.PropertyHolder;
import org.terracotta.dynamic_config.api.model.Setting;
import org.terracotta.dynamic_config.api.model.Stripe;

public class Testing {
    public static Cluster newTestCluster(String name, Stripe ... stripes) {
        return Testing.fillDefaults(new Cluster(Arrays.asList(stripes))).setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster() {
        return Testing.newTestCluster((String)null);
    }

    public static Cluster newTestCluster(String name) {
        return Testing.fillDefaults(new Cluster(Collections.emptyList())).setFailoverPriority(FailoverPriority.availability()).setName(name);
    }

    public static Cluster newTestCluster(Stripe ... stripes) {
        return Testing.fillDefaults(new Cluster(stripes)).setFailoverPriority(FailoverPriority.availability());
    }

    public static Node newTestNode(String name, String hostname, int port) {
        return Testing.fillDefaults(new Node()).setName(name).setPort(port).setHostname(hostname);
    }

    public static Node newTestNode(String hostname, int port) {
        return Testing.fillDefaults(new Node()).setPort(port).setHostname(hostname);
    }

    public static Node newTestNode(String name, String hostname) {
        return Testing.fillDefaults(new Node()).setName(name).setHostname(hostname);
    }

    public static Node newTestNode(String hostname) {
        return Testing.fillDefaults(new Node()).setHostname(hostname);
    }

    public static <T extends PropertyHolder> T fillDefaults(T o) {
        Stream.of(Setting.values()).filter(Predicate.isEqual((Object)Setting.NODE_HOSTNAME).negate()).filter(Predicate.isEqual((Object)Setting.NODE_CONFIG_DIR).negate()).filter(Predicate.isEqual((Object)Setting.CLUSTER_NAME).negate()).filter(Predicate.isEqual((Object)Setting.LICENSE_FILE).negate()).filter(s -> s.isScope(o.getScope())).forEach(setting -> setting.fillDefault(o));
        return o;
    }
}

