/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.model;

import java.time.LocalDate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class License {
    private final Map<String, Long> capabilityLimitMap;
    private final LocalDate expiryDate;

    public License(Map<String, Long> capabilityLimitMap, LocalDate expiryDate) {
        this.capabilityLimitMap = Collections.unmodifiableMap(new HashMap<String, Long>(capabilityLimitMap));
        this.expiryDate = expiryDate;
    }

    public LocalDate getExpiryDate() {
        return this.expiryDate;
    }

    public Map<String, Long> getCapabilityLimitMap() {
        return this.capabilityLimitMap;
    }

    public boolean hasCapability(String capability) {
        Long v = this.getLimit(capability);
        return v != null && v != 0L;
    }

    public Long getLimit(String capability) {
        return this.capabilityLimitMap.get(capability);
    }

    public String toString() {
        return "License{capabilityLimitMap=" + this.capabilityLimitMap + ", expiryDate=" + this.expiryDate + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        License license = (License)o;
        return this.capabilityLimitMap.equals(license.capabilityLimitMap) && this.expiryDate.equals(license.expiryDate);
    }

    public int hashCode() {
        return 31 * this.capabilityLimitMap.hashCode() + this.expiryDate.hashCode();
    }
}

