/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.api.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.net.InetSocketAddress;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.terracotta.common.struct.json.StructJsonModule;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.FailoverPriority;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.Node;
import org.terracotta.dynamic_config.api.model.NodeContext;
import org.terracotta.dynamic_config.api.model.Scope;
import org.terracotta.dynamic_config.api.model.Stripe;
import org.terracotta.inet.json.InetJsonModule;
import org.terracotta.json.TerracottaJsonModule;

public class DynamicConfigModelJsonModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;

    public DynamicConfigModelJsonModule() {
        super(DynamicConfigModelJsonModule.class.getSimpleName(), new Version(1, 0, 0, null, null, null));
        this.setMixInAnnotation(NodeContext.class, NodeContextMixin.class);
        this.setMixInAnnotation(Cluster.class, ClusterMixin.class);
        this.setMixInAnnotation(Stripe.class, StripeMixin.class);
        this.setMixInAnnotation(Node.class, NodeMixin.class);
        this.setMixInAnnotation(FailoverPriority.class, FailoverPriorityMixin.class);
        this.setMixInAnnotation(License.class, LicenseMixin.class);
    }

    public Iterable<? extends Module> getDependencies() {
        return Arrays.asList(new Module[]{new TerracottaJsonModule(), new StructJsonModule(), new InetJsonModule(), new Jdk8Module(), new JavaTimeModule()});
    }

    public static class LicenseMixin
    extends License {
        @JsonCreator
        public LicenseMixin(@JsonProperty(value="capabilities", required=true) Map<String, Long> capabilityLimitMap, @JsonProperty(value="expiryDate", required=true) LocalDate expiryDate) {
            super(capabilityLimitMap, expiryDate);
        }
    }

    public static class FailoverPriorityMixin
    extends FailoverPriority {
        public FailoverPriorityMixin(FailoverPriority.Type type, Integer voters) {
            super(type, voters);
        }

        @JsonCreator
        public static FailoverPriority valueOf(String str) {
            return FailoverPriority.valueOf(str);
        }

        @Override
        @JsonValue
        public String toString() {
            return super.toString();
        }
    }

    public static class NodeMixin
    extends Node {
        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public InetSocketAddress getAddress() {
            return super.getAddress();
        }

        @Override
        @JsonIgnore
        public InetSocketAddress getInternalAddress() {
            return super.getInternalAddress();
        }

        @Override
        @JsonIgnore
        public Optional<InetSocketAddress> getPublicAddress() {
            return super.getPublicAddress();
        }
    }

    public static class StripeMixin
    extends Stripe {
        @JsonCreator
        public StripeMixin(@JsonProperty(value="nodes", required=true) List<Node> nodes) {
            super(nodes);
        }

        @Override
        @JsonIgnore
        public Collection<InetSocketAddress> getNodeAddresses() {
            return super.getNodeAddresses();
        }

        @Override
        @JsonIgnore
        public Optional<Node> getSingleNode() throws IllegalStateException {
            return super.getSingleNode();
        }

        @Override
        @JsonIgnore
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public int getNodeCount() {
            return super.getNodeCount();
        }
    }

    public static class ClusterMixin
    extends Cluster {
        @JsonCreator
        protected ClusterMixin(@JsonProperty(value="stripes", required=true) List<Stripe> stripes) {
            super(stripes);
        }

        @Override
        @JsonIgnore
        public Scope getScope() {
            return super.getScope();
        }

        @Override
        @JsonIgnore
        public Optional<Node> getSingleNode() throws IllegalStateException {
            return super.getSingleNode();
        }

        @Override
        @JsonIgnore
        public Optional<Stripe> getSingleStripe() {
            return super.getSingleStripe();
        }

        @Override
        @JsonIgnore
        public boolean isEmpty() {
            return super.isEmpty();
        }

        @Override
        @JsonIgnore
        public Collection<InetSocketAddress> getNodeAddresses() {
            return super.getNodeAddresses();
        }

        @Override
        @JsonIgnore
        public int getNodeCount() {
            return super.getNodeCount();
        }

        @Override
        @JsonIgnore
        public int getStripeCount() {
            return super.getStripeCount();
        }

        @Override
        @JsonIgnore
        public Collection<Node> getNodes() {
            return super.getNodes();
        }

        @Override
        @JsonIgnore
        public Collection<String> getDataDirNames() {
            return super.getDataDirNames();
        }
    }

    public static class NodeContextMixin
    extends NodeContext {
        @JsonCreator
        public NodeContextMixin(@JsonProperty(value="cluster", required=true) Cluster cluster, @JsonProperty(value="stripeId", required=true) int stripeId, @JsonProperty(value="nodeName", required=true) String nodeName) {
            super(cluster, stripeId, nodeName);
        }

        @Override
        @JsonIgnore
        public Node getNode() {
            return super.getNode();
        }

        @Override
        @JsonIgnore
        public Stripe getStripe() {
            return super.getStripe();
        }
    }
}

