/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dynamic_config.entity.topology.client;

import java.time.Duration;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.terracotta.connection.entity.Entity;
import org.terracotta.dynamic_config.api.model.Cluster;
import org.terracotta.dynamic_config.api.model.Configuration;
import org.terracotta.dynamic_config.api.model.License;
import org.terracotta.dynamic_config.api.model.Node;

public interface DynamicTopologyEntity
extends Entity {
    public void setListener(Listener var1);

    public Cluster getUpcomingCluster() throws TimeoutException, InterruptedException;

    public Cluster getRuntimeCluster() throws TimeoutException, InterruptedException;

    public boolean mustBeRestarted() throws TimeoutException, InterruptedException;

    public boolean hasIncompleteChange() throws TimeoutException, InterruptedException;

    public License getLicense() throws TimeoutException, InterruptedException;

    public Future<Void> releaseEntity();

    public static interface Listener {
        default public void onNodeRemoval(int stripeId, Node removedNode) {
        }

        default public void onNodeAddition(int stripeId, Node addedNode) {
        }

        default public void onSettingChange(Configuration configuration, Cluster cluster) {
        }

        default public void onDisconnected() {
        }
    }

    public static class Settings {
        private Duration requestTimeout = Duration.ofSeconds(20L);

        public Duration getRequestTimeout() {
            return this.requestTimeout;
        }

        public Settings setRequestTimeout(Duration requestTimeout) {
            this.requestTimeout = requestTimeout;
            return this;
        }
    }
}

