/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.OrderedEventContext;
import com.tc.async.api.Sink;
import java.util.Comparator;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;

public class OrderedSink<T extends OrderedEventContext>
implements Sink<T> {
    private final Sink<T> sink;
    private final Logger logger;
    private long current = 0L;
    private final SortedSet<T> pending = new TreeSet<T>(new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            long s2;
            long s1 = o1.getSequenceID();
            if (s1 < (s2 = o2.getSequenceID())) {
                return -1;
            }
            if (s1 == s2) {
                return 0;
            }
            return 1;
        }
    });

    public OrderedSink(Logger logger, Sink<T> sink) {
        this.logger = logger;
        this.sink = sink;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void addToSink(T oc) {
        long seq = oc.getSequenceID();
        if (seq == 0L) {
            if (!this.pending.isEmpty()) throw new AssertionError((Object)(this.pending.size() + " messages in pending queue. Message with ID " + (this.current + 1L) + " is missing still but reset was requested"));
            this.logger.debug("Sequence reset. Message with ID " + this.current + " was last before reset");
            this.current = 0L;
            this.sink.addToSink(oc);
            return;
        } else {
            if (seq <= this.current) {
                throw new AssertionError((Object)("Received Event with a sequence less than the current sequence. Current = " + this.current + " Seq Id = " + seq + " Event = " + oc));
            }
            if (seq == this.current + 1L) {
                this.current = seq;
                this.sink.addToSink(oc);
                this.processPendingIfNecessary();
                return;
            } else {
                this.pending.add(oc);
                if (this.pending.size() % 10 != 0) return;
                this.logger.info(this.pending.size() + " messages in pending queue. Message with ID " + (this.current + 1L) + " is missing still");
            }
        }
    }

    private void processPendingIfNecessary() {
        if (!this.pending.isEmpty()) {
            OrderedEventContext oc;
            long seq;
            Iterator i = this.pending.iterator();
            while (i.hasNext() && (seq = (oc = (OrderedEventContext)i.next()).getSequenceID()) == this.current + 1L) {
                this.current = seq;
                this.sink.addToSink(oc);
                i.remove();
            }
        }
    }
}

