/*
 * Decompiled with CFR 0.152.
 */
package com.tc.config.schema;

import com.tc.util.Assert;
import java.net.InetSocketAddress;

public interface L2ConfigForL1 {
    public static final int DEFAULT_PORT = 9410;

    public L2Data[] l2Data();

    public static class L2Data {
        private final InetSocketAddress address;
        private int groupId = -1;
        private final boolean secure;

        public L2Data(InetSocketAddress host) {
            this(host, false);
        }

        public L2Data(InetSocketAddress host, boolean secure) {
            Assert.assertNotNull(host);
            this.address = host.getPort() <= 0 ? InetSocketAddress.createUnresolved(host.getHostString(), 9410) : host;
            this.secure = secure;
        }

        public String host() {
            return this.address.getHostString();
        }

        public int tsaPort() {
            return this.address.getPort();
        }

        public InetSocketAddress address() {
            return this.address;
        }

        public boolean secure() {
            return this.secure;
        }

        public void setGroupId(int gid) {
            Assert.assertTrue(gid >= 0);
            this.groupId = gid;
        }

        public int getGroupId() {
            Assert.assertTrue(this.groupId > -1);
            return this.groupId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.groupId;
            result = 31 * result + this.address.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            L2Data other = (L2Data)obj;
            if (this.groupId != other.groupId) {
                return false;
            }
            return this.address.equals(other.address);
        }

        public String toString() {
            return "L2Data [address=" + this.address + "]";
        }
    }
}

