/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.tripwire;

import java.nio.file.Path;
import org.terracotta.tripwire.DiskMonitor;
import org.terracotta.tripwire.DiskMonitorImpl;
import org.terracotta.tripwire.Event;
import org.terracotta.tripwire.MemoryMonitor;
import org.terracotta.tripwire.MemoryMonitorImpl;
import org.terracotta.tripwire.MessageEvent;
import org.terracotta.tripwire.MonitoringEvent;
import org.terracotta.tripwire.NullEvent;
import org.terracotta.tripwire.StageMonitor;
import org.terracotta.tripwire.StageMonitorImpl;
import org.terracotta.tripwire.TripwireRecording;

public class TripwireFactory {
    private static final boolean ENABLED;

    public static Event createMessageEvent(String eid, int concurrency, String action, long source, String instance, long transaction, String trace) {
        return ENABLED ? new MessageEvent(eid, concurrency, action, source, instance, transaction, trace) : new NullEvent();
    }

    public static Event createStageEvent(String stage, String debug) {
        return ENABLED ? new MonitoringEvent(stage, debug) : new NullEvent();
    }

    public static StageMonitor createStageMonitor(String stage, int threads) {
        return ENABLED ? new StageMonitorImpl(stage, threads) : new StageMonitor(){

            @Override
            public void eventOccurred(int backlog, long value) {
            }

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static DiskMonitor createDiskMonitor(Path path) {
        return ENABLED ? new DiskMonitorImpl(path) : new DiskMonitor(){

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static MemoryMonitor createMemoryMonitor(String name) {
        return ENABLED ? new MemoryMonitorImpl(name) : new MemoryMonitor(){

            @Override
            public void sample(long free, long used) {
            }

            @Override
            public void register() {
            }

            @Override
            public void unregister() {
            }
        };
    }

    public static TripwireRecording createTripwireRecording(String configuration) {
        return TripwireFactory.createTripwireRecording(configuration, null, 5, 0L);
    }

    public static TripwireRecording createTripwireRecording(String configuration, Path dest) {
        return TripwireFactory.createTripwireRecording(configuration, dest, 5, 0L);
    }

    public static TripwireRecording createTripwireRecording(String configuration, Path dest, int maxAge, long maxSize) {
        if (!ENABLED) {
            return new TripwireRecording(configuration, dest, maxAge, maxSize);
        }
        throw new UnsupportedOperationException("tripwire is unavailable");
    }

    public static void main(String[] args) {
        System.out.println(TripwireFactory.createStageEvent("test", "test"));
    }

    static {
        boolean hasJFR = false;
        try {
            Class<?> jfr = Class.forName("jdk.jfr.Event");
            hasJFR = jfr != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ENABLED = hasJFR;
    }
}

