/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourcePool;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ReconnectingServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.EternalChainResolver;
import org.ehcache.clustered.client.internal.store.operations.ExpiryChainResolver;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.common.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.config.ResourceType;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.core.events.StoreEventDispatcher;
import org.ehcache.core.events.StoreEventSink;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventFilter;
import org.ehcache.core.spi.store.events.StoreEventListener;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.AuthoritativeTierOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.event.EventFiring;
import org.ehcache.event.EventOrdering;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.store.BaseStore;
import org.ehcache.impl.store.DefaultStoreEventDispatcher;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.StatefulSerializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.OperationStatistic;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class ClusteredStore<K, V>
extends BaseStore<K, V>
implements AuthoritativeTier<K, V> {
    static final String CHAIN_COMPACTION_THRESHOLD_PROP = "ehcache.client.chain.compaction.threshold";
    static final int DEFAULT_CHAIN_COMPACTION_THRESHOLD = 4;
    private final int chainCompactionLimit = Integer.getInteger("ehcache.client.chain.compaction.threshold", 4);
    protected final OperationsCodec<K, V> codec;
    protected final ChainResolver<K, V> resolver;
    protected final TimeSource timeSource;
    private final DelegatingStoreEventDispatcher<K, V> storeEventDispatcher;
    protected volatile ServerStoreProxy storeProxy;
    private volatile AuthoritativeTier.InvalidationValve invalidationValve;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.GetAndFaultOutcome> getAndFaultObserver;

    protected ClusteredStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, StoreEventDispatcher<K, V> storeEventDispatcher) {
        super(config);
        this.codec = codec;
        this.resolver = resolver;
        this.timeSource = timeSource;
        this.storeEventDispatcher = new DelegatingStoreEventDispatcher<K, V>(storeEventDispatcher);
        this.getObserver = this.createObserver("get", StoreOperationOutcomes.GetOutcome.class, true);
        this.putObserver = this.createObserver("put", StoreOperationOutcomes.PutOutcome.class, true);
        this.removeObserver = this.createObserver("remove", StoreOperationOutcomes.RemoveOutcome.class, true);
        this.putIfAbsentObserver = this.createObserver("putIfAbsent", StoreOperationOutcomes.PutIfAbsentOutcome.class, true);
        this.conditionalRemoveObserver = this.createObserver("conditionalRemove", StoreOperationOutcomes.ConditionalRemoveOutcome.class, true);
        this.replaceObserver = this.createObserver("replace", StoreOperationOutcomes.ReplaceOutcome.class, true);
        this.conditionalReplaceObserver = this.createObserver("conditionalReplace", StoreOperationOutcomes.ConditionalReplaceOutcome.class, true);
        this.getAndFaultObserver = this.createObserver("getAndFault", AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.class, true);
        this.evictionObserver = this.createObserver("eviction", StoreOperationOutcomes.EvictionOutcome.class, false);
    }

    protected ClusteredStore(Store.Configuration<K, V> config, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, ServerStoreProxy proxy, TimeSource timeSource, StoreEventDispatcher<K, V> storeEventDispatcher) {
        this(config, codec, resolver, timeSource, storeEventDispatcher);
        this.storeProxy = proxy;
    }

    protected String getStatisticsTag() {
        return "Clustered";
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        Store.ValueHolder<V> value;
        this.getObserver.begin();
        try {
            value = this.getInternal(key);
        }
        catch (TimeoutException e) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.TIMEOUT);
            return null;
        }
        if (value == null) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            return null;
        }
        this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        return value;
    }

    protected Store.ValueHolder<V> getInternal(K key) throws StoreAccessException, TimeoutException {
        try {
            ServerStoreProxy.ChainEntry entry = this.storeProxy.get(this.extractLongKey(key));
            return this.resolver.resolve(entry, key, this.timeSource.getTimeMillis());
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    protected long extractLongKey(K key) {
        return HashUtils.intHashToLong((int)key.hashCode());
    }

    public boolean containsKey(K key) throws StoreAccessException {
        try {
            return this.getInternal(key) != null;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.putObserver.begin();
        Store.PutStatus status = this.silentPut(key, value);
        switch (status) {
            case PUT: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                break;
            }
            case NOOP: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.NOOP);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid put status: " + status));
            }
        }
        return status;
    }

    protected Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            this.storeProxy.append(extractedKey, payload);
            return Store.PutStatus.PUT;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value, Consumer<Boolean> put) throws StoreAccessException {
        this.putIfAbsentObserver.begin();
        Store.ValueHolder<V> result = this.silentPutIfAbsent(key, value);
        if (result == null) {
            this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
            return null;
        }
        this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
        return result;
    }

    protected Store.ValueHolder<V> silentPutIfAbsent(K key, V value) throws StoreAccessException {
        try {
            PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            ServerStoreProxy.ChainEntry chain = this.storeProxy.getAndAppend(extractedKey, payload);
            return this.resolver.resolve(chain, key, this.timeSource.getTimeMillis(), this.chainCompactionLimit);
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public boolean remove(K key) throws StoreAccessException {
        this.removeObserver.begin();
        if (this.silentRemove(key)) {
            this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            return true;
        }
        this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
        return false;
    }

    protected boolean silentRemove(K key) throws StoreAccessException {
        try {
            RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            ServerStoreProxy.ChainEntry chain = this.storeProxy.getAndAppend(extractedKey, payload);
            return this.resolver.resolve(chain, key, this.timeSource.getTimeMillis()) != null;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    protected Store.ValueHolder<V> silentRemove(K key, V value) throws StoreAccessException {
        try {
            ConditionalRemoveOperation<K, V> operation = new ConditionalRemoveOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            ServerStoreProxy.ChainEntry chain = this.storeProxy.getAndAppend(extractedKey, payload);
            return this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.conditionalRemoveObserver.begin();
        Store.ValueHolder<V> result = this.silentRemove(key, value);
        if (result != null) {
            if (value.equals(result.get())) {
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                return Store.RemoveStatus.REMOVED;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            return Store.RemoveStatus.KEY_PRESENT;
        }
        this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
        return Store.RemoveStatus.KEY_MISSING;
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.replaceObserver.begin();
        Store.ValueHolder<V> result = this.silentReplace(key, value);
        if (result == null) {
            this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
            return null;
        }
        this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
        return result;
    }

    protected Store.ValueHolder<V> silentReplace(K key, V value) throws StoreAccessException {
        try {
            ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            ServerStoreProxy.ChainEntry chain = this.storeProxy.getAndAppend(extractedKey, payload);
            return this.resolver.resolve(chain, key, this.timeSource.getTimeMillis(), this.chainCompactionLimit);
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    protected Store.ValueHolder<V> silentReplace(K key, V oldValue, V newValue) throws StoreAccessException {
        try {
            ConditionalReplaceOperation<K, V> operation = new ConditionalReplaceOperation<K, V>(key, oldValue, newValue, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            ServerStoreProxy.ChainEntry chain = this.storeProxy.getAndAppend(extractedKey, payload);
            return this.resolver.resolve(chain, key, this.timeSource.getTimeMillis(), this.chainCompactionLimit);
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.conditionalReplaceObserver.begin();
        Store.ValueHolder<V> result = this.silentReplace(key, oldValue, newValue);
        if (result != null) {
            if (oldValue.equals(result.get())) {
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                return Store.ReplaceStatus.HIT;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            return Store.ReplaceStatus.MISS_PRESENT;
        }
        this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
        return Store.ReplaceStatus.MISS_NOT_PRESENT;
    }

    public void clear() throws StoreAccessException {
        try {
            this.storeProxy.clear();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return this.storeEventDispatcher;
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        try {
            final Iterator<Chain> chainIterator = this.storeProxy.iterator();
            return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
                private Iterator<? extends Cache.Entry<K, Store.ValueHolder<V>>> chain = this.nextChain();

                public boolean hasNext() {
                    return this.chain.hasNext() || (this.chain = this.nextChain()).hasNext();
                }

                public Cache.Entry<K, Store.ValueHolder<V>> next() {
                    try {
                        return this.chain.next();
                    }
                    catch (NoSuchElementException e) {
                        this.chain = this.nextChain();
                        return this.chain.next();
                    }
                }

                private Iterator<? extends Cache.Entry<K, Store.ValueHolder<V>>> nextChain() {
                    try {
                        Map chainContents;
                        while ((chainContents = ClusteredStore.this.resolver.resolveAll((Chain)chainIterator.next(), ClusteredStore.this.timeSource.getTimeMillis())).isEmpty()) {
                        }
                        return chainContents.entrySet().stream().map(entry -> {
                            final Object key = entry.getKey();
                            final Store.ValueHolder valueHolder = (Store.ValueHolder)entry.getValue();
                            return new Cache.Entry<K, Store.ValueHolder<V>>(){

                                public K getKey() {
                                    return key;
                                }

                                public Store.ValueHolder<V> getValue() {
                                    return valueHolder;
                                }

                                public String toString() {
                                    return this.getKey() + "=" + this.getValue();
                                }
                            };
                        }).iterator();
                    }
                    catch (NoSuchElementException e) {
                        return Collections.emptyIterator();
                    }
                }
            };
        }
        catch (Exception e) {
            return new Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>>(){
                private boolean accessed;

                public boolean hasNext() {
                    return !this.accessed;
                }

                public Cache.Entry<K, Store.ValueHolder<V>> next() throws StoreAccessException {
                    this.accessed = true;
                    throw StorePassThroughException.handleException((Exception)e);
                }
            };
        }
    }

    public Store.ValueHolder<V> getAndCompute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> computeAndGet(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual, Supplier<Boolean> invokeWriter) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        HashMap valueHolderMap = new HashMap();
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            Ehcache.PutAllFunction putAllFunction = (Ehcache.PutAllFunction)remappingFunction;
            Map entriesToRemap = putAllFunction.getEntriesToRemap();
            for (Map.Entry entry : entriesToRemap.entrySet()) {
                Store.PutStatus putStatus = this.silentPut(entry.getKey(), entry.getValue());
                if (putStatus != Store.PutStatus.PUT) continue;
                putAllFunction.getActualPutCount().incrementAndGet();
                valueHolderMap.put(entry.getKey(), new ClusteredValueHolder(entry.getValue()));
            }
        } else if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            Ehcache.RemoveAllFunction removeAllFunction = (Ehcache.RemoveAllFunction)remappingFunction;
            for (K key : keys) {
                boolean removed = this.silentRemove(key);
                if (!removed) continue;
                removeAllFunction.getActualRemoveCount().incrementAndGet();
            }
        } else {
            throw new UnsupportedOperationException("This bulkCompute method is not yet capable of handling generic computation functions");
        }
        return valueHolderMap;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        if (mappingFunction instanceof Ehcache.GetAllFunction) {
            HashMap<K, Store.ValueHolder<V>> map = new HashMap<K, Store.ValueHolder<V>>();
            for (K key : keys) {
                Store.ValueHolder<V> value;
                try {
                    value = this.getInternal(key);
                }
                catch (TimeoutException e) {
                    value = null;
                }
                map.put(key, value);
            }
            return map;
        }
        throw new UnsupportedOperationException("This bulkComputeIfAbsent method is not yet capable of handling generic computation functions");
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        Store.ValueHolder<V> value;
        this.getAndFaultObserver.begin();
        try {
            value = this.getInternal(key);
        }
        catch (TimeoutException e) {
            this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.TIMEOUT);
            return null;
        }
        if (value == null) {
            this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.MISS);
            return null;
        }
        this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.HIT);
        return value;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.computeIfAbsent(key, mappingFunction);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder) {
        return true;
    }

    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
        this.invalidationValve = valve;
    }

    private void setStoreProxy(ServerStoreProxy storeProxy) throws CachePersistenceException {
        this.storeEventDispatcher.setStoreProxy(storeProxy);
        this.storeProxy = storeProxy;
    }

    static class DelegatingStoreEventDispatcher<K, V>
    implements StoreEventDispatcher<K, V> {
        private int listenerCounter;
        private ServerStoreProxy storeProxy;
        private final StoreEventDispatcher<K, V> delegate;

        DelegatingStoreEventDispatcher(StoreEventDispatcher<K, V> delegate) {
            this.delegate = delegate;
        }

        synchronized void setStoreProxy(ServerStoreProxy storeProxy) throws CachePersistenceException {
            if (storeProxy != null && this.listenerCounter > 0) {
                try {
                    storeProxy.enableEvents(true);
                }
                catch (TimeoutException te) {
                    throw new CachePersistenceException("Error enabling events", (Throwable)te);
                }
            }
            this.storeProxy = storeProxy;
        }

        public StoreEventSink<K, V> eventSink() {
            return this.delegate.eventSink();
        }

        public void releaseEventSink(StoreEventSink<K, V> eventSink) {
            this.delegate.releaseEventSink(eventSink);
        }

        public void releaseEventSinkAfterFailure(StoreEventSink<K, V> eventSink, Throwable throwable) {
            this.delegate.releaseEventSinkAfterFailure(eventSink, throwable);
        }

        public void reset(StoreEventSink<K, V> eventSink) {
            this.delegate.reset(eventSink);
        }

        public synchronized void addEventListener(StoreEventListener<K, V> eventListener) {
            if (this.listenerCounter == 0 && this.storeProxy != null) {
                try {
                    this.storeProxy.enableEvents(true);
                }
                catch (TimeoutException te) {
                    throw new RuntimeException("Error enabling events", te);
                }
            }
            if (this.listenerCounter < Integer.MAX_VALUE) {
                ++this.listenerCounter;
            }
            this.delegate.addEventListener(eventListener);
        }

        public synchronized void removeEventListener(StoreEventListener<K, V> eventListener) {
            if (this.listenerCounter == 1 && this.storeProxy != null) {
                try {
                    this.storeProxy.enableEvents(false);
                }
                catch (TimeoutException te) {
                    throw new RuntimeException("Error disabling events", te);
                }
            }
            if (this.listenerCounter > 0) {
                --this.listenerCounter;
            }
            this.delegate.removeEventListener(eventListener);
        }

        public void addEventFilter(StoreEventFilter<K, V> eventFilter) {
            this.delegate.addEventFilter(eventFilter);
        }

        public void setEventOrdering(boolean ordering) {
            this.delegate.setEventOrdering(ordering);
        }

        public boolean isEventOrdering() {
            return this.delegate.isEventOrdering();
        }
    }

    private static class StoreConfig {
        private final ClusteringService.ClusteredCacheIdentifier cacheIdentifier;
        private final Store.Configuration<?, ?> storeConfig;
        private final Consistency consistency;

        StoreConfig(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<?, ?> storeConfig, Consistency consistency) {
            this.cacheIdentifier = cacheIdentifier;
            this.storeConfig = storeConfig;
            this.consistency = consistency;
        }

        public Store.Configuration<?, ?> getStoreConfig() {
            return this.storeConfig;
        }

        public ClusteringService.ClusteredCacheIdentifier getCacheIdentifier() {
            return this.cacheIdentifier;
        }

        public Consistency getConsistency() {
            return this.consistency;
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, ClusteringService.class})
    public static class Provider
    extends BaseStore.BaseStoreProvider
    implements AuthoritativeTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private static final Set<ResourceType<?>> CLUSTER_RESOURCES;
        private volatile ServiceProvider<Service> serviceProvider;
        private volatile ClusteringService clusteringService;
        protected volatile ExecutionService executionService;
        private final Lock connectLock = new ReentrantLock();
        private final Map<Store<?, ?>, StoreConfig> createdStores = new ConcurrentWeakIdentityHashMap();
        private final Map<ClusteredStore<?, ?>, OperationStatistic<?>[]> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();

        protected ClusteredResourceType<ClusteredResourcePool> getResourceType() {
            return ClusteredResourceType.Types.UNKNOWN;
        }

        public <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            ClusteredStore<K, V> store = this.createStoreInternal(storeConfig, serviceConfigs);
            this.tierOperationStatistics.put(store, new OperationStatistic[]{this.createTranslatedStatistic(store, "get", TierOperationOutcomes.GET_TRANSLATION, "get"), this.createTranslatedStatistic(store, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <K, V> ClusteredStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, Object[] serviceConfigs) {
            this.connectLock.lock();
            try {
                CacheEventListenerConfiguration eventListenerConfiguration = (CacheEventListenerConfiguration)ServiceUtils.findSingletonAmongst(CacheEventListenerConfiguration.class, (Object[])serviceConfigs);
                if (eventListenerConfiguration != null) {
                    if (eventListenerConfiguration.firingMode() == EventFiring.SYNCHRONOUS) {
                        throw new IllegalStateException("Synchronous CacheEventListener is not supported with clustered tiers");
                    }
                    if (eventListenerConfiguration.orderingMode() == EventOrdering.ORDERED) {
                        throw new IllegalStateException("Ordered CacheEventListener is not supported with clustered tiers");
                    }
                }
                if (this.clusteringService == null) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteringServiceConfiguration");
                }
                HashSet clusteredResourceTypes = new HashSet(storeConfig.getResourcePools().getResourceTypeSet());
                clusteredResourceTypes.retainAll(CLUSTER_RESOURCES);
                if (clusteredResourceTypes.isEmpty()) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteredResourcePools");
                }
                if (clusteredResourceTypes.size() != 1) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore can not create clustered tier with multiple clustered resources");
                }
                ClusteredStoreConfiguration clusteredStoreConfiguration = (ClusteredStoreConfiguration)ServiceUtils.findSingletonAmongst(ClusteredStoreConfiguration.class, (Object[])serviceConfigs);
                if (clusteredStoreConfiguration == null) {
                    clusteredStoreConfiguration = new ClusteredStoreConfiguration();
                }
                ClusteringService.ClusteredCacheIdentifier cacheId = (ClusteringService.ClusteredCacheIdentifier)ServiceUtils.findSingletonAmongst(ClusteringService.ClusteredCacheIdentifier.class, (Object[])serviceConfigs);
                TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
                OperationsCodec codec = new OperationsCodec(storeConfig.getKeySerializer(), storeConfig.getValueSerializer());
                ExpiryPolicy expiry = storeConfig.getExpiry();
                ChainResolver resolver = ExpiryPolicyBuilder.noExpiration().equals(expiry) ? new EternalChainResolver(codec) : new ExpiryChainResolver(codec, expiry);
                ClusteredStore<K, V> store = this.createStore(storeConfig, codec, resolver, timeSource, storeConfig.useLoaderInAtomics(), serviceConfigs);
                this.createdStores.put((Store<?, ?>)store, new StoreConfig(cacheId, storeConfig, clusteredStoreConfiguration.getConsistency()));
                ClusteredStore<K, V> clusteredStore = store;
                return clusteredStore;
            }
            finally {
                this.connectLock.unlock();
            }
        }

        protected <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource, boolean useLoaderInAtomics, Object[] serviceConfigs) {
            DefaultStoreEventDispatcher storeEventDispatcher = new DefaultStoreEventDispatcher(storeConfig.getDispatcherConcurrency());
            return new ClusteredStore<K, V>(storeConfig, codec, resolver, timeSource, storeEventDispatcher);
        }

        public void releaseStore(Store<?, ?> resource) {
            this.connectLock.lock();
            try {
                if (this.createdStores.remove(resource) == null) {
                    throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
                }
                ClusteredStore clusteredStore = (ClusteredStore)resource;
                this.clusteringService.releaseServerStoreProxy(clusteredStore.storeProxy, false);
                StatisticsManager.nodeFor((Object)((Object)clusteredStore)).clean();
                this.tierOperationStatistics.remove((Object)clusteredStore);
            }
            finally {
                this.connectLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initStore(Store<?, ?> resource) {
            block11: {
                this.connectLock.lock();
                try {
                    StateRepository stateRepository;
                    Serializer valueSerializer;
                    StoreConfig storeConfig = this.createdStores.get(resource);
                    if (storeConfig == null) {
                        throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
                    }
                    ClusteredStore clusteredStore = (ClusteredStore)resource;
                    ClusteringService.ClusteredCacheIdentifier cacheIdentifier = storeConfig.getCacheIdentifier();
                    try {
                        ServerStoreProxy storeProxy = this.clusteringService.getServerStoreProxy(cacheIdentifier, storeConfig.getStoreConfig(), storeConfig.getConsistency(), this.getServerCallback(clusteredStore));
                        ReconnectingServerStoreProxy reconnectingServerStoreProxy = new ReconnectingServerStoreProxy(storeProxy, () -> {
                            Runnable reconnectTask = () -> {
                                this.connectLock.lock();
                                try {
                                    String cacheId = cacheIdentifier.getId();
                                    LOGGER.info("Cache {} got disconnected from cluster, reconnecting", (Object)cacheId);
                                    this.clusteringService.releaseServerStoreProxy(clusteredStore.storeProxy, true);
                                    this.initStore((Store<?, ?>)clusteredStore);
                                    LOGGER.info("Cache {} got reconnected to cluster", (Object)cacheId);
                                }
                                finally {
                                    this.connectLock.unlock();
                                }
                            };
                            CompletableFuture.runAsync(reconnectTask, this.executionService.getUnorderedExecutor(null, new LinkedBlockingQueue()));
                        });
                        clusteredStore.setStoreProxy(reconnectingServerStoreProxy);
                    }
                    catch (CachePersistenceException e) {
                        throw new RuntimeException("Unable to create cluster tier proxy - " + cacheIdentifier, e);
                    }
                    Serializer keySerializer = clusteredStore.codec.getKeySerializer();
                    if (keySerializer instanceof StatefulSerializer) {
                        StateRepository stateRepository2;
                        try {
                            stateRepository2 = this.clusteringService.getStateRepositoryWithin(cacheIdentifier, cacheIdentifier.getId() + "-Key");
                        }
                        catch (CachePersistenceException e) {
                            throw new RuntimeException(e);
                        }
                        ((StatefulSerializer)keySerializer).init(stateRepository2);
                    }
                    if (!((valueSerializer = clusteredStore.codec.getValueSerializer()) instanceof StatefulSerializer)) break block11;
                    try {
                        stateRepository = this.clusteringService.getStateRepositoryWithin(cacheIdentifier, cacheIdentifier.getId() + "-Value");
                    }
                    catch (CachePersistenceException e) {
                        throw new RuntimeException(e);
                    }
                    ((StatefulSerializer)valueSerializer).init(stateRepository);
                }
                finally {
                    this.connectLock.unlock();
                }
            }
        }

        protected <K, V> ServerStoreProxy.ServerCallback getServerCallback(final ClusteredStore<K, V> clusteredStore) {
            return new ServerStoreProxy.ServerCallback(){

                @Override
                public void onAppend(Chain beforeAppend, ByteBuffer appended) {
                    StoreEventSink sink = clusteredStore.storeEventDispatcher.eventSink();
                    try {
                        Operation operation = clusteredStore.codec.decode(appended);
                        Object key = operation.getKey();
                        PutOperation resolvedBefore = clusteredStore.resolver.resolve(beforeAppend, key);
                        PutOperation resolvedAfter = clusteredStore.resolver.applyOperation(key, resolvedBefore, operation);
                        if (resolvedBefore == null) {
                            if (resolvedAfter != null) {
                                sink.created(key, resolvedAfter.getValue());
                            }
                        } else if (resolvedAfter != null) {
                            if (resolvedAfter != resolvedBefore) {
                                sink.updated(key, () -> resolvedBefore.getValue(), resolvedAfter.getValue());
                            }
                        } else {
                            switch (operation.getOpCode()) {
                                case TIMESTAMP: {
                                    sink.expired(key, () -> resolvedBefore.getValue());
                                    break;
                                }
                                default: {
                                    sink.removed(key, () -> resolvedBefore.getValue());
                                }
                            }
                        }
                        clusteredStore.storeEventDispatcher.releaseEventSink(sink);
                    }
                    catch (Exception e) {
                        clusteredStore.storeEventDispatcher.releaseEventSinkAfterFailure(sink, e);
                        LOGGER.warn("Error processing server append event", (Throwable)e);
                    }
                }

                @Override
                public void onInvalidateHash(long hash, Chain evictedChain) {
                    StoreOperationOutcomes.EvictionOutcome result = StoreOperationOutcomes.EvictionOutcome.SUCCESS;
                    clusteredStore.evictionObserver.begin();
                    if (clusteredStore.invalidationValve != null) {
                        try {
                            LOGGER.debug("CLIENT: calling invalidation valve for hash {}", (Object)hash);
                            clusteredStore.invalidationValve.invalidateAllWithHash(hash);
                        }
                        catch (StoreAccessException sae) {
                            LOGGER.error("Error invalidating hash {}", (Object)hash, (Object)sae);
                            result = StoreOperationOutcomes.EvictionOutcome.FAILURE;
                        }
                    }
                    if (evictedChain != null) {
                        StoreEventSink sink = clusteredStore.storeEventDispatcher.eventSink();
                        Map operationMap = clusteredStore.resolver.resolveAll(evictedChain, clusteredStore.timeSource.getTimeMillis());
                        for (Map.Entry entry : operationMap.entrySet()) {
                            Object key = entry.getKey();
                            Object value = entry.getValue() == null ? null : entry.getValue().get();
                            sink.evicted(key, () -> value);
                        }
                        clusteredStore.storeEventDispatcher.releaseEventSink(sink);
                    }
                    clusteredStore.evictionObserver.end((Enum)result);
                }

                @Override
                public void onInvalidateAll() {
                    if (clusteredStore.invalidationValve != null) {
                        try {
                            LOGGER.debug("CLIENT: calling invalidation valve for all");
                            clusteredStore.invalidationValve.invalidateAll();
                        }
                        catch (StoreAccessException sae) {
                            LOGGER.error("Error invalidating all", (Throwable)sae);
                        }
                    }
                }

                @Override
                public void compact(ServerStoreProxy.ChainEntry chain) {
                    clusteredStore.resolver.compact(chain);
                }
            };
        }

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            if (this.clusteringService == null || resourceTypes.size() > 1 || Collections.disjoint(resourceTypes, CLUSTER_RESOURCES)) {
                return 0;
            }
            return 1;
        }

        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?, ?>> serviceConfigs) {
            if (this.clusteringService == null) {
                return 0;
            }
            return CLUSTER_RESOURCES.contains(authorityResource) ? 1 : 0;
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.connectLock.lock();
            try {
                this.serviceProvider = serviceProvider;
                this.clusteringService = (ClusteringService)this.serviceProvider.getService(ClusteringService.class);
                this.executionService = (ExecutionService)this.serviceProvider.getService(ExecutionService.class);
            }
            finally {
                this.connectLock.unlock();
            }
        }

        public void stop() {
            this.connectLock.lock();
            try {
                this.serviceProvider = null;
                this.createdStores.clear();
            }
            finally {
                this.connectLock.unlock();
            }
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?, ?> ... serviceConfigs) {
            ClusteredStore<K, V> authoritativeTier = this.createStoreInternal(storeConfig, serviceConfigs);
            this.tierOperationStatistics.put(authoritativeTier, new OperationStatistic[]{this.createTranslatedStatistic(authoritativeTier, "get", TierOperationOutcomes.GET_AND_FAULT_TRANSLATION, "getAndFault"), this.createTranslatedStatistic(authoritativeTier, "eviction", TierOperationOutcomes.EVICTION_TRANSLATION, "eviction")});
            return authoritativeTier;
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        static {
            HashSet resourceTypes = new HashSet();
            Collections.addAll(resourceTypes, ClusteredResourceType.Types.values());
            CLUSTER_RESOURCES = Collections.unmodifiableSet(resourceTypes);
        }
    }
}

