/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.operations.Operation;
import org.ehcache.clustered.common.internal.store.operations.PutOperation;
import org.ehcache.clustered.common.internal.store.operations.Result;
import org.ehcache.clustered.common.internal.store.operations.TimestampOperation;
import org.ehcache.clustered.common.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.core.config.ExpiryUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.expiry.ExpiryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiryChainResolver<K, V>
extends ChainResolver<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpiryChainResolver.class);
    private final ExpiryPolicy<? super K, ? super V> expiry;

    public ExpiryChainResolver(OperationsCodec<K, V> codec, ExpiryPolicy<? super K, ? super V> expiry) {
        super(codec);
        this.expiry = Objects.requireNonNull(expiry, "Expiry cannot be null");
    }

    @Override
    public Store.ValueHolder<V> resolve(ServerStoreProxy.ChainEntry entry, K key, long now, int threshold) {
        PutOperation resolved = this.resolve(entry, key, threshold);
        if (resolved == null) {
            return null;
        }
        if (now >= resolved.expirationTime()) {
            try {
                entry.append(this.codec.encode(new TimestampOperation(key, now)));
            }
            catch (TimeoutException e) {
                LOG.debug("Failed to append timestamp operation", (Throwable)e);
            }
            return null;
        }
        return new ClusteredValueHolder<Object>(resolved.getValue(), resolved.expirationTime());
    }

    @Override
    public Map<K, Store.ValueHolder<V>> resolveAll(Chain chain, long now) {
        Map resolved = this.resolveAll(chain);
        HashMap values = new HashMap(resolved.size());
        for (Map.Entry e : resolved.entrySet()) {
            values.put(e.getKey(), new ClusteredValueHolder<Object>(e.getValue().getValue(), e.getValue().expirationTime()));
        }
        return Collections.unmodifiableMap(values);
    }

    @Override
    public PutOperation<K, V> applyOperation(K key, PutOperation<K, V> existing, Operation<K, V> operation) {
        Result<K, V> newValue;
        if (existing != null && operation.timeStamp() >= existing.expirationTime()) {
            existing = null;
        }
        if ((newValue = operation.apply(existing)) == null) {
            return null;
        }
        if (newValue == existing) {
            return existing;
        }
        return newValue.asOperationExpiringAt(this.calculateExpiryTime(key, existing, operation, newValue));
    }

    private long calculateExpiryTime(K key, PutOperation<K, V> existing, Operation<K, V> operation, Result<K, V> newValue) {
        if (operation.isExpiryAvailable()) {
            return operation.expirationTime();
        }
        try {
            Duration duration;
            if (existing == null) {
                duration = Objects.requireNonNull(this.expiry.getExpiryForCreation(key, newValue.getValue()));
            } else {
                duration = this.expiry.getExpiryForUpdate(key, () -> existing.getValue(), newValue.getValue());
                if (duration == null) {
                    return existing.expirationTime();
                }
            }
            if (duration.isNegative()) {
                duration = Duration.ZERO;
            } else if (ExpiryUtils.isExpiryDurationInfinite((Duration)duration)) {
                return Long.MAX_VALUE;
            }
            return ExpiryUtils.getExpirationMillis((long)operation.timeStamp(), (Duration)duration);
        }
        catch (Exception ex) {
            LOG.error("Expiry computation caused an exception - Expiry duration will be 0 ", (Throwable)ex);
            return Long.MIN_VALUE;
        }
    }
}

