/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.exception.EntityBusyException;
import com.tc.exception.VoltronEntityUserExceptionWrapper;
import com.tc.exception.VoltronWrapperException;
import com.tc.object.EntityID;
import com.tc.util.Assert;
import java.util.Arrays;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.EntityAlreadyExistsException;
import org.terracotta.exception.EntityConfigurationException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityNotProvidedException;
import org.terracotta.exception.EntityServerException;
import org.terracotta.exception.EntityServerUncaughtException;
import org.terracotta.exception.EntityVersionMismatchException;
import org.terracotta.exception.PermanentEntityException;
import org.terracotta.exception.RuntimeEntityException;

public class ExceptionUtils {
    public static EntityException addLocalStackTraceToEntityException(EntityID eid, EntityException e) throws RuntimeEntityException {
        EntityException wrappedException;
        String entityType = eid.getClassName();
        String enityName = eid.getEntityName();
        if (e instanceof VoltronEntityUserExceptionWrapper) {
            wrappedException = new EntityServerException(entityType, enityName, e.getDescription(), e.getCause());
        } else if (e instanceof EntityNotFoundException) {
            wrappedException = new EntityNotFoundException(entityType, enityName, e);
        } else if (e instanceof VoltronWrapperException) {
            ExceptionUtils.throwRuntimeExceptionWithLocalStack(eid, ((VoltronWrapperException)e).getWrappedException());
            wrappedException = null;
        } else if (e instanceof EntityNotProvidedException) {
            wrappedException = new EntityNotProvidedException(entityType, enityName, e);
        } else if (e instanceof EntityVersionMismatchException) {
            EntityVersionMismatchException vme = (EntityVersionMismatchException)e;
            wrappedException = new EntityVersionMismatchException(entityType, enityName, vme.getExpectedVersion(), vme.getAttemptedVersion(), e);
        } else if (e instanceof EntityAlreadyExistsException) {
            wrappedException = new EntityAlreadyExistsException(entityType, enityName, e);
        } else if (e instanceof EntityConfigurationException) {
            wrappedException = new EntityConfigurationException(entityType, enityName, e);
        } else if (e instanceof EntityBusyException) {
            wrappedException = new EntityBusyException(entityType, enityName, e);
        } else {
            return e;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        wrappedException.setStackTrace(Arrays.copyOfRange(stackTrace, 2, stackTrace.length));
        return wrappedException;
    }

    private static void throwRuntimeExceptionWithLocalStack(EntityID eid, RuntimeEntityException wrappedException) throws RuntimeEntityException {
        String entityType = eid.getClassName();
        String enityName = eid.getEntityName();
        if (wrappedException instanceof PermanentEntityException) {
            throw new PermanentEntityException(entityType, enityName, wrappedException);
        }
        if (wrappedException instanceof ConnectionClosedException) {
            throw wrappedException;
        }
        if (wrappedException instanceof EntityServerUncaughtException) {
            throw new EntityServerUncaughtException(entityType, enityName, wrappedException.getDescription(), wrappedException);
        }
        Assert.fail("Unhandled runtime exception type");
    }
}

