/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.net.protocol.tcm.TCMessage;
import com.tc.object.EntityID;
import com.tc.object.ExceptionUtils;
import com.tc.object.InFlightMonitor;
import com.tc.object.StatType;
import com.tc.object.tx.TransactionID;
import com.tc.text.PrettyPrintable;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import org.terracotta.exception.EntityException;

public class InFlightMessage
implements PrettyPrintable {
    private final VoltronEntityMessage message;
    private final EntityID eid;
    private final InFlightMonitor monitor;
    private final Set<VoltronEntityMessage.Acks> pendingAcks;
    private final Set<Thread> waitingThreads;
    private boolean isSent;
    private EntityException exception;
    private byte[] value;
    private boolean getCanComplete;
    private final boolean blockGetOnRetired;
    private final Trace trace;
    private Runnable runOnRetire;
    private long start;
    private long send;
    private long notifySent;
    private long sent;
    private long received;
    private long got;
    private long complete;
    private long retired;
    private long end;
    private long[] serverStats;

    public InFlightMessage(EntityID eid, Supplier<? extends VoltronEntityMessage> message, Set<VoltronEntityMessage.Acks> acks, InFlightMonitor monitor, boolean shouldBlockGetOnRetire) {
        this.eid = eid;
        this.message = message.get();
        this.monitor = monitor;
        Assert.assertNotNull(eid);
        Assert.assertNotNull(message);
        this.pendingAcks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        this.pendingAcks.addAll(acks);
        this.waitingThreads = new HashSet<Thread>();
        this.blockGetOnRetired = shouldBlockGetOnRetire;
        this.trace = Trace.newTrace(this.message, "InFlightMessage");
    }

    void setStatisticsBoundries(long start, long end) {
        this.start = start;
        this.end = end;
    }

    public void collect(long[] stats) {
        if (stats != null) {
            stats[StatType.CLIENT_ENCODE.ordinal()] = this.start;
            stats[StatType.CLIENT_SEND.ordinal()] = this.send;
            stats[StatType.CLIENT_SENT.ordinal()] = this.sent;
            stats[StatType.CLIENT_GOT.ordinal()] = this.got;
            stats[StatType.CLIENT_COMPLETE.ordinal()] = this.complete;
            stats[StatType.CLIENT_RECEIVED.ordinal()] = this.received;
            stats[StatType.CLIENT_RETIRED.ordinal()] = this.retired;
            stats[StatType.CLIENT_DECODED.ordinal()] = this.end;
            if (this.serverStats != null) {
                stats[StatType.SERVER_ADD.ordinal()] = this.serverStats[0];
                stats[StatType.SERVER_SCHEDULE.ordinal()] = this.serverStats[1];
                stats[StatType.SERVER_BEGININVOKE.ordinal()] = this.serverStats[2];
                stats[StatType.SERVER_ENDINVOKE.ordinal()] = this.serverStats[3];
            }
        }
    }

    synchronized void runOnRetire(Runnable r) {
        if (this.retired != 0L) {
            r.run();
        } else {
            this.runOnRetire = r;
        }
    }

    @Override
    public Map<String, ?> getStateMap() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("entity", this.eid);
        LinkedHashMap<String, Long> timing = new LinkedHashMap<String, Long>();
        timing.put("send", this.send);
        timing.put("sent", this.sent);
        timing.put("notifySent", this.notifySent);
        timing.put("received", this.received);
        timing.put("complete", this.complete);
        timing.put("got", this.got);
        timing.put("retired", this.retired);
        map.put("marks", timing);
        LinkedHashMap<String, Long> offset = new LinkedHashMap<String, Long>();
        offset.put("sent->notifySent", this.send - this.notifySent);
        offset.put("send->sent", this.sent - this.send);
        offset.put("sent->received", this.received - this.sent);
        offset.put("received->complete", this.complete - this.received);
        offset.put("complete->got", this.got - this.complete);
        offset.put("complete->retired", this.retired - this.complete);
        map.put("timing", offset);
        return map;
    }

    public EntityID getEntityID() {
        return this.eid;
    }

    public VoltronEntityMessage getMessage() {
        return this.message;
    }

    public TransactionID getTransactionID() {
        return this.message.getTransactionID();
    }

    public boolean send() {
        Trace.activeTrace().log("InFlightMessage.send()");
        Assert.assertFalse(this.isSent);
        this.isSent = true;
        this.send = System.nanoTime();
        try {
            boolean bl = ((TCMessage)((Object)this.message)).send();
            return bl;
        }
        finally {
            this.sent = System.nanoTime();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void waitForAcks() {
        boolean interrupted = false;
        boolean complete = false;
        try {
            while (!complete) {
                try {
                    this.waitForAcks(0L, TimeUnit.MILLISECONDS);
                    complete = true;
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
                catch (TimeoutException te) {
                    throw new AssertionError((Object)te);
                    return;
                }
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public void waitForAcks(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Trace.activeTrace().log("InFlightMessage.waitForAcks");
        this.timedWait(() -> this.pendingAcks.isEmpty(), timeout, unit);
    }

    public synchronized void sent() {
        this.notifySent = System.nanoTime();
        this.ackDelivered(VoltronEntityMessage.Acks.SENT);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void received() {
        this.received = System.nanoTime();
        this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
    }

    public synchronized void interrupt() {
        for (Thread waitingThread : this.waitingThreads) {
            waitingThread.interrupt();
        }
    }

    public synchronized boolean isDone() {
        return this.getCanComplete;
    }

    public synchronized boolean isSent() {
        return this.isSent;
    }

    public synchronized byte[] get() throws InterruptedException, EntityException {
        try {
            return this.getWithTimeout(0L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException to) {
            throw new AssertionError((Object)to);
        }
    }

    private synchronized void timedWait(Callable<Boolean> predicate, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        Thread callingThread = Thread.currentThread();
        boolean didAdd = this.waitingThreads.add(callingThread);
        Assert.assertTrue(didAdd);
        long end = timeout > 0L ? System.nanoTime() + unit.toNanos(timeout) : 0L;
        try {
            while (!predicate.call().booleanValue()) {
                long timing;
                long l = timing = end > 0L ? end - System.nanoTime() : 0L;
                if (timing < 0L) {
                    throw new TimeoutException();
                }
                this.wait(timing / TimeUnit.MILLISECONDS.toNanos(1L), (int)(timing % TimeUnit.MILLISECONDS.toNanos(1L)));
            }
        }
        catch (InterruptedException | TimeoutException ie) {
            throw ie;
        }
        catch (Exception exp) {
            throw new AssertionError((Object)exp);
        }
        finally {
            this.waitingThreads.remove(callingThread);
        }
    }

    public byte[] getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
        this.trace.log("getWithTimeout()");
        this.timedWait(() -> this.getCanComplete, timeout, unit);
        this.got = System.nanoTime();
        if (this.exception != null) {
            throw ExceptionUtils.addLocalStackTraceToEntityException(this.eid, this.exception);
        }
        if (this.message.getVoltronType() == VoltronEntityMessage.Type.INVOKE_ACTION) {
            Assert.assertNotNull(this.value);
        }
        return this.value;
    }

    public synchronized void setResult(byte[] value, EntityException error) {
        if (Trace.isTraceEnabled()) {
            this.trace.log("Received Result: " + value + " ; Exception: " + (error != null ? error.getLocalizedMessage() : "None"));
        }
        if (this.received == 0L) {
            this.received = System.nanoTime();
        }
        this.ackDelivered(VoltronEntityMessage.Acks.RECEIVED);
        this.complete = System.nanoTime();
        this.ackDelivered(VoltronEntityMessage.Acks.COMPLETED);
        if (this.pendingAcks.isEmpty()) {
            this.notifyAll();
        }
        if (error != null) {
            Assert.assertNull(value);
            this.pendingAcks.clear();
            this.exception = error;
            this.getCanComplete = true;
            this.notifyAll();
        } else {
            Assert.assertNotNull(value);
            this.value = value;
            if (!this.blockGetOnRetired) {
                this.getCanComplete = true;
                this.notifyAll();
            }
        }
    }

    public synchronized void handleMessage(byte[] raw) {
        if (this.monitor != null) {
            this.monitor.accept(raw);
        }
    }

    private void ackDelivered(VoltronEntityMessage.Acks ack) {
        if (Trace.isTraceEnabled()) {
            this.trace.log("Received ACK: " + (Object)((Object)ack));
        }
        if (this.pendingAcks.remove((Object)ack) && this.monitor != null) {
            this.monitor.ackDelivered(ack);
        }
    }

    public synchronized void retired() {
        this.retired = System.nanoTime();
        this.ackDelivered(VoltronEntityMessage.Acks.RETIRED);
        if (this.blockGetOnRetired) {
            this.getCanComplete = true;
            if (this.message.getVoltronType() == VoltronEntityMessage.Type.INVOKE_ACTION) {
                Assert.assertTrue("failed " + this.message.getTransactionID(), this.value != null || this.exception != null);
            }
        }
        this.notifyAll();
        if (this.runOnRetire != null) {
            this.runOnRetire.run();
        }
        if (this.monitor != null) {
            this.monitor.close();
        }
    }

    void addServerStatistics(long[] stats) {
        this.serverStats = stats;
    }
}

