/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.entity.VoltronEntityMessage;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.InFlightMessage;
import com.tc.object.InFlightMonitor;
import com.tc.object.InFlightStats;
import com.tc.object.InvocationHandler;
import com.tc.object.StatType;
import com.tc.text.MapListPrettyPrint;
import com.tc.util.Assert;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.terracotta.entity.EndpointDelegate;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.InvocationBuilder;
import org.terracotta.entity.InvokeFuture;
import org.terracotta.entity.InvokeMonitor;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.EntityException;

public class EntityClientEndpointImpl<M extends EntityMessage, R extends EntityResponse>
implements EntityClientEndpoint<M, R> {
    private final InvocationHandler invocationHandler;
    private final byte[] configuration;
    private final EntityDescriptor invokeDescriptor;
    private final EntityID entityID;
    private final long version;
    private final MessageCodec<M, R> codec;
    private final Runnable closeHook;
    private final ExecutorService closer;
    private EndpointDelegate<R> delegate;
    private boolean isOpen;
    private Future<Void> releaseFuture;
    private final InFlightStats stats = new InFlightStats();

    public EntityClientEndpointImpl(EntityID eid, long version, EntityDescriptor instance, InvocationHandler invocationHandler, byte[] entityConfiguration, MessageCodec<M, R> codec, Runnable closeHook, ExecutorService closer) {
        this.entityID = eid;
        this.version = version;
        this.invokeDescriptor = instance;
        this.invocationHandler = invocationHandler;
        this.configuration = entityConfiguration;
        this.codec = codec;
        this.closeHook = closeHook;
        this.closer = closer;
        this.isOpen = true;
    }

    EntityID getEntityID() {
        return this.entityID;
    }

    long getVersion() {
        return this.version;
    }

    EntityDescriptor getEntityDescriptor() {
        return this.invokeDescriptor;
    }

    @Override
    public byte[] getEntityConfiguration() {
        this.checkEndpointOpen();
        return this.configuration;
    }

    @Override
    public void setDelegate(EndpointDelegate<R> delegate) {
        this.checkEndpointOpen();
        Assert.assertNull(this.delegate);
        this.delegate = delegate;
    }

    public void handleMessage(byte[] message) throws MessageCodecException {
        if (null != this.delegate) {
            R messageFromServer = this.codec.decodeResponse(message);
            this.delegate.handleMessage(messageFromServer);
        }
    }

    public InFlightStats getStatistics() {
        return this.stats;
    }

    @Override
    public InvocationBuilder<M, R> beginInvoke() {
        this.checkEndpointOpen();
        return new InvocationBuilderImpl();
    }

    public byte[] getExtendedReconnectData() {
        byte[] reconnectData = null;
        if (null != this.delegate) {
            reconnectData = this.delegate.createExtendedReconnectData();
        }
        if (null == reconnectData) {
            reconnectData = new byte[]{};
        }
        return reconnectData;
    }

    @Override
    public void close() {
        this.checkEndpointOpen();
        if (this.closeHook != null) {
            this.closeHook.run();
        }
        this.isOpen = false;
    }

    @Override
    public synchronized Future<Void> release() {
        if (this.releaseFuture == null) {
            Callable<Void> call = new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    EntityClientEndpointImpl.this.close();
                    return null;
                }
            };
            if (this.closer == null) {
                this.close();
                this.releaseFuture = new CompletedFuture();
            } else {
                try {
                    this.releaseFuture = this.closer.submit(call);
                }
                catch (RejectedExecutionException re) {
                    this.releaseFuture = new CompletedFuture(new IllegalStateException("connection has already been shutdown"));
                }
            }
        }
        return this.releaseFuture;
    }

    public void didCloseUnexpectedly() {
        if (null != this.delegate) {
            this.delegate.didDisconnectUnexpectedly();
        }
    }

    private void checkEndpointOpen() {
        if (!this.isOpen) {
            throw new IllegalStateException("Endpoint closed");
        }
    }

    private static class CompletedFuture
    implements Future<Void> {
        public final Exception failure;

        public CompletedFuture() {
            this.failure = null;
        }

        public CompletedFuture(Exception failure) {
            this.failure = failure;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return true;
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            if (this.failure != null) {
                throw new ExecutionException(this.failure);
            }
            return null;
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.get();
        }
    }

    private class InvocationBuilderImpl
    implements InvocationBuilder<M, R> {
        private boolean invoked = false;
        private M request;
        private final Set<VoltronEntityMessage.Acks> acks = EnumSet.noneOf(VoltronEntityMessage.Acks.class);
        private boolean requiresReplication = true;
        private boolean shouldBlockGetOnRetire = true;
        private InvokeMonitor<R> monitor;
        private Executor executor;

        private InvocationBuilderImpl() {
        }

        public synchronized InvocationBuilderImpl message(M request) {
            this.checkInvoked();
            this.request = request;
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackSent() {
            this.acks.add(VoltronEntityMessage.Acks.SENT);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackReceived() {
            this.acks.add(VoltronEntityMessage.Acks.RECEIVED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackCompleted() {
            this.acks.add(VoltronEntityMessage.Acks.COMPLETED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> ackRetired() {
            this.acks.add(VoltronEntityMessage.Acks.RETIRED);
            return this;
        }

        @Override
        public InvocationBuilder<M, R> monitor(InvokeMonitor<R> consumer) {
            this.monitor = consumer;
            return this;
        }

        @Override
        public InvocationBuilder<M, R> withExecutor(Executor useForDelivery) {
            this.executor = useForDelivery;
            return this;
        }

        @Override
        @Deprecated
        public InvocationBuilder<M, R> asDeferredResponse() {
            return this;
        }

        @Override
        public InvocationBuilder<M, R> replicate(boolean requiresReplication) {
            this.requiresReplication = requiresReplication;
            return this;
        }

        @Override
        public InvocationBuilder<M, R> blockGetOnRetire(boolean shouldBlock) {
            this.shouldBlockGetOnRetire = shouldBlock;
            return this;
        }

        private InvokeFuture<R> returnTypedInvoke(final long startTime, final InFlightMessage result) {
            return new InvokeFuture<R>(){

                @Override
                public boolean isDone() {
                    return result.isDone();
                }

                @Override
                public R get() throws InterruptedException, EntityException {
                    try {
                        Object r = EntityClientEndpointImpl.this.codec.decodeResponse(result.get());
                        return r;
                    }
                    catch (MessageCodecException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        InvocationBuilderImpl.this.collectStats(startTime, result);
                    }
                }

                @Override
                public R getWithTimeout(long timeout, TimeUnit unit) throws InterruptedException, EntityException, TimeoutException {
                    try {
                        Object r = EntityClientEndpointImpl.this.codec.decodeResponse(result.getWithTimeout(timeout, unit));
                        return r;
                    }
                    catch (MessageCodecException e) {
                        throw new RuntimeException(e);
                    }
                    finally {
                        InvocationBuilderImpl.this.collectStats(startTime, result);
                    }
                }

                @Override
                public void interrupt() {
                    result.interrupt();
                }

                public String toString() {
                    return result.prettyPrint(new MapListPrettyPrint()).toString();
                }
            };
        }

        @Override
        public synchronized InvokeFuture<R> invokeWithTimeout(long time, TimeUnit units) throws MessageCodecException, InterruptedException, TimeoutException {
            this.checkInvoked();
            this.invoked = true;
            InFlightMonitor ifm = this.monitor != null ? new InFlightMonitor(EntityClientEndpointImpl.this.codec, this.monitor, this.executor) : null;
            long start = System.nanoTime();
            return this.returnTypedInvoke(start, EntityClientEndpointImpl.this.invocationHandler.invokeActionWithTimeout(EntityClientEndpointImpl.this.entityID, EntityClientEndpointImpl.this.invokeDescriptor, this.acks, ifm, this.requiresReplication, this.shouldBlockGetOnRetire, time, units, EntityClientEndpointImpl.this.codec.encodeMessage(this.request)));
        }

        private void collectStats(long startTime, InFlightMessage msg) {
            long now = System.nanoTime();
            msg.setStatisticsBoundries(startTime, now);
            msg.runOnRetire(() -> {
                long[] vals = new long[StatType.values().length];
                msg.collect(vals);
                EntityClientEndpointImpl.this.stats.collect(vals);
            });
        }

        @Override
        public synchronized InvokeFuture<R> invoke() throws MessageCodecException {
            this.checkInvoked();
            this.invoked = true;
            InFlightMonitor ifm = this.monitor != null ? new InFlightMonitor(EntityClientEndpointImpl.this.codec, this.monitor, this.executor) : null;
            long startTime = System.nanoTime();
            return this.returnTypedInvoke(startTime, EntityClientEndpointImpl.this.invocationHandler.invokeAction(EntityClientEndpointImpl.this.entityID, EntityClientEndpointImpl.this.invokeDescriptor, this.acks, ifm, this.requiresReplication, this.shouldBlockGetOnRetire, EntityClientEndpointImpl.this.codec.encodeMessage(this.request)));
        }

        private void checkInvoked() {
            if (this.invoked) {
                throw new IllegalStateException("Already invoked");
            }
        }
    }
}

