/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.config.ConnectionInfoConfig;
import com.tc.object.config.PreparedComponentsFromL2Connection;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientShutdownManager {
    private static final Logger logger = LoggerFactory.getLogger(ClientShutdownManager.class);
    private final ClientMessageChannel channel;
    private final ClientHandshakeManager handshakeManager;
    private final PreparedComponentsFromL2Connection connectionComponents;
    private final Set<Runnable> beforeShutdown = new HashSet<Runnable>();
    private final DistributedObjectClient client;

    public ClientShutdownManager(DistributedObjectClient client, PreparedComponentsFromL2Connection connectionComponents) {
        this.client = client;
        this.channel = client.getChannel();
        this.handshakeManager = client.getClientHandshakeManager();
        this.connectionComponents = connectionComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.add(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterBeforeShutdownHook(Runnable beforeShutdownHook) {
        Set<Runnable> set = this.beforeShutdown;
        synchronized (set) {
            this.beforeShutdown.remove(beforeShutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBeforeShutdownHooks() {
        Runnable[] runnableArray = this.beforeShutdown;
        synchronized (this.beforeShutdown) {
            Runnable[] beforeShutdowns = this.beforeShutdown.toArray(new Runnable[this.beforeShutdown.size()]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (Runnable runnable : beforeShutdowns) {
                runnable.run();
            }
            return;
        }
    }

    public void execute(boolean forceImmediate) {
        this.executeBeforeShutdownHooks();
        this.closeLocalWork(forceImmediate);
        this.shutdown();
    }

    private void closeLocalWork(boolean forceImmediate) {
        this.handshakeManager.shutdown();
        ClientEntityManager entityMgr = this.client.getEntityManager();
        if (entityMgr != null) {
            entityMgr.shutdown();
        }
    }

    private boolean isImmediate() {
        if (this.channel.isConnected()) {
            return false;
        }
        ConnectionInfoConfig connectionInfoItem = this.connectionComponents.createConnectionInfoConfigItem();
        ConnectionInfo[] connectionInfo = connectionInfoItem.getConnectionInfos();
        return connectionInfo.length == 1;
    }

    private void shutdown() {
        this.client.shutdownResources();
    }
}

