/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.bytes.TCByteBuffer;
import com.tc.net.core.TCConnection;
import com.tc.net.protocol.AbstractTCNetworkHeader;
import com.tc.net.protocol.AbstractTCNetworkMessage;
import com.tc.net.protocol.AbstractTCProtocolAdaptor;
import com.tc.net.protocol.TCNetworkHeader;
import com.tc.net.protocol.TCNetworkMessage;
import com.tc.net.protocol.TCProtocolException;
import com.tc.net.protocol.transport.TransportMessageImpl;
import com.tc.net.protocol.transport.WireProtocolAdaptor;
import com.tc.net.protocol.transport.WireProtocolGroupMessage;
import com.tc.net.protocol.transport.WireProtocolGroupMessageImpl;
import com.tc.net.protocol.transport.WireProtocolHeader;
import com.tc.net.protocol.transport.WireProtocolMessage;
import com.tc.net.protocol.transport.WireProtocolMessageImpl;
import com.tc.net.protocol.transport.WireProtocolMessageSink;
import com.tc.util.Assert;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WireProtocolAdaptorImpl
extends AbstractTCProtocolAdaptor
implements WireProtocolAdaptor {
    private static final Logger logger = LoggerFactory.getLogger(WireProtocolAdaptorImpl.class);
    private final WireProtocolMessageSink sink;

    protected WireProtocolAdaptorImpl(WireProtocolMessageSink sink) {
        super(logger);
        this.sink = sink;
    }

    @Override
    public void addReadData(TCConnection source, TCByteBuffer[] data, int length) throws TCProtocolException {
        WireProtocolMessage msg;
        try {
            msg = (WireProtocolMessage)this.processIncomingData(source, data, length);
        }
        catch (TCProtocolException e) {
            this.init();
            throw e;
        }
        if (msg != null) {
            this.init();
            if (logger.isDebugEnabled()) {
                logger.debug("\nRECEIVE\n" + msg.toString());
            }
            if (msg.getWireProtocolHeader().isMessagesGrouped()) {
                WireProtocolGroupMessage wpmg = (WireProtocolGroupMessage)msg;
                int msgCount = wpmg.getWireProtocolHeader().getMessageCount();
                Assert.eval(msgCount > 1);
                Iterator<TCNetworkMessage> i = wpmg.getMessageIterator();
                while (i.hasNext()) {
                    WireProtocolMessage wpm = (WireProtocolMessage)i.next();
                    this.sink.putMessage(wpm);
                }
                msg.getWireProtocolHeader().recycle();
            } else {
                this.sink.putMessage(msg);
            }
        }
    }

    @Override
    protected AbstractTCNetworkHeader getNewProtocolHeader() {
        return new WireProtocolHeader();
    }

    @Override
    protected int computeDataLength(TCNetworkHeader header) {
        WireProtocolHeader wph = (WireProtocolHeader)header;
        return wph.getTotalPacketLength() - wph.getHeaderByteLength();
    }

    @Override
    protected TCNetworkMessage createMessage(TCConnection source, TCNetworkHeader hdr, TCByteBuffer[] data) throws TCProtocolException {
        if (data == null) {
            throw new TCProtocolException("Wire protocol messages must have a payload");
        }
        WireProtocolHeader wph = (WireProtocolHeader)hdr;
        AbstractTCNetworkMessage rv = wph.isHandshakeOrHealthCheckMessage() ? new TransportMessageImpl(source, wph, data) : (wph.getMessageCount() == 1 ? new WireProtocolMessageImpl(source, (TCNetworkHeader)wph, data) : new WireProtocolGroupMessageImpl(source, wph, data));
        return rv;
    }
}

