/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.core;

import com.tc.exception.TCInternalError;
import com.tc.net.core.Constants;
import com.tc.net.core.SocketParams;
import com.tc.net.core.TCChannelReader;
import com.tc.net.core.TCChannelWriter;
import com.tc.net.core.TCConnection;
import com.tc.net.core.TCConnectionImpl;
import com.tc.net.core.TCListener;
import com.tc.net.core.TCListenerImpl;
import com.tc.net.core.TCWorkerCommManager;
import com.tc.net.core.event.TCConnectionErrorEvent;
import com.tc.net.core.event.TCConnectionEvent;
import com.tc.net.core.event.TCConnectionEventListener;
import com.tc.net.core.event.TCListenerEvent;
import com.tc.net.core.event.TCListenerEventListener;
import com.tc.util.Assert;
import com.tc.util.Util;
import com.tc.util.concurrent.SetOnceFlag;
import com.tc.util.runtime.Os;
import java.io.IOException;
import java.net.Socket;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CoreNIOServices
implements TCListenerEventListener,
TCConnectionEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CoreNIOServices.class);
    private final TCWorkerCommManager workerCommMgr;
    private final String commThreadName;
    private final SocketParams socketParams;
    private final CommThread readerComm;
    private final CommThread writerComm;
    private final SetOnceFlag stopRequested = new SetOnceFlag();
    private final AtomicInteger clientWeights = new AtomicInteger();
    private final AtomicBoolean isSelectedForWeighting = new AtomicBoolean();
    private final List<TCListener> listeners = new ArrayList<TCListener>();
    private String listenerString;

    public CoreNIOServices(String commThreadName, TCWorkerCommManager workerCommManager, SocketParams socketParams) {
        this.commThreadName = commThreadName;
        this.workerCommMgr = workerCommManager;
        this.socketParams = socketParams;
        this.readerComm = new CommThread(COMM_THREAD_MODE.NIO_READER);
        this.writerComm = new CommThread(COMM_THREAD_MODE.NIO_WRITER);
    }

    public void start() {
        this.readerComm.start();
        this.writerComm.start();
    }

    public void requestStop() {
        if (this.stopRequested.attemptSet()) {
            this.readerComm.requestStop();
            this.writerComm.requestStop();
        }
    }

    public void cleanupChannel(final SocketChannel channel, final Runnable callback) {
        this.writerComm.cleanupChannel(channel, new Runnable(){

            @Override
            public void run() {
                CoreNIOServices.this.readerComm.cleanupChannel(channel, callback);
            }
        });
    }

    @Override
    public void closeEvent(TCListenerEvent event) {
        this.listenerRemoved(event.getSource());
    }

    public void registerListener(TCListenerImpl lsnr, ServerSocketChannel ssc) {
        this.requestAcceptInterest(lsnr, ssc);
        this.listenerAdded(lsnr);
        lsnr.addEventListener(this);
    }

    public void stopListener(ServerSocketChannel ssc, Runnable callback) {
        this.readerComm.stopListener(ssc, callback);
    }

    private synchronized void listenerRemoved(TCListener listener) {
        boolean removed = this.listeners.remove(listener);
        Assert.eval(removed);
        this.updateListenerString();
        this.readerComm.updateThreadName();
        this.writerComm.updateThreadName();
    }

    private synchronized void listenerAdded(TCListener listener) {
        this.listeners.add(listener);
        this.updateListenerString();
        this.readerComm.updateThreadName();
        this.writerComm.updateThreadName();
    }

    private void updateListenerString() {
        if (this.listeners.isEmpty()) {
            this.listenerString = "";
        }
        StringBuffer buf = new StringBuffer();
        buf.append(" (listen ");
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            TCListener listener = this.listeners.get(i);
            buf.append(listener.getBindAddress().getHostAddress());
            buf.append(':');
            buf.append(listener.getBindPort());
            if (i >= n - 1) continue;
            buf.append(',');
        }
        buf.append(')');
        this.listenerString = buf.toString();
    }

    private synchronized String getListenerString() {
        return this.listenerString;
    }

    public long getTotalBytesRead() {
        return this.readerComm.getTotalBytesRead() + this.writerComm.getTotalBytesRead();
    }

    public long getTotalBytesWritten() {
        return this.readerComm.getTotalBytesWritten() + this.writerComm.getTotalBytesWritten();
    }

    public static boolean hasPendingReads() {
        CommThread ct;
        Thread t = Thread.currentThread();
        if (t instanceof CommThread && (ct = (CommThread)t).isReader()) {
            try {
                return ct.selector.selectedKeys().stream().anyMatch(key -> {
                    try {
                        return key.isValid() && key.isReadable();
                    }
                    catch (CancelledKeyException ck) {
                        return false;
                    }
                });
            }
            catch (ClosedSelectorException closed) {
                return false;
            }
        }
        return false;
    }

    public boolean compareWeights(CoreNIOServices incoming) {
        boolean retVal = false;
        Assert.assertTrue(incoming == null || incoming.isSelectedForWeighting.get());
        if (this.isSelectedForWeighting.compareAndSet(false, true) && (incoming == null || incoming.clientWeights.get() > this.clientWeights.get())) {
            retVal = true;
        }
        if (retVal) {
            if (incoming != null) {
                incoming.deselectForWeighting();
            }
        } else {
            this.deselectForWeighting();
        }
        return retVal;
    }

    private void deselectForWeighting() {
        this.isSelectedForWeighting.set(false);
    }

    int getWeight() {
        return this.clientWeights.get();
    }

    protected CommThread getReaderComm() {
        return this.readerComm;
    }

    protected CommThread getWriterComm() {
        return this.writerComm;
    }

    public void addConnection(TCConnectionImpl connection, SocketChannel channel) {
        if (this.workerCommMgr == null) {
            return;
        }
        this.readerComm.unregister(channel);
        CoreNIOServices workerComm = this.workerCommMgr.getNextWorkerComm();
        connection.setCommWorker(workerComm);
        workerComm.addConnection(connection);
        workerComm.requestReadWriteInterest(connection, channel);
    }

    private void addConnection(TCConnectionImpl connection) {
        this.clientWeights.incrementAndGet();
        this.deselectForWeighting();
        connection.addListener(this);
    }

    @Override
    public void closeEvent(TCConnectionEvent event) {
        this.clientWeights.decrementAndGet();
        event.getSource().removeListener(this);
    }

    @Override
    public void connectEvent(TCConnectionEvent event) {
    }

    @Override
    public void endOfFileEvent(TCConnectionEvent event) {
    }

    @Override
    public void errorEvent(TCConnectionErrorEvent errorEvent) {
    }

    public String toString() {
        return "[" + this.commThreadName + ", FD, wt:" + this.clientWeights + "]";
    }

    public String getName() {
        return this.commThreadName;
    }

    public Map<String, ?> getState() {
        LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
        state.put("name", this.commThreadName);
        state.put("weights", this.clientWeights);
        state.put("writer", this.writerComm.getCommState());
        state.put("reader", this.readerComm.getCommState());
        return state;
    }

    void requestConnectInterest(TCConnectionImpl conn, SocketChannel sc) {
        this.readerComm.requestConnectInterest(conn, sc);
    }

    private void requestAcceptInterest(TCListenerImpl lsnr, ServerSocketChannel ssc) {
        this.readerComm.requestAcceptInterest(lsnr, ssc);
    }

    void requestReadInterest(TCChannelReader reader, ScatteringByteChannel channel) {
        this.readerComm.requestReadInterest(reader, channel);
    }

    void removeReadInterest(TCConnectionImpl conn, SelectableChannel channel) {
        this.readerComm.removeReadInterest(conn, channel);
    }

    void requestWriteInterest(TCChannelWriter writer, GatheringByteChannel channel) {
        this.writerComm.requestWriteInterest(writer, channel);
    }

    void removeWriteInterest(TCConnectionImpl conn, SelectableChannel channel) {
        this.writerComm.removeWriteInterest(conn, channel);
    }

    private void requestReadWriteInterest(TCConnectionImpl conn, SocketChannel sc) {
        this.readerComm.requestReadInterest(conn, sc);
        this.writerComm.requestWriteInterest(conn, sc);
    }

    private static class InterestRequest {
        final SelectableChannel channel;
        final Object attachment;
        final boolean set;
        final boolean add;
        final boolean remove;
        final int interestOps;
        final CommThread commNIOServiceThread;

        static InterestRequest createAddInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, false, true, false, nioServiceThread);
        }

        static InterestRequest createSetInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, true, false, false, nioServiceThread);
        }

        static InterestRequest createRemoveInterestRequest(SelectableChannel channel, Object attachment, int interestOps, CommThread nioServiceThread) {
            return new InterestRequest(channel, attachment, interestOps, false, false, true, nioServiceThread);
        }

        private InterestRequest(SelectableChannel channel, Object attachment, int interestOps, boolean set, boolean add, boolean remove, CommThread nioServiceThread) {
            Assert.eval(remove ^ set ^ add);
            Assert.eval(channel != null);
            this.channel = channel;
            this.attachment = attachment;
            this.set = set;
            this.add = add;
            this.remove = remove;
            this.interestOps = interestOps;
            this.commNIOServiceThread = nioServiceThread;
        }

        public CommThread getCommNIOServiceThread() {
            return this.commNIOServiceThread;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("Interest modify request: ").append(this.channel.toString()).append("\n");
            buf.append("Ops: ").append(Constants.interestOpsToString(this.interestOps)).append("\n");
            buf.append("Set: ").append(this.set).append(", Remove: ").append(this.remove).append(", Add: ").append(this.add).append("\n");
            buf.append("Attachment: ");
            if (this.attachment != null) {
                buf.append(this.attachment.toString());
            } else {
                buf.append("null");
            }
            buf.append("\n");
            return buf.toString();
        }
    }

    protected class CommThread
    extends Thread {
        private final Selector selector;
        private final Queue<Runnable> selectorTasks;
        private final String name;
        private long bytesMoved = 0L;
        private final COMM_THREAD_MODE mode;

        public CommThread(COMM_THREAD_MODE mode) {
            this.name = CoreNIOServices.this.commThreadName + (mode == COMM_THREAD_MODE.NIO_READER ? "_R" : "_W");
            this.setDaemon(true);
            this.setName(this.name);
            this.selector = this.createSelector();
            this.selectorTasks = new ConcurrentLinkedQueue<Runnable>();
            this.mode = mode;
        }

        private Map<String, ?> getCommState() {
            LinkedHashMap<String, Object> state = new LinkedHashMap<String, Object>();
            state.put("name", this.name);
            state.put("mode", (Object)this.mode);
            state.put("bytesMoved", this.bytesMoved);
            state.put("selectorBacklog", this.selectorTasks.size());
            return state;
        }

        private boolean isReader() {
            return this.mode == COMM_THREAD_MODE.NIO_READER;
        }

        @Override
        public void run() {
            try {
                this.selectLoop();
            }
            catch (Throwable t) {
                logger.error("Unhandled exception from selectLoop", t);
                throw new RuntimeException(t);
            }
            finally {
                this.dispose(this.selector, this.selectorTasks);
            }
        }

        public void requestStop() {
            try {
                this.selector.wakeup();
            }
            catch (Exception e) {
                logger.error("Exception trying to stop " + this.getName() + ": ", (Throwable)e);
            }
        }

        private void updateThreadName() {
            this.setName(this.name + CoreNIOServices.this.getListenerString());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Selector createSelector() {
            Selector selector1 = null;
            int tries = 3;
            boolean interrupted = false;
            try {
                int i = 0;
                if (i < 3) {
                    try {
                        Selector selector = selector1 = Selector.open();
                        return selector;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
            finally {
                Util.selfInterruptIfNeeded(interrupted);
            }
            return selector1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addSelectorTask(Runnable task) {
            boolean isInterrupted = false;
            try {
                while (!this.selectorTasks.offer(task)) {
                    try {
                        TimeUnit.SECONDS.sleep(5L);
                        logger.warn("unable to add selector task");
                    }
                    catch (InterruptedException ie) {
                        isInterrupted = true;
                    }
                }
            }
            finally {
                this.selector.wakeup();
                Util.selfInterruptIfNeeded(isInterrupted);
            }
        }

        void unregister(SelectableChannel channel) {
            if (Thread.currentThread() != this) {
                throw new AssertionError((Object)"must unregister from reader thread");
            }
            SelectionKey key = null;
            key = channel.keyFor(this.selector);
            if (key != null) {
                key.cancel();
                key.attach(null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopListener(final ServerSocketChannel ssc, final Runnable callback) {
            if (Thread.currentThread() != this) {
                Runnable task = new Runnable(){

                    @Override
                    public void run() {
                        CommThread.this.stopListener(ssc, callback);
                    }
                };
                this.addSelectorTask(task);
                return;
            }
            try {
                this.cleanupChannel(ssc, null);
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            finally {
                try {
                    callback.run();
                }
                catch (Exception e) {
                    logger.error("Exception: ", (Throwable)e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void cleanupChannel(final Channel ch, final Runnable callback) {
            if (null == ch) {
                logger.warn("null channel passed to cleanupChannel()", new Throwable());
                return;
            }
            if (Thread.currentThread() != this) {
                if (logger.isDebugEnabled()) {
                    logger.debug("queue'ing channel close operation");
                }
                this.addSelectorTask(new Runnable(){

                    @Override
                    public void run() {
                        CommThread.this.cleanupChannel(ch, callback);
                    }
                });
                return;
            }
            try {
                SelectableChannel sc;
                if (ch instanceof SelectableChannel) {
                    sc = (SelectableChannel)ch;
                    try {
                        SelectionKey sk = sc.keyFor(this.selector);
                        if (sk != null) {
                            sk.attach(null);
                            sk.cancel();
                        }
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to clear selection key", (Throwable)e);
                    }
                }
                if (ch instanceof SocketChannel) {
                    sc = (SocketChannel)ch;
                    Socket s = ((SocketChannel)sc).socket();
                    if (null != s) {
                        Socket socket = s;
                        synchronized (socket) {
                            if (s.isConnected()) {
                                try {
                                    if (!s.isOutputShutdown()) {
                                        s.shutdownOutput();
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Exception trying to shutdown socket output: " + e.getMessage());
                                }
                                try {
                                    if (!s.isClosed()) {
                                        s.close();
                                    }
                                }
                                catch (Exception e) {
                                    logger.warn("Exception trying to close() socket: " + e.getMessage());
                                }
                            }
                        }
                    }
                } else if (ch instanceof ServerSocketChannel) {
                    ServerSocketChannel ssc = (ServerSocketChannel)ch;
                    try {
                        ssc.close();
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to close() server socket" + e.getMessage());
                    }
                }
                try {
                    ch.close();
                }
                catch (Exception e) {
                    logger.warn("Exception trying to close channel", (Throwable)e);
                }
            }
            catch (Exception e) {
                logger.error("Unhandled exception in cleanupChannel()", (Throwable)e);
            }
            finally {
                try {
                    if (callback != null) {
                        callback.run();
                    }
                }
                catch (Throwable t) {
                    logger.error("Unhandled exception in cleanupChannel callback.", t);
                }
            }
        }

        private void dispose(Selector localSelector, Queue<Runnable> localSelectorTasks) {
            Assert.eval(Thread.currentThread() == this);
            if (localSelector != null) {
                for (SelectionKey key : localSelector.keys()) {
                    try {
                        this.cleanupChannel(key.channel(), null);
                    }
                    catch (Exception e) {
                        logger.warn("Exception trying to close channel", (Throwable)e);
                    }
                }
                try {
                    localSelector.close();
                }
                catch (Exception e) {
                    if (Os.isMac() && Os.isUnix() && e.getMessage().equals("Bad file descriptor")) {
                        logger.warn("Exception trying to close selector: " + e.getMessage());
                    }
                    logger.error("Exception trying to close selector", (Throwable)e);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void selectLoop() throws IOException {
            Assert.eval(Thread.currentThread() == this);
            localSelector = this.selector;
            localSelectorTasks = this.selectorTasks;
            block8: while (true) {
                try {
                    numKeys = localSelector.select();
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (CancelledKeyException cke) {
                    CoreNIOServices.access$700().warn("Cencelled Key " + cke);
                    continue;
                }
                if (this.isStopRequested()) {
                    if (CoreNIOServices.access$700().isDebugEnabled()) {
                        CoreNIOServices.access$700().debug("Select loop terminating");
                    }
                    return;
                }
                isInterrupted = false;
                while (null != (task = localSelectorTasks.poll())) {
                    try {
                        task.run();
                    }
                    catch (Exception e) {
                        CoreNIOServices.access$700().error("error running selector task", (Throwable)e);
                    }
                }
                Util.selfInterruptIfNeeded(isInterrupted);
                selectedKeys = localSelector.selectedKeys();
                if (0 == numKeys && 0 == selectedKeys.size()) continue;
                iter = selectedKeys.iterator();
                while (true) {
                    if (iter.hasNext()) ** break;
                    continue block8;
                    key = iter.next();
                    iter.remove();
                    if (null == key) {
                        CoreNIOServices.access$700().error("Selection key is null");
                        continue;
                    }
                    try {
                        if (key.isAcceptable()) {
                            this.doAccept(key);
                            continue;
                        }
                        if (key.isConnectable()) {
                            this.doConnect(key);
                            continue;
                        }
                        if (this.isReader() && key.isValid() && key.isReadable()) {
                            reader = (TCChannelReader)key.attachment();
                            do {
                                read = reader.doRead();
                                this.bytesMoved += (long)read;
                            } while (read != 0 && key.isReadable());
                        }
                        if (key.isValid() && !this.isReader() && key.isWritable()) {
                            written = ((TCChannelWriter)key.attachment()).doWrite();
                            this.bytesMoved += (long)written;
                        }
                        if ((conn = (TCConnection)key.attachment()) == null || !conn.isClosePending()) continue;
                        conn.asynchClose();
                        continue;
                    }
                    catch (CancelledKeyException cke) {
                        CoreNIOServices.access$700().debug("selection key cancelled key@" + key.hashCode());
                        continue;
                    }
                    catch (Exception e) {
                        CoreNIOServices.access$700().info("Unhandled exception occured on connection layer", (Throwable)e);
                        attachment = key.attachment();
                        if (attachment instanceof TCConnectionImpl) {
                            conn = (TCConnectionImpl)attachment;
                            if (conn == null) continue;
                            conn.fireErrorEvent(new RuntimeException(e), null);
                            continue;
                        }
                        if (!(attachment instanceof TCListenerImpl)) continue;
                        var10_16 = (TCListenerImpl)key.attachment();
                        continue;
                    }
                    break;
                }
                break;
            }
        }

        private void doAccept(SelectionKey key) {
            SocketChannel sc = null;
            TCListenerImpl lsnr = (TCListenerImpl)key.attachment();
            try {
                ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
                sc = ssc.accept();
                if (sc == null) {
                    logger.warn("New connection accept didn't go through for " + ssc.socket());
                    return;
                }
                sc.configureBlocking(false);
                TCConnectionImpl conn = lsnr.createConnection(sc, CoreNIOServices.this, CoreNIOServices.this.socketParams);
                this.requestReadInterest(conn, sc);
            }
            catch (IOException ioe) {
                if (logger.isInfoEnabled()) {
                    logger.info("IO Exception accepting new connection", (Throwable)ioe);
                }
                this.cleanupChannel(sc, null);
            }
        }

        private void doConnect(SelectionKey key) {
            SocketChannel sc = (SocketChannel)key.channel();
            TCConnectionImpl conn = (TCConnectionImpl)key.attachment();
            try {
                if (sc.finishConnect()) {
                    conn.finishConnect();
                    sc.register(this.selector, 1, conn);
                } else {
                    String errMsg = "finishConnect() returned false, but no exception thrown";
                    if (logger.isInfoEnabled()) {
                        logger.info(errMsg);
                    }
                    conn.fireErrorEvent(new Exception(errMsg), null);
                }
            }
            catch (IOException ioe) {
                if (logger.isInfoEnabled()) {
                    logger.info("IOException attempting to finish socket connection", (Throwable)ioe);
                }
                conn.fireErrorEvent(ioe, null);
            }
        }

        public long getTotalBytesRead() {
            return this.mode == COMM_THREAD_MODE.NIO_READER ? this.bytesMoved : 0L;
        }

        public long getTotalBytesWritten() {
            return this.mode == COMM_THREAD_MODE.NIO_WRITER ? this.bytesMoved : 0L;
        }

        private void handleRequest(final InterestRequest req) {
            if (this.isStopRequested()) {
                return;
            }
            if (Thread.currentThread() == this) {
                this.modifyInterest(req);
            } else {
                final CommThread commTh = req.getCommNIOServiceThread();
                Assert.assertNotNull(commTh);
                commTh.addSelectorTask(new Runnable(){

                    @Override
                    public void run() {
                        commTh.handleRequest(req);
                    }
                });
            }
        }

        private boolean isStopRequested() {
            return CoreNIOServices.this.stopRequested.isSet();
        }

        private void modifyInterest(InterestRequest request) {
            block10: {
                Assert.eval(Thread.currentThread() == this);
                Selector localSelector = null;
                localSelector = this.selector;
                try {
                    int existingOps;
                    SelectionKey key = request.channel.keyFor(localSelector);
                    if (key != null) {
                        if (!key.isValid()) {
                            logger.warn("Skipping modifyInterest - " + Constants.interestOpsToString(request.interestOps) + " on " + request.attachment);
                            return;
                        }
                        existingOps = key.interestOps();
                    } else {
                        existingOps = 0;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("{}", (Object)request);
                    }
                    if (request.add) {
                        request.channel.register(localSelector, existingOps | request.interestOps, request.attachment);
                        break block10;
                    }
                    if (request.set) {
                        request.channel.register(localSelector, request.interestOps, request.attachment);
                        break block10;
                    }
                    if (request.remove) {
                        request.channel.register(localSelector, existingOps ^ request.interestOps, request.attachment);
                        break block10;
                    }
                    throw new TCInternalError();
                }
                catch (ClosedChannelException cce) {
                    logger.warn("Exception trying to process interest request: " + cce);
                }
                catch (CancelledKeyException cke) {
                    logger.warn("Exception trying to process interest request: " + cke);
                }
            }
        }

        void requestConnectInterest(TCConnectionImpl conn, SocketChannel sc) {
            this.handleRequest(InterestRequest.createSetInterestRequest(sc, conn, 8, this));
        }

        void requestReadInterest(TCChannelReader reader, ScatteringByteChannel channel) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createAddInterestRequest((SelectableChannel)((Object)channel), reader, 1, this));
        }

        void requestWriteInterest(TCChannelWriter writer, GatheringByteChannel channel) {
            Assert.eval(!this.isReader());
            this.handleRequest(InterestRequest.createAddInterestRequest((SelectableChannel)((Object)channel), writer, 4, this));
        }

        private void requestAcceptInterest(TCListenerImpl lsnr, ServerSocketChannel ssc) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createSetInterestRequest(ssc, lsnr, 16, this));
        }

        void removeWriteInterest(TCConnectionImpl conn, SelectableChannel channel) {
            Assert.eval(!this.isReader());
            this.handleRequest(InterestRequest.createRemoveInterestRequest(channel, conn, 4, this));
        }

        void removeReadInterest(TCConnectionImpl conn, SelectableChannel channel) {
            Assert.eval(this.isReader());
            this.handleRequest(InterestRequest.createRemoveInterestRequest(channel, conn, 1, this));
        }
    }

    private static enum COMM_THREAD_MODE {
        NIO_READER,
        NIO_WRITER;

    }
}

