/*
 * Decompiled with CFR 0.152.
 */
package com.tc.async.impl;

import com.tc.async.api.DirectExecutionMode;
import com.tc.async.api.EventHandlerException;
import com.tc.async.impl.Event;
import com.tc.async.impl.EventCreator;
import com.tc.util.Assert;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectEventCreator<EC>
implements EventCreator<EC> {
    private final EventCreator<EC> base;
    private final Supplier<Boolean> isIdle;
    private volatile boolean directInflight = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectEventCreator.class);

    public DirectEventCreator(EventCreator<EC> base, Supplier<Boolean> isIdle) {
        this.base = base;
        this.isIdle = isIdle;
        Assert.assertNotNull(this.isIdle);
    }

    @Override
    public Event createEvent(EC event) {
        if (this.isSingleThreaded()) {
            try {
                this.directInflight = true;
                Assert.assertTrue(this.isIdle.get());
                this.base.createEvent(event).call();
                Assert.assertTrue(this.isIdle.get());
            }
            catch (EventHandlerException ee) {
                throw new RuntimeException(ee);
            }
            finally {
                this.directInflight = false;
            }
            return null;
        }
        if (this.directInflight) {
            throw new AssertionError();
        }
        return this.base.createEvent(event);
    }

    private boolean isSingleThreaded() {
        if (LOGGER.isDebugEnabled()) {
            if (DirectExecutionMode.isActivated()) {
                return this.isIdle.get() != false;
            }
            return false;
        }
        return DirectExecutionMode.isActivated() && this.isIdle.get() != false;
    }
}

