/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.core.ConnectionInfo;
import com.tc.net.protocol.transport.ClientConnectionErrorListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ClientConnectionErrorDetails
implements ClientConnectionErrorListener {
    private volatile ConcurrentHashMap<ConnectionInfo, ConcurrentLinkedQueue<Exception>> exceptionMap;

    @Override
    public void onError(ConnectionInfo connInfo, Exception e) {
        ConcurrentHashMap<ConnectionInfo, ConcurrentLinkedQueue<Exception>> internalExceptionCollector = this.exceptionMap;
        if (internalExceptionCollector != null) {
            ConcurrentLinkedQueue<Exception> exceptionList = new ConcurrentLinkedQueue<Exception>();
            exceptionList.add(e);
            internalExceptionCollector.put(connInfo, exceptionList);
        }
    }

    public Map<String, List<Exception>> getErrors() {
        HashMap<String, List<Exception>> errorMessagesMap = new HashMap<String, List<Exception>>();
        ConcurrentHashMap<ConnectionInfo, ConcurrentLinkedQueue<Exception>> internalExceptionCollector = this.exceptionMap;
        if (internalExceptionCollector != null) {
            for (Map.Entry<ConnectionInfo, ConcurrentLinkedQueue<Exception>> entry : internalExceptionCollector.entrySet()) {
                ConnectionInfo connInfo = entry.getKey();
                ConcurrentLinkedQueue<Exception> exceptionList = entry.getValue();
                Object[] errorObjects = exceptionList.toArray();
                ArrayList<Exception> errorMessages = new ArrayList<Exception>();
                for (Object errorObj : errorObjects) {
                    Exception e = (Exception)errorObj;
                    errorMessages.add(e);
                }
                errorMessagesMap.put(connInfo.toString(), errorMessages);
            }
        }
        return errorMessagesMap;
    }

    public void attachCollector() {
        this.exceptionMap = new ConcurrentHashMap();
    }

    public void removeCollector() {
        this.exceptionMap = null;
    }
}

