/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class AddressChecker {
    private final Set<InetAddress> allLocalAddresses = this.findAllLocalAddresses();

    public Set<InetAddress> getAllLocalAddresses() {
        return this.allLocalAddresses;
    }

    public boolean isLegalBindAddress(InetAddress bindAddress) {
        if (bindAddress.isAnyLocalAddress()) {
            return true;
        }
        if (bindAddress.isLoopbackAddress()) {
            return true;
        }
        return this.allLocalAddresses.contains(bindAddress);
    }

    private Set<InetAddress> findAllLocalAddresses() {
        Enumeration<NetworkInterface> nics;
        HashSet<InetAddress> rv = new HashSet<InetAddress>();
        try {
            nics = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            throw new RuntimeException(e);
        }
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            Enumeration<InetAddress> ips = nic.getInetAddresses();
            while (ips.hasMoreElements()) {
                rv.add(ips.nextElement());
            }
        }
        return Collections.unmodifiableSet(rv);
    }
}

