/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.net.URI;
import java.net.URISyntaxException;

final class URIUtils {
    private URIUtils() {
    }

    static void validateTerracottaURI(URI uri) throws URISyntaxException {
        String path = uri.getPath();
        if (path != null && path.length() > 0 && !path.equals("/")) {
            throw new URISyntaxException(uri.toString(), "A path should not be specified in a Terracotta URI");
        }
        String query = uri.getQuery();
        if (query != null) {
            throw new URISyntaxException(uri.toString(), "A query should not be specified in a Terracotta URI");
        }
        String fragment = uri.getFragment();
        if (fragment != null) {
            throw new URISyntaxException(uri.toString(), "A fragment should not be specified in a Terracotta URI");
        }
    }
}

