/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util.concurrent;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteSequentialMap<K, V>
extends LinkedHashMap<K, V> {
    private volatile Map<K, V> _snapshot;
    private final TypedArrayFactory _factory;
    private boolean inPutAll = false;
    private static final TypedArrayFactory DEFAULT_TYPED_ARRAY_FACTORY = new TypedArrayFactory(){

        public Object[] createTypedArray(int size) {
            return new Object[size];
        }
    };

    public CopyOnWriteSequentialMap(int initialCapacity, float loadFactor) {
        this(initialCapacity, loadFactor, DEFAULT_TYPED_ARRAY_FACTORY);
    }

    public CopyOnWriteSequentialMap(int initialCapacity) {
        this(initialCapacity, DEFAULT_TYPED_ARRAY_FACTORY);
    }

    public CopyOnWriteSequentialMap() {
        this(DEFAULT_TYPED_ARRAY_FACTORY);
    }

    public CopyOnWriteSequentialMap(Map<? extends K, ? extends V> m) {
        this(m, DEFAULT_TYPED_ARRAY_FACTORY);
    }

    public CopyOnWriteSequentialMap(int initialCapacity, float loadFactor, TypedArrayFactory f) {
        super(initialCapacity, loadFactor);
        this._factory = f;
        this.takeSnapshot();
    }

    public CopyOnWriteSequentialMap(int initialCapacity, TypedArrayFactory f) {
        super(initialCapacity);
        this._factory = f;
        this.takeSnapshot();
    }

    public CopyOnWriteSequentialMap(TypedArrayFactory f) {
        this._factory = f;
        this.takeSnapshot();
    }

    public CopyOnWriteSequentialMap(Map<? extends K, ? extends V> m, TypedArrayFactory f) {
        super(m);
        this._factory = f;
        this.takeSnapshot();
    }

    @Override
    public synchronized void clear() {
        super.clear();
        this.takeSnapshot();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this._snapshot.entrySet();
    }

    @Override
    public Set<K> keySet() {
        return this._snapshot.keySet();
    }

    @Override
    public synchronized V put(K key, V value) {
        V old = super.put(key, value);
        this.takeSnapshot();
        return old;
    }

    @Override
    public synchronized V remove(Object key) {
        Object old = super.remove(key);
        this.takeSnapshot();
        return old;
    }

    @Override
    public Collection<V> values() {
        return this._snapshot.values();
    }

    public <R> R[] valuesToArray() {
        Collection<V> values = this.values();
        return values.toArray(this._factory.createTypedArray(values.size()));
    }

    @Override
    public int size() {
        return this._snapshot.size();
    }

    @Override
    public boolean isEmpty() {
        return this._snapshot.isEmpty();
    }

    @Override
    public V get(Object key) {
        return this._snapshot.get(key);
    }

    @Override
    public boolean containsKey(Object key) {
        return this._snapshot.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this._snapshot.containsValue(value);
    }

    @Override
    public boolean equals(Object o) {
        return this._snapshot.equals(o);
    }

    @Override
    public int hashCode() {
        return this._snapshot.hashCode();
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        this.inPutAll = true;
        try {
            super.putAll(m);
        }
        finally {
            this.inPutAll = false;
            this.takeSnapshot();
        }
    }

    private void takeSnapshot() {
        if (this.inPutAll) {
            return;
        }
        LinkedHashMap temp = new LinkedHashMap();
        for (Map.Entry e : super.entrySet()) {
            temp.put(e.getKey(), e.getValue());
        }
        this._snapshot = Collections.unmodifiableMap(temp);
    }

    public static interface TypedArrayFactory {
        public <R> R[] createTypedArray(int var1);
    }
}

