/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.messages;

import java.util.Set;
import org.ehcache.clustered.common.internal.exceptions.ClusterException;
import org.ehcache.clustered.common.internal.messages.EhcacheResponseType;
import org.ehcache.clustered.common.internal.store.Chain;
import org.terracotta.entity.EntityResponse;

public abstract class EhcacheEntityResponse
implements EntityResponse {
    public abstract EhcacheResponseType getResponseType();

    public static Success success() {
        return Success.INSTANCE;
    }

    public static Failure failure(ClusterException cause) {
        return new Failure(cause);
    }

    public static GetResponse getResponse(Chain chain) {
        return new GetResponse(chain);
    }

    public static HashInvalidationDone hashInvalidationDone(long key) {
        return new HashInvalidationDone(key);
    }

    public static AllInvalidationDone allInvalidationDone() {
        return new AllInvalidationDone();
    }

    public static ServerInvalidateHash serverInvalidateHash(long key) {
        return new ServerInvalidateHash(key);
    }

    public static ClientInvalidateHash clientInvalidateHash(long key, int invalidationId) {
        return new ClientInvalidateHash(key, invalidationId);
    }

    public static ClientInvalidateAll clientInvalidateAll(int invalidationId) {
        return new ClientInvalidateAll(invalidationId);
    }

    public static MapValue mapValue(Object value) {
        return new MapValue(value);
    }

    public static PrepareForDestroy prepareForDestroy(Set<String> stores) {
        return new PrepareForDestroy(stores);
    }

    public static ResolveRequest resolveRequest(long key, Chain chain) {
        return new ResolveRequest(key, chain);
    }

    public static LockSuccess lockSuccess(Chain chain) {
        return new LockSuccess(chain);
    }

    public static LockFailure lockFailure() {
        return new LockFailure();
    }

    public static class LockFailure
    extends EhcacheEntityResponse {
        private LockFailure() {
        }

        @Override
        public EhcacheResponseType getResponseType() {
            return EhcacheResponseType.LOCK_FAILURE;
        }
    }

    public static class LockSuccess
    extends EhcacheEntityResponse {
        private final Chain chain;

        LockSuccess(Chain chain) {
            this.chain = chain;
        }

        public Chain getChain() {
            return this.chain;
        }

        @Override
        public EhcacheResponseType getResponseType() {
            return EhcacheResponseType.LOCK_SUCCESS;
        }
    }

    public static class ResolveRequest
    extends EhcacheEntityResponse {
        private final long key;
        private final Chain chain;

        ResolveRequest(long key, Chain chain) {
            this.key = key;
            this.chain = chain;
        }

        @Override
        public EhcacheResponseType getResponseType() {
            return EhcacheResponseType.RESOLVE_REQUEST;
        }

        public long getKey() {
            return this.key;
        }

        public Chain getChain() {
            return this.chain;
        }
    }

    public static class PrepareForDestroy
    extends EhcacheEntityResponse {
        private final Set<String> stores;

        private PrepareForDestroy(Set<String> stores) {
            this.stores = stores;
        }

        @Override
        public EhcacheResponseType getResponseType() {
            return EhcacheResponseType.PREPARE_FOR_DESTROY;
        }

        public Set<String> getStores() {
            return this.stores;
        }
    }

    public static class MapValue
    extends EhcacheEntityResponse {
        private final Object value;

        private MapValue(Object value) {
            this.value = value;
        }

        public Object getValue() {
            return this.value;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.MAP_VALUE;
        }
    }

    public static class ClientInvalidateAll
    extends EhcacheEntityResponse {
        private final int invalidationId;

        private ClientInvalidateAll(int invalidationId) {
            this.invalidationId = invalidationId;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.CLIENT_INVALIDATE_ALL;
        }
    }

    public static class ClientInvalidateHash
    extends EhcacheEntityResponse {
        private final long key;
        private final int invalidationId;

        private ClientInvalidateHash(long key, int invalidationId) {
            this.key = key;
            this.invalidationId = invalidationId;
        }

        public long getKey() {
            return this.key;
        }

        public int getInvalidationId() {
            return this.invalidationId;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.CLIENT_INVALIDATE_HASH;
        }
    }

    public static class ServerInvalidateHash
    extends EhcacheEntityResponse {
        private final long key;

        private ServerInvalidateHash(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.SERVER_INVALIDATE_HASH;
        }
    }

    public static class AllInvalidationDone
    extends EhcacheEntityResponse {
        private AllInvalidationDone() {
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.ALL_INVALIDATION_DONE;
        }
    }

    public static class HashInvalidationDone
    extends EhcacheEntityResponse {
        private final long key;

        private HashInvalidationDone(long key) {
            this.key = key;
        }

        public long getKey() {
            return this.key;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.HASH_INVALIDATION_DONE;
        }
    }

    public static class GetResponse
    extends EhcacheEntityResponse {
        private final Chain chain;

        private GetResponse(Chain chain) {
            this.chain = chain;
        }

        public Chain getChain() {
            return this.chain;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.GET_RESPONSE;
        }
    }

    public static class Failure
    extends EhcacheEntityResponse {
        private final ClusterException cause;

        private Failure(ClusterException cause) {
            this.cause = cause;
        }

        public ClusterException getCause() {
            return this.cause;
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.FAILURE;
        }
    }

    public static class Success
    extends EhcacheEntityResponse {
        private static final Success INSTANCE = new Success();

        private Success() {
        }

        @Override
        public final EhcacheResponseType getResponseType() {
            return EhcacheResponseType.SUCCESS;
        }
    }
}

