/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.transport;

import com.tc.net.protocol.transport.ConnectionHealthCheckerContext;
import com.tc.net.protocol.transport.ConnectionHealthCheckerImpl;
import com.tc.net.protocol.transport.HealthCheckerProbeMessage;
import com.tc.net.protocol.transport.HealthCheckerProbeMessageFactory;
import com.tc.net.protocol.transport.MessageTransportBase;
import com.tc.net.protocol.transport.TransportMessageFactoryImpl;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHealthCheckerContextEchoImpl
implements ConnectionHealthCheckerContext {
    private final MessageTransportBase transport;
    private final HealthCheckerProbeMessageFactory messageFactory;
    private final Logger logger = LoggerFactory.getLogger(ConnectionHealthCheckerImpl.class);

    public ConnectionHealthCheckerContextEchoImpl(MessageTransportBase mtb) {
        this.transport = mtb;
        this.messageFactory = new TransportMessageFactoryImpl();
    }

    @Override
    public boolean receiveProbe(HealthCheckerProbeMessage message) {
        if (message.isPing()) {
            HealthCheckerProbeMessage pingReplyMessage = this.messageFactory.createPingReply(this.transport.getConnectionID(), this.transport.getConnection());
            try {
                this.transport.send(pingReplyMessage);
            }
            catch (IOException ioe) {
                this.logger.warn("trouble ping", (Throwable)ioe);
                return false;
            }
            return true;
        }
        if (message.isTimeCheck()) {
            return true;
        }
        this.logger.info(message.toString());
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public void checkTime() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public boolean probeIfAlive() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }

    @Override
    public void refresh() {
        throw new AssertionError((Object)"Echo HealthChecker");
    }
}

