/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.statistics.derived.latency;

import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.statistics.Time;
import org.terracotta.statistics.derived.latency.LatencyPeriodAccumulator;
import org.terracotta.statistics.derived.latency.LatencyStatistic;
import org.terracotta.statistics.observer.ChainedEventObserver;

public class LatencySimpleMovingAverage
implements ChainedEventObserver,
LatencyStatistic {
    private static final int PARTITION_COUNT = 10;
    private final Queue<LatencyPeriodAccumulator> archive = new ConcurrentLinkedQueue<LatencyPeriodAccumulator>();
    private final AtomicReference<LatencyPeriodAccumulator> activePartition;
    private final long windowSize;
    private final long partitionSize;

    public LatencySimpleMovingAverage(long time, TimeUnit unit) {
        this(time, unit, 10);
    }

    public LatencySimpleMovingAverage(long time, TimeUnit unit, int partitionCount) {
        this.windowSize = unit.toNanos(time);
        this.partitionSize = this.windowSize / (long)partitionCount;
        this.activePartition = new AtomicReference<LatencyPeriodAccumulator>(new LatencyPeriodAccumulator(Long.MIN_VALUE, this.partitionSize, new long[0]));
    }

    @Override
    public final double average() {
        LatencyPeriodAccumulator partition;
        long startTime = Time.time() - this.windowSize;
        LatencyPeriodAccumulator current = this.activePartition.get();
        if (current.isBefore(startTime)) {
            return Double.NaN;
        }
        long total = current.accumulator().total();
        long count = current.accumulator().count();
        Iterator it = this.archive.iterator();
        while (it.hasNext() && (partition = (LatencyPeriodAccumulator)it.next()) != current) {
            if (partition.isBefore(startTime)) {
                it.remove();
                continue;
            }
            total += partition.accumulator().total();
            count += partition.accumulator().count();
        }
        return (double)total / (double)count;
    }

    @Override
    public final Long maximum() {
        LatencyPeriodAccumulator partition;
        long startTime = Time.time() - this.windowSize;
        LatencyPeriodAccumulator current = this.activePartition.get();
        if (current.isBefore(startTime)) {
            return null;
        }
        long maximum = current.maximum();
        Iterator it = this.archive.iterator();
        while (it.hasNext() && (partition = (LatencyPeriodAccumulator)it.next()) != current) {
            if (partition.isBefore(startTime)) {
                it.remove();
                continue;
            }
            maximum = Math.max(maximum, partition.maximum());
        }
        return maximum;
    }

    @Override
    public final Long minimum() {
        LatencyPeriodAccumulator partition;
        long startTime = Time.time() - this.windowSize;
        LatencyPeriodAccumulator current = this.activePartition.get();
        if (current.isBefore(startTime)) {
            return null;
        }
        long minimum = current.minimum();
        Iterator it = this.archive.iterator();
        while (it.hasNext() && (partition = (LatencyPeriodAccumulator)it.next()) != current) {
            if (partition.isBefore(startTime)) {
                it.remove();
                continue;
            }
            minimum = Math.min(minimum, partition.minimum());
        }
        return minimum;
    }

    @Override
    public void event(long timeNs, long latencyNs) {
        LatencyPeriodAccumulator partition;
        do {
            if (!(partition = this.activePartition.get()).tryAccumulate(timeNs, latencyNs)) continue;
            return;
        } while (!this.activePartition.compareAndSet(partition, new LatencyPeriodAccumulator(timeNs, this.partitionSize, latencyNs)));
        this.archive(partition);
    }

    private void archive(LatencyPeriodAccumulator partition) {
        this.archive.add(partition);
        long startTime = partition.end() - this.windowSize;
        LatencyPeriodAccumulator earliest = this.archive.peek();
        while (earliest != null && earliest.isBefore(startTime) && !this.archive.remove(earliest)) {
            earliest = this.archive.peek();
        }
    }
}

