/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store.operations;

import java.nio.ByteBuffer;
import org.ehcache.clustered.client.internal.store.operations.Operation;
import org.ehcache.clustered.client.internal.store.operations.OperationCode;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.CodecException;
import org.ehcache.spi.serialization.Serializer;

public class RemoveOperation<K, V>
implements Operation<K, V> {
    private final K key;
    private final long timeStamp;

    public RemoveOperation(K key, long timeStamp) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        this.key = key;
        this.timeStamp = timeStamp;
    }

    RemoveOperation(ByteBuffer buffer, Serializer<K> keySerializer) {
        OperationCode opCode = OperationCode.valueOf(buffer.get());
        if (opCode != this.getOpCode()) {
            throw new IllegalArgumentException("Invalid operation: " + (Object)((Object)opCode));
        }
        this.timeStamp = buffer.getLong();
        ByteBuffer keyBlob = buffer.slice();
        try {
            this.key = keySerializer.read(keyBlob);
        }
        catch (ClassNotFoundException e) {
            throw new CodecException(e);
        }
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public OperationCode getOpCode() {
        return OperationCode.REMOVE;
    }

    @Override
    public Result<K, V> apply(Result<K, V> previousOperation) {
        return null;
    }

    @Override
    public ByteBuffer encode(Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        ByteBuffer keyBuf = keySerializer.serialize(this.key);
        int size = 9 + keyBuf.remaining();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.put(this.getOpCode().getValue());
        buffer.putLong(this.timeStamp);
        buffer.put(keyBuf);
        buffer.flip();
        return buffer;
    }

    public String toString() {
        return "{" + (Object)((Object)this.getOpCode()) + "# key: " + this.key + "}";
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveOperation)) {
            return false;
        }
        RemoveOperation other = (RemoveOperation)obj;
        if (this.getOpCode() != other.getOpCode()) {
            return false;
        }
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        int hash = this.getOpCode().hashCode();
        hash = hash * 31 + this.key.hashCode();
        return hash;
    }

    @Override
    public long timeStamp() {
        if (!this.isExpiryAvailable()) {
            return this.timeStamp;
        }
        throw new RuntimeException("Timestamp not available");
    }

    @Override
    public boolean isExpiryAvailable() {
        return this.timeStamp < 0L;
    }

    @Override
    public long expirationTime() {
        if (this.isExpiryAvailable()) {
            return -this.timeStamp;
        }
        throw new RuntimeException("Expiry not available");
    }
}

