/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.common.internal.store;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Predicate;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.clustered.common.internal.store.Element;
import org.ehcache.clustered.common.internal.store.FilteredObjectInputStream;
import org.ehcache.clustered.common.internal.store.SequencedElement;
import org.ehcache.clustered.common.internal.util.ByteBufferInputStream;

public class Util {
    public static final Chain EMPTY_CHAIN = new Chain(){

        @Override
        public Iterator<Element> reverseIterator() {
            return Collections.emptyList().iterator();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int length() {
            return 0;
        }

        @Override
        public Iterator<Element> iterator() {
            return Collections.emptyList().iterator();
        }
    };

    public static final <T> Iterator<T> reverseIterator(List<T> list) {
        final ListIterator<T> listIterator = list.listIterator(list.size());
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public T next() {
                return listIterator.previous();
            }

            @Override
            public void remove() {
                listIterator.remove();
            }
        };
    }

    public static long readPayLoad(ByteBuffer byteBuffer) {
        return byteBuffer.getLong();
    }

    public static ByteBuffer createPayload(long key) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8).putLong(key);
        byteBuffer.flip();
        return byteBuffer.asReadOnlyBuffer();
    }

    public static ByteBuffer createPayload(long key, int payloadSize) {
        if (payloadSize < 8) {
            throw new IllegalArgumentException("payload must be at least 8 bytes long");
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(payloadSize);
        byteBuffer.putLong(key);
        for (int i = 0; i < payloadSize - 8; ++i) {
            byteBuffer.put((byte)0);
        }
        byteBuffer.flip();
        return byteBuffer.asReadOnlyBuffer();
    }

    public static boolean chainsEqual(Chain chain1, Chain chain2) {
        Iterator it1 = chain1.iterator();
        Iterator it2 = chain2.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Element next1 = (Element)it1.next();
            Element next2 = (Element)it2.next();
            if (next1.getPayload().equals(next2.getPayload())) continue;
            return false;
        }
        return !it1.hasNext() && !it2.hasNext();
    }

    public static Element getElement(ByteBuffer payload) {
        return payload::duplicate;
    }

    public static Chain getChain(boolean isSequenced, ByteBuffer ... buffers) {
        ArrayList<Element> elements = new ArrayList<Element>();
        long counter = 0L;
        for (ByteBuffer buffer : buffers) {
            if (isSequenced) {
                elements.add(Util.getElement(counter++, buffer));
                continue;
            }
            elements.add(Util.getElement(buffer));
        }
        return Util.getChain(elements);
    }

    public static Chain getChain(final List<Element> elements) {
        return new Chain(){
            private final List<Element> list;
            {
                this.list = Collections.unmodifiableList(elements);
            }

            @Override
            public Iterator<Element> reverseIterator() {
                return Util.reverseIterator(this.list);
            }

            @Override
            public boolean isEmpty() {
                return this.list.isEmpty();
            }

            @Override
            public int length() {
                return this.list.size();
            }

            @Override
            public Iterator<Element> iterator() {
                return this.list.iterator();
            }
        };
    }

    public static SequencedElement getElement(final long sequence, final ByteBuffer payload) {
        return new SequencedElement(){

            @Override
            public long getSequenceNumber() {
                return sequence;
            }

            @Override
            public ByteBuffer getPayload() {
                return payload.duplicate();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object unmarshall(ByteBuffer payload, Predicate<Class<?>> isClassPermitted) {
        try (FilteredObjectInputStream objectInputStream = new FilteredObjectInputStream(new ByteBufferInputStream(payload), isClassPermitted, null);){
            Object object = objectInputStream.readObject();
            return object;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static byte[] marshall(Object message) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream oout = new ObjectOutputStream(out);){
            oout.writeObject(message);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        return out.toByteArray();
    }
}

