/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.loaderwriter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.ehcache.clustered.client.internal.loaderwriter.DelegatingLoaderWriterStore;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.config.ResourceType;
import org.ehcache.core.internal.store.StoreSupport;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.WrapperStore;
import org.ehcache.impl.internal.concurrent.ConcurrentHashMap;
import org.ehcache.impl.internal.store.loaderwriter.LoaderWriterStoreProvider;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterConfiguration;
import org.ehcache.spi.loaderwriter.CacheLoaderWriterProvider;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;

@ServiceDependencies(value={CacheLoaderWriterProvider.class, ClusteringService.class})
public class DelegatingLoaderWriterStoreProvider
implements WrapperStore.Provider {
    private volatile ServiceProvider<Service> serviceProvider;
    private final Map<Store<?, ?>, LoaderWriterStoreProvider.StoreRef<?, ?>> createdStores = new ConcurrentHashMap();

    public <K, V> Store<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
        Store.Provider underlyingStoreProvider = StoreSupport.selectStoreProvider(this.serviceProvider, (Set)storeConfig.getResourcePools().getResourceTypeSet(), Arrays.asList(serviceConfigs));
        Store store = underlyingStoreProvider.createStore(storeConfig, serviceConfigs);
        DelegatingLoaderWriterStore loaderWriterStore = new DelegatingLoaderWriterStore(store);
        this.createdStores.put((Store<?, ?>)loaderWriterStore, (LoaderWriterStoreProvider.StoreRef<?, ?>)new LoaderWriterStoreProvider.StoreRef(store, underlyingStoreProvider));
        return loaderWriterStore;
    }

    public void releaseStore(Store<?, ?> resource) {
        LoaderWriterStoreProvider.StoreRef<?, ?> storeRef = this.createdStores.remove(resource);
        storeRef.getUnderlyingStoreProvider().releaseStore(storeRef.getUnderlyingStore());
    }

    public void initStore(Store<?, ?> resource) {
        LoaderWriterStoreProvider.StoreRef<?, ?> storeRef = this.createdStores.get(resource);
        storeRef.getUnderlyingStoreProvider().initStore(storeRef.getUnderlyingStore());
    }

    public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
        throw new UnsupportedOperationException("Its a Wrapper store provider, does not support regular ranking");
    }

    public void start(ServiceProvider<Service> serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void stop() {
        this.serviceProvider = null;
    }

    public int wrapperStoreRank(Collection<ServiceConfiguration<?>> serviceConfigs) {
        CacheLoaderWriterConfiguration loaderWriterConfiguration = (CacheLoaderWriterConfiguration)ServiceUtils.findSingletonAmongst(CacheLoaderWriterConfiguration.class, serviceConfigs);
        ClusteringService.ClusteredCacheIdentifier clusteredCacheIdentifier = (ClusteringService.ClusteredCacheIdentifier)ServiceUtils.findSingletonAmongst(ClusteringService.ClusteredCacheIdentifier.class, serviceConfigs);
        if (clusteredCacheIdentifier != null && loaderWriterConfiguration != null) {
            return 3;
        }
        return 0;
    }
}

