/*
 * Decompiled with CFR 0.152.
 */
package com.tc.lang;

import com.tc.util.runtime.Vm;
import java.lang.reflect.Field;

public class StartupHelper {
    private final StartupAction action;
    private final ThreadGroup targetThreadGroup;

    public StartupHelper(ThreadGroup threadGroup, StartupAction action) {
        this.targetThreadGroup = threadGroup;
        this.action = action;
    }

    public void startUp() {
        Thread currentThread = Thread.currentThread();
        ThreadGroup origThreadGroup = currentThread.getThreadGroup();
        StartupHelper.setThreadGroup(currentThread, this.targetThreadGroup);
        try {
            this.action.execute();
        }
        catch (Throwable t) {
            this.targetThreadGroup.uncaughtException(currentThread, t);
            throw new RuntimeException(t);
        }
        finally {
            StartupHelper.setThreadGroup(currentThread, origThreadGroup);
        }
    }

    private static void setThreadGroup(Thread thread, ThreadGroup group) {
        String fieldName = "group";
        Class<Thread> c = Thread.class;
        if (Vm.isIBM() && StartupHelper.isFieldPresent("threadGroup", c)) {
            fieldName = "threadGroup";
        }
        try {
            Field groupField = c.getDeclaredField(fieldName);
            groupField.setAccessible(true);
            groupField.set(thread, group);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    private static boolean isFieldPresent(String fieldName, Class<Thread> targetClass) {
        Field[] fields;
        boolean found = false;
        for (Field field : fields = targetClass.getDeclaredFields()) {
            if (!field.getName().equals(fieldName)) continue;
            found = true;
            break;
        }
        return found;
    }

    public static interface StartupAction {
        public void execute() throws Throwable;
    }
}

