/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.store;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.ehcache.Cache;
import org.ehcache.CachePersistenceException;
import org.ehcache.clustered.client.config.ClusteredResourceType;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.internal.store.ClusteredValueHolder;
import org.ehcache.clustered.client.internal.store.ReconnectingServerStoreProxy;
import org.ehcache.clustered.client.internal.store.ResolvedChain;
import org.ehcache.clustered.client.internal.store.ServerStoreProxy;
import org.ehcache.clustered.client.internal.store.operations.ChainResolver;
import org.ehcache.clustered.client.internal.store.operations.ConditionalRemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ConditionalReplaceOperation;
import org.ehcache.clustered.client.internal.store.operations.EternalChainResolver;
import org.ehcache.clustered.client.internal.store.operations.ExpiryChainResolver;
import org.ehcache.clustered.client.internal.store.operations.PutIfAbsentOperation;
import org.ehcache.clustered.client.internal.store.operations.PutOperation;
import org.ehcache.clustered.client.internal.store.operations.RemoveOperation;
import org.ehcache.clustered.client.internal.store.operations.ReplaceOperation;
import org.ehcache.clustered.client.internal.store.operations.Result;
import org.ehcache.clustered.client.internal.store.operations.codecs.OperationsCodec;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.internal.store.Chain;
import org.ehcache.config.ResourceType;
import org.ehcache.config.builders.ExpiryPolicyBuilder;
import org.ehcache.core.CacheConfigurationChangeListener;
import org.ehcache.core.Ehcache;
import org.ehcache.core.collections.ConcurrentWeakIdentityHashMap;
import org.ehcache.core.events.CacheEventListenerConfiguration;
import org.ehcache.core.events.NullStoreEventDispatcher;
import org.ehcache.core.exceptions.StorePassThroughException;
import org.ehcache.core.spi.service.ExecutionService;
import org.ehcache.core.spi.service.ServiceUtils;
import org.ehcache.core.spi.store.Store;
import org.ehcache.core.spi.store.events.StoreEventSource;
import org.ehcache.core.spi.store.tiering.AuthoritativeTier;
import org.ehcache.core.spi.time.TimeSource;
import org.ehcache.core.spi.time.TimeSourceService;
import org.ehcache.core.statistics.AuthoritativeTierOperationOutcomes;
import org.ehcache.core.statistics.StoreOperationOutcomes;
import org.ehcache.core.statistics.TierOperationOutcomes;
import org.ehcache.expiry.ExpiryPolicy;
import org.ehcache.impl.config.loaderwriter.DefaultCacheLoaderWriterConfiguration;
import org.ehcache.impl.store.HashUtils;
import org.ehcache.spi.persistence.StateRepository;
import org.ehcache.spi.resilience.StoreAccessException;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.serialization.StatefulSerializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceDependencies;
import org.ehcache.spi.service.ServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.statistics.MappedOperationStatistic;
import org.terracotta.statistics.StatisticBuilder;
import org.terracotta.statistics.StatisticsManager;
import org.terracotta.statistics.observer.OperationObserver;

public class ClusteredStore<K, V>
implements AuthoritativeTier<K, V> {
    private static final String STATISTICS_TAG = "Clustered";
    private static final int TIER_HEIGHT = ClusteredResourceType.Types.UNKNOWN.getTierHeight();
    static final String CHAIN_COMPACTION_THRESHOLD_PROP = "ehcache.client.chain.compaction.threshold";
    static final int DEFAULT_CHAIN_COMPACTION_THRESHOLD = 4;
    private final int chainCompactionLimit = Integer.getInteger("ehcache.client.chain.compaction.threshold", 4);
    private final OperationsCodec<K, V> codec;
    private final ChainResolver<K, V> resolver;
    private final TimeSource timeSource;
    private volatile ServerStoreProxy storeProxy;
    private volatile AuthoritativeTier.InvalidationValve invalidationValve;
    private final OperationObserver<StoreOperationOutcomes.GetOutcome> getObserver;
    private final OperationObserver<StoreOperationOutcomes.PutOutcome> putObserver;
    private final OperationObserver<StoreOperationOutcomes.RemoveOutcome> removeObserver;
    private final OperationObserver<StoreOperationOutcomes.PutIfAbsentOutcome> putIfAbsentObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalRemoveOutcome> conditionalRemoveObserver;
    private final OperationObserver<StoreOperationOutcomes.ReplaceOutcome> replaceObserver;
    private final OperationObserver<StoreOperationOutcomes.ConditionalReplaceOutcome> conditionalReplaceObserver;
    private final OperationObserver<StoreOperationOutcomes.EvictionOutcome> evictionObserver;
    private final OperationObserver<AuthoritativeTierOperationOutcomes.GetAndFaultOutcome> getAndFaultObserver;

    private ClusteredStore(OperationsCodec<K, V> codec, ChainResolver<K, V> resolver, TimeSource timeSource) {
        this.codec = codec;
        this.resolver = resolver;
        this.timeSource = timeSource;
        this.getObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.GetOutcome.class).of((Object)this)).named("get")).tag(new String[]{STATISTICS_TAG})).build();
        this.putObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutOutcome.class).of((Object)this)).named("put")).tag(new String[]{STATISTICS_TAG})).build();
        this.removeObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.RemoveOutcome.class).of((Object)this)).named("remove")).tag(new String[]{STATISTICS_TAG})).build();
        this.putIfAbsentObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.PutIfAbsentOutcome.class).of((Object)this)).named("putIfAbsent")).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalRemoveObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalRemoveOutcome.class).of((Object)this)).named("conditionalRemove")).tag(new String[]{STATISTICS_TAG})).build();
        this.replaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ReplaceOutcome.class).of((Object)this)).named("replace")).tag(new String[]{STATISTICS_TAG})).build();
        this.conditionalReplaceObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.ConditionalReplaceOutcome.class).of((Object)this)).named("conditionalReplace")).tag(new String[]{STATISTICS_TAG})).build();
        this.evictionObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(StoreOperationOutcomes.EvictionOutcome.class).of((Object)this)).named("eviction")).tag(new String[]{STATISTICS_TAG})).build();
        this.getAndFaultObserver = ((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)((StatisticBuilder.OperationStatisticBuilder)StatisticBuilder.operation(AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.class).of((Object)this)).named("getAndFault")).tag(new String[]{STATISTICS_TAG})).build();
    }

    ClusteredStore(OperationsCodec<K, V> codec, EternalChainResolver<K, V> resolver, ServerStoreProxy proxy, TimeSource timeSource) {
        this(codec, resolver, timeSource);
        this.storeProxy = proxy;
    }

    public Store.ValueHolder<V> get(K key) throws StoreAccessException {
        Store.ValueHolder<V> value;
        this.getObserver.begin();
        try {
            value = this.getInternal(key);
        }
        catch (TimeoutException e) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.TIMEOUT);
            return null;
        }
        if (value == null) {
            this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.MISS);
            return null;
        }
        this.getObserver.end((Enum)StoreOperationOutcomes.GetOutcome.HIT);
        return value;
    }

    private Store.ValueHolder<V> getInternal(K key) throws StoreAccessException, TimeoutException {
        ClusteredValueHolder<V> holder = null;
        try {
            Chain chain = this.storeProxy.get(this.extractLongKey(key));
            if (!chain.isEmpty()) {
                Result<K, V> resolvedResult;
                ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
                if (resolvedChain.isCompacted()) {
                    Chain compactedChain = resolvedChain.getCompactedChain();
                    this.storeProxy.replaceAtHead(this.extractLongKey(key), chain, compactedChain);
                }
                if ((resolvedResult = resolvedChain.getResolvedResult(key)) != null) {
                    V value = resolvedResult.getValue();
                    long expirationTime = resolvedChain.getExpirationTime();
                    holder = expirationTime == Long.MAX_VALUE ? new ClusteredValueHolder<V>(value) : new ClusteredValueHolder<V>(value, expirationTime);
                }
            }
        }
        catch (RuntimeException re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
        return holder;
    }

    private long extractLongKey(K key) {
        return HashUtils.intHashToLong((int)key.hashCode());
    }

    public boolean containsKey(K key) throws StoreAccessException {
        try {
            return this.getInternal(key) != null;
        }
        catch (TimeoutException e) {
            return false;
        }
    }

    public Store.PutStatus put(K key, V value) throws StoreAccessException {
        this.putObserver.begin();
        Store.PutStatus status = this.silentPut(key, value);
        switch (status) {
            case PUT: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.PUT);
                break;
            }
            case NOOP: {
                this.putObserver.end((Enum)StoreOperationOutcomes.PutOutcome.NOOP);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid put status: " + status));
            }
        }
        return status;
    }

    private Store.PutStatus silentPut(K key, V value) throws StoreAccessException {
        try {
            PutOperation<K, V> operation = new PutOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            this.storeProxy.append(extractedKey, payload);
            return Store.PutStatus.PUT;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ValueHolder<V> putIfAbsent(K key, V value) throws StoreAccessException {
        this.putIfAbsentObserver.begin();
        try {
            Result<K, V> result;
            PutIfAbsentOperation<K, V> operation = new PutIfAbsentOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            if (resolvedChain.getCompactionCount() > this.chainCompactionLimit) {
                Chain compactedChain = resolvedChain.getCompactedChain();
                this.storeProxy.replaceAtHead(extractedKey, chain, compactedChain);
            }
            if ((result = resolvedChain.getResolvedResult(key)) == null) {
                this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.PUT);
                return null;
            }
            this.putIfAbsentObserver.end((Enum)StoreOperationOutcomes.PutIfAbsentOutcome.HIT);
            return new ClusteredValueHolder<V>(result.getValue());
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public boolean remove(K key) throws StoreAccessException {
        this.removeObserver.begin();
        if (this.silentRemove(key)) {
            this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.REMOVED);
            return true;
        }
        this.removeObserver.end((Enum)StoreOperationOutcomes.RemoveOutcome.MISS);
        return false;
    }

    private boolean silentRemove(K key) throws StoreAccessException {
        try {
            RemoveOperation operation = new RemoveOperation(key, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            if (resolvedChain.getResolvedResult(key) != null) {
                this.storeProxy.replaceAtHead(extractedKey, chain, resolvedChain.getCompactedChain());
                return true;
            }
            return false;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.RemoveStatus remove(K key, V value) throws StoreAccessException {
        this.conditionalRemoveObserver.begin();
        try {
            ConditionalRemoveOperation<K, V> operation = new ConditionalRemoveOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            Result<K, V> result = resolvedChain.getResolvedResult(key);
            if (result != null) {
                if (value.equals(result.getValue())) {
                    this.storeProxy.replaceAtHead(extractedKey, chain, resolvedChain.getCompactedChain());
                    this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.REMOVED);
                    return Store.RemoveStatus.REMOVED;
                }
                this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
                return Store.RemoveStatus.KEY_PRESENT;
            }
            this.conditionalRemoveObserver.end((Enum)StoreOperationOutcomes.ConditionalRemoveOutcome.MISS);
            return Store.RemoveStatus.KEY_MISSING;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ValueHolder<V> replace(K key, V value) throws StoreAccessException {
        this.replaceObserver.begin();
        try {
            Result<K, V> result;
            ReplaceOperation<K, V> operation = new ReplaceOperation<K, V>(key, value, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            if (resolvedChain.getCompactionCount() > this.chainCompactionLimit) {
                Chain compactedChain = resolvedChain.getCompactedChain();
                this.storeProxy.replaceAtHead(extractedKey, chain, compactedChain);
            }
            if ((result = resolvedChain.getResolvedResult(key)) == null) {
                this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.MISS);
                return null;
            }
            this.replaceObserver.end((Enum)StoreOperationOutcomes.ReplaceOutcome.REPLACED);
            return new ClusteredValueHolder<V>(result.getValue());
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public Store.ReplaceStatus replace(K key, V oldValue, V newValue) throws StoreAccessException {
        this.conditionalReplaceObserver.begin();
        try {
            Result<K, V> result;
            ConditionalReplaceOperation<K, V> operation = new ConditionalReplaceOperation<K, V>(key, oldValue, newValue, this.timeSource.getTimeMillis());
            ByteBuffer payload = this.codec.encode(operation);
            long extractedKey = this.extractLongKey(key);
            Chain chain = this.storeProxy.getAndAppend(extractedKey, payload);
            ResolvedChain<K, V> resolvedChain = this.resolver.resolve(chain, key, this.timeSource.getTimeMillis());
            if (resolvedChain.getCompactionCount() > this.chainCompactionLimit) {
                Chain compactedChain = resolvedChain.getCompactedChain();
                this.storeProxy.replaceAtHead(extractedKey, chain, compactedChain);
            }
            if ((result = resolvedChain.getResolvedResult(key)) != null) {
                if (oldValue.equals(result.getValue())) {
                    this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.REPLACED);
                    return Store.ReplaceStatus.HIT;
                }
                this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
                return Store.ReplaceStatus.MISS_PRESENT;
            }
            this.conditionalReplaceObserver.end((Enum)StoreOperationOutcomes.ConditionalReplaceOutcome.MISS);
            return Store.ReplaceStatus.MISS_NOT_PRESENT;
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public void clear() throws StoreAccessException {
        try {
            this.storeProxy.clear();
        }
        catch (Exception re) {
            throw StorePassThroughException.handleException((Exception)re);
        }
    }

    public StoreEventSource<K, V> getStoreEventSource() {
        return new NullStoreEventDispatcher();
    }

    public Store.Iterator<Cache.Entry<K, Store.ValueHolder<V>>> iterator() {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> compute(K key, BiFunction<? super K, ? super V, ? extends V> mappingFunction, Supplier<Boolean> replaceEqual) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Store.ValueHolder<V> computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction) throws StoreAccessException {
        HashMap valueHolderMap = new HashMap();
        if (remappingFunction instanceof Ehcache.PutAllFunction) {
            Ehcache.PutAllFunction putAllFunction = (Ehcache.PutAllFunction)remappingFunction;
            Map entriesToRemap = putAllFunction.getEntriesToRemap();
            for (Map.Entry entry : entriesToRemap.entrySet()) {
                Store.PutStatus putStatus = this.silentPut(entry.getKey(), entry.getValue());
                if (putStatus != Store.PutStatus.PUT) continue;
                putAllFunction.getActualPutCount().incrementAndGet();
                valueHolderMap.put(entry.getKey(), new ClusteredValueHolder(entry.getValue()));
            }
        } else if (remappingFunction instanceof Ehcache.RemoveAllFunction) {
            Ehcache.RemoveAllFunction removeAllFunction = (Ehcache.RemoveAllFunction)remappingFunction;
            for (K key : keys) {
                boolean removed = this.silentRemove(key);
                if (!removed) continue;
                removeAllFunction.getActualRemoveCount().incrementAndGet();
            }
        } else {
            throw new UnsupportedOperationException("This compute method is not yet capable of handling generic computation functions");
        }
        return valueHolderMap;
    }

    public Map<K, Store.ValueHolder<V>> bulkCompute(Set<? extends K> keys, Function<Iterable<? extends Map.Entry<? extends K, ? extends V>>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> remappingFunction, Supplier<Boolean> replaceEqual) {
        throw new UnsupportedOperationException("Implement me");
    }

    public Map<K, Store.ValueHolder<V>> bulkComputeIfAbsent(Set<? extends K> keys, Function<Iterable<? extends K>, Iterable<? extends Map.Entry<? extends K, ? extends V>>> mappingFunction) throws StoreAccessException {
        if (mappingFunction instanceof Ehcache.GetAllFunction) {
            HashMap<K, Store.ValueHolder<V>> map = new HashMap<K, Store.ValueHolder<V>>();
            for (K key : keys) {
                Store.ValueHolder<V> value;
                try {
                    value = this.getInternal(key);
                }
                catch (TimeoutException e) {
                    value = null;
                }
                map.put(key, value);
            }
            return map;
        }
        throw new UnsupportedOperationException("This compute method is not yet capable of handling generic computation functions");
    }

    public List<CacheConfigurationChangeListener> getConfigurationChangeListeners() {
        return Collections.emptyList();
    }

    public Store.ValueHolder<V> getAndFault(K key) throws StoreAccessException {
        Store.ValueHolder<V> value;
        this.getAndFaultObserver.begin();
        try {
            value = this.getInternal(key);
        }
        catch (TimeoutException e) {
            this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.TIMEOUT);
            return null;
        }
        if (value == null) {
            this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.MISS);
            return null;
        }
        this.getAndFaultObserver.end((Enum)AuthoritativeTierOperationOutcomes.GetAndFaultOutcome.HIT);
        return value;
    }

    public Store.ValueHolder<V> computeIfAbsentAndFault(K key, Function<? super K, ? extends V> mappingFunction) throws StoreAccessException {
        return this.computeIfAbsent(key, mappingFunction);
    }

    public boolean flush(K key, Store.ValueHolder<V> valueHolder) {
        return true;
    }

    public void setInvalidationValve(AuthoritativeTier.InvalidationValve valve) {
        this.invalidationValve = valve;
    }

    private static class StoreConfig {
        private final ClusteringService.ClusteredCacheIdentifier cacheIdentifier;
        private final Store.Configuration<?, ?> storeConfig;
        private final Consistency consistency;

        StoreConfig(ClusteringService.ClusteredCacheIdentifier cacheIdentifier, Store.Configuration<?, ?> storeConfig, Consistency consistency) {
            this.cacheIdentifier = cacheIdentifier;
            this.storeConfig = storeConfig;
            this.consistency = consistency;
        }

        public Store.Configuration<?, ?> getStoreConfig() {
            return this.storeConfig;
        }

        public ClusteringService.ClusteredCacheIdentifier getCacheIdentifier() {
            return this.cacheIdentifier;
        }

        public Consistency getConsistency() {
            return this.consistency;
        }
    }

    @ServiceDependencies(value={TimeSourceService.class, ClusteringService.class})
    public static class Provider
    implements Store.Provider,
    AuthoritativeTier.Provider {
        private static final Logger LOGGER = LoggerFactory.getLogger(Provider.class);
        private static final Set<ResourceType<?>> CLUSTER_RESOURCES;
        private volatile ServiceProvider<Service> serviceProvider;
        private volatile ClusteringService clusteringService;
        private volatile ExecutionService executionService;
        private final Lock connectLock = new ReentrantLock();
        private final Map<Store<?, ?>, StoreConfig> createdStores = new ConcurrentWeakIdentityHashMap();
        private final Map<ClusteredStore<?, ?>, Collection<MappedOperationStatistic<?, ?>>> tierOperationStatistics = new ConcurrentWeakIdentityHashMap();

        public <K, V> ClusteredStore<K, V> createStore(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            ClusteredStore<K, V> store = this.createStoreInternal(storeConfig, serviceConfigs);
            ArrayList<MappedOperationStatistic> tieredOps = new ArrayList<MappedOperationStatistic>();
            MappedOperationStatistic get = new MappedOperationStatistic(store, TierOperationOutcomes.GET_TRANSLATION, "get", TIER_HEIGHT, "get", ClusteredStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)get).withParent(store);
            tieredOps.add(get);
            MappedOperationStatistic evict = new MappedOperationStatistic(store, TierOperationOutcomes.EVICTION_TRANSLATION, "eviction", TIER_HEIGHT, "eviction", ClusteredStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)evict).withParent(store);
            tieredOps.add(evict);
            this.tierOperationStatistics.put(store, tieredOps);
            return store;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <K, V> ClusteredStore<K, V> createStoreInternal(Store.Configuration<K, V> storeConfig, Object[] serviceConfigs) {
            this.connectLock.lock();
            try {
                DefaultCacheLoaderWriterConfiguration loaderWriterConfiguration = (DefaultCacheLoaderWriterConfiguration)ServiceUtils.findSingletonAmongst(DefaultCacheLoaderWriterConfiguration.class, (Object[])serviceConfigs);
                if (loaderWriterConfiguration != null) {
                    throw new IllegalStateException("CacheLoaderWriter is not supported with clustered tiers");
                }
                CacheEventListenerConfiguration eventListenerConfiguration = (CacheEventListenerConfiguration)ServiceUtils.findSingletonAmongst(CacheEventListenerConfiguration.class, (Object[])serviceConfigs);
                if (eventListenerConfiguration != null) {
                    throw new IllegalStateException("CacheEventListener is not supported with clustered tiers");
                }
                if (this.clusteringService == null) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteringServiceConfiguration");
                }
                HashSet clusteredResourceTypes = new HashSet(storeConfig.getResourcePools().getResourceTypeSet());
                clusteredResourceTypes.retainAll(CLUSTER_RESOURCES);
                if (clusteredResourceTypes.isEmpty()) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore called without ClusteredResourcePools");
                }
                if (clusteredResourceTypes.size() != 1) {
                    throw new IllegalStateException(Provider.class.getCanonicalName() + ".createStore can not create clustered tier with multiple clustered resources");
                }
                ClusteredStoreConfiguration clusteredStoreConfiguration = (ClusteredStoreConfiguration)ServiceUtils.findSingletonAmongst(ClusteredStoreConfiguration.class, (Object[])serviceConfigs);
                if (clusteredStoreConfiguration == null) {
                    clusteredStoreConfiguration = new ClusteredStoreConfiguration();
                }
                ClusteringService.ClusteredCacheIdentifier cacheId = (ClusteringService.ClusteredCacheIdentifier)ServiceUtils.findSingletonAmongst(ClusteringService.ClusteredCacheIdentifier.class, (Object[])serviceConfigs);
                TimeSource timeSource = ((TimeSourceService)this.serviceProvider.getService(TimeSourceService.class)).getTimeSource();
                OperationsCodec codec = new OperationsCodec(storeConfig.getKeySerializer(), storeConfig.getValueSerializer());
                ExpiryPolicy expiry = storeConfig.getExpiry();
                ChainResolver resolver = ExpiryPolicyBuilder.noExpiration().equals(expiry) ? new EternalChainResolver(codec) : new ExpiryChainResolver(codec, expiry);
                ClusteredStore store = new ClusteredStore(codec, resolver, timeSource);
                this.createdStores.put((Store<?, ?>)store, new StoreConfig(cacheId, storeConfig, clusteredStoreConfiguration.getConsistency()));
                ClusteredStore clusteredStore = store;
                return clusteredStore;
            }
            finally {
                this.connectLock.unlock();
            }
        }

        public void releaseStore(Store<?, ?> resource) {
            this.connectLock.lock();
            try {
                if (this.createdStores.remove(resource) == null) {
                    throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
                }
                ClusteredStore clusteredStore = (ClusteredStore)resource;
                this.clusteringService.releaseServerStoreProxy(clusteredStore.storeProxy, false);
                StatisticsManager.nodeFor((Object)clusteredStore).clean();
                this.tierOperationStatistics.remove(clusteredStore);
            }
            finally {
                this.connectLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initStore(Store<?, ?> resource) {
            block11: {
                this.connectLock.lock();
                try {
                    StateRepository stateRepository;
                    Serializer valueSerializer;
                    StoreConfig storeConfig = this.createdStores.get(resource);
                    if (storeConfig == null) {
                        throw new IllegalArgumentException("Given clustered tier is not managed by this provider : " + resource);
                    }
                    final ClusteredStore clusteredStore = (ClusteredStore)resource;
                    ClusteringService.ClusteredCacheIdentifier cacheIdentifier = storeConfig.getCacheIdentifier();
                    try {
                        ServerStoreProxy storeProxy = this.clusteringService.getServerStoreProxy(cacheIdentifier, storeConfig.getStoreConfig(), storeConfig.getConsistency(), new ServerStoreProxy.ServerCallback(){

                            @Override
                            public void onInvalidateHash(long hash) {
                                StoreOperationOutcomes.EvictionOutcome result = StoreOperationOutcomes.EvictionOutcome.SUCCESS;
                                clusteredStore.evictionObserver.begin();
                                if (clusteredStore.invalidationValve != null) {
                                    try {
                                        LOGGER.debug("CLIENT: calling invalidation valve for hash {}", (Object)hash);
                                        clusteredStore.invalidationValve.invalidateAllWithHash(hash);
                                    }
                                    catch (StoreAccessException sae) {
                                        LOGGER.error("Error invalidating hash {}", (Object)hash, (Object)sae);
                                        result = StoreOperationOutcomes.EvictionOutcome.FAILURE;
                                    }
                                }
                                clusteredStore.evictionObserver.end((Enum)result);
                            }

                            @Override
                            public void onInvalidateAll() {
                                if (clusteredStore.invalidationValve != null) {
                                    try {
                                        LOGGER.debug("CLIENT: calling invalidation valve for all");
                                        clusteredStore.invalidationValve.invalidateAll();
                                    }
                                    catch (StoreAccessException sae) {
                                        LOGGER.error("Error invalidating all", (Throwable)sae);
                                    }
                                }
                            }

                            @Override
                            public Chain compact(Chain chain) {
                                return clusteredStore.resolver.applyOperation(chain, clusteredStore.timeSource.getTimeMillis());
                            }
                        });
                        ReconnectingServerStoreProxy reconnectingServerStoreProxy = new ReconnectingServerStoreProxy(storeProxy, () -> {
                            Runnable reconnectTask = () -> {
                                this.connectLock.lock();
                                try {
                                    String cacheId = cacheIdentifier.getId();
                                    LOGGER.info("Cache {} got disconnected from cluster, reconnecting", (Object)cacheId);
                                    this.clusteringService.releaseServerStoreProxy(clusteredStore.storeProxy, true);
                                    this.initStore((Store<?, ?>)clusteredStore);
                                    LOGGER.info("Cache {} got reconnected to cluster", (Object)cacheId);
                                }
                                finally {
                                    this.connectLock.unlock();
                                }
                            };
                            CompletableFuture.runAsync(reconnectTask, this.executionService.getUnorderedExecutor(null, new LinkedBlockingQueue()));
                        });
                        clusteredStore.storeProxy = reconnectingServerStoreProxy;
                    }
                    catch (CachePersistenceException e) {
                        throw new RuntimeException("Unable to create cluster tier proxy - " + cacheIdentifier, e);
                    }
                    Serializer keySerializer = clusteredStore.codec.getKeySerializer();
                    if (keySerializer instanceof StatefulSerializer) {
                        StateRepository stateRepository2;
                        try {
                            stateRepository2 = this.clusteringService.getStateRepositoryWithin(cacheIdentifier, cacheIdentifier.getId() + "-Key");
                        }
                        catch (CachePersistenceException e) {
                            throw new RuntimeException(e);
                        }
                        ((StatefulSerializer)keySerializer).init(stateRepository2);
                    }
                    if (!((valueSerializer = clusteredStore.codec.getValueSerializer()) instanceof StatefulSerializer)) break block11;
                    try {
                        stateRepository = this.clusteringService.getStateRepositoryWithin(cacheIdentifier, cacheIdentifier.getId() + "-Value");
                    }
                    catch (CachePersistenceException e) {
                        throw new RuntimeException(e);
                    }
                    ((StatefulSerializer)valueSerializer).init(stateRepository);
                }
                finally {
                    this.connectLock.unlock();
                }
            }
        }

        public int rank(Set<ResourceType<?>> resourceTypes, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (this.clusteringService == null || resourceTypes.size() > 1 || Collections.disjoint(resourceTypes, CLUSTER_RESOURCES)) {
                return 0;
            }
            return 1;
        }

        public int rankAuthority(ResourceType<?> authorityResource, Collection<ServiceConfiguration<?>> serviceConfigs) {
            if (this.clusteringService == null) {
                return 0;
            }
            return CLUSTER_RESOURCES.contains(authorityResource) ? 1 : 0;
        }

        public void start(ServiceProvider<Service> serviceProvider) {
            this.connectLock.lock();
            try {
                this.serviceProvider = serviceProvider;
                this.clusteringService = (ClusteringService)this.serviceProvider.getService(ClusteringService.class);
                this.executionService = (ExecutionService)this.serviceProvider.getService(ExecutionService.class);
            }
            finally {
                this.connectLock.unlock();
            }
        }

        public void stop() {
            this.connectLock.lock();
            try {
                this.serviceProvider = null;
                this.createdStores.clear();
            }
            finally {
                this.connectLock.unlock();
            }
        }

        public <K, V> AuthoritativeTier<K, V> createAuthoritativeTier(Store.Configuration<K, V> storeConfig, ServiceConfiguration<?> ... serviceConfigs) {
            ClusteredStore<K, V> authoritativeTier = this.createStoreInternal(storeConfig, serviceConfigs);
            ArrayList<MappedOperationStatistic> tieredOps = new ArrayList<MappedOperationStatistic>();
            MappedOperationStatistic get = new MappedOperationStatistic(authoritativeTier, TierOperationOutcomes.GET_AND_FAULT_TRANSLATION, "get", TIER_HEIGHT, "getAndFault", ClusteredStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)get).withParent(authoritativeTier);
            tieredOps.add(get);
            MappedOperationStatistic evict = new MappedOperationStatistic(authoritativeTier, TierOperationOutcomes.EVICTION_TRANSLATION, "eviction", TIER_HEIGHT, "eviction", ClusteredStore.STATISTICS_TAG);
            StatisticsManager.associate((Object)evict).withParent(authoritativeTier);
            tieredOps.add(evict);
            this.tierOperationStatistics.put(authoritativeTier, tieredOps);
            return authoritativeTier;
        }

        public void releaseAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.releaseStore((Store<?, ?>)resource);
        }

        public void initAuthoritativeTier(AuthoritativeTier<?, ?> resource) {
            this.initStore((Store<?, ?>)resource);
        }

        static {
            HashSet resourceTypes = new HashSet();
            Collections.addAll(resourceTypes, ClusteredResourceType.Types.values());
            CLUSTER_RESOURCES = Collections.unmodifiableSet(resourceTypes);
        }
    }
}

