/*
 * Decompiled with CFR 0.152.
 */
package com.tc.net.protocol.delivery;

import com.tc.net.protocol.delivery.OnceAndOnlyOnceProtocolNetworkLayer;
import com.tc.net.protocol.transport.ClientConnectionEstablisher;
import com.tc.net.protocol.transport.ClientMessageTransport;
import com.tc.net.protocol.transport.MessageTransport;
import com.tc.net.protocol.transport.MessageTransportListener;
import com.tc.net.protocol.transport.RestoreConnectionCallback;
import com.tc.util.DebugUtil;

public class OOOConnectionWatcher
implements RestoreConnectionCallback,
MessageTransportListener {
    private static final boolean debug = Boolean.getBoolean("ooo.logging.enabled");
    protected final ClientMessageTransport cmt;
    protected final ClientConnectionEstablisher cce;
    private final OnceAndOnlyOnceProtocolNetworkLayer oooLayer;
    private final long timeoutMillis;

    public OOOConnectionWatcher(ClientMessageTransport cmt, ClientConnectionEstablisher cce, OnceAndOnlyOnceProtocolNetworkLayer oooLayer, long timeoutMillis) {
        this.cmt = cmt;
        this.cce = cce;
        this.oooLayer = oooLayer;
        this.timeoutMillis = timeoutMillis;
    }

    @Override
    public void notifyTransportDisconnected(MessageTransport transport, boolean forcedDisconnect) {
        this.oooLayer.startRestoringConnection();
        this.oooLayer.notifyTransportDisconnected(transport, forcedDisconnect);
        if (!forcedDisconnect) {
            OOOConnectionWatcher.log(transport, "Transport Disconnected, calling asyncRestoreConnection for " + this.timeoutMillis);
            this.cce.asyncRestoreConnection(this.cmt, transport.getRemoteAddress(), this, this.timeoutMillis);
        } else {
            OOOConnectionWatcher.log(transport, "Transport FORCE Disconnect. Skipping asyncRestoreConnection.");
            this.restoreConnectionFailed(transport);
        }
    }

    @Override
    public void notifyTransportConnected(MessageTransport transport) {
        OOOConnectionWatcher.log(transport, "Transport Connected");
        this.oooLayer.notifyTransportConnected(transport);
    }

    @Override
    public void restoreConnectionFailed(MessageTransport transport) {
        OOOConnectionWatcher.log(transport, "Restore Connection Failed");
        this.oooLayer.connectionRestoreFailed();
        this.cce.asyncReconnect(this.cmt);
        this.oooLayer.notifyTransportDisconnected(transport, false);
    }

    @Override
    public void notifyTransportClosed(MessageTransport transport) {
        this.cce.quitReconnectAttempts();
        this.oooLayer.notifyTransportClosed(transport);
    }

    @Override
    public void notifyTransportConnectAttempt(MessageTransport transport) {
        this.oooLayer.notifyTransportConnectAttempt(transport);
    }

    @Override
    public void notifyTransportReconnectionRejected(MessageTransport transport) {
        OOOConnectionWatcher.log(transport, "Reconnection Rejected");
        this.oooLayer.connectionRestoreFailed();
        this.oooLayer.notifyTransportReconnectionRejected(transport);
    }

    private static void log(MessageTransport transport, String msg) {
        if (debug) {
            DebugUtil.trace("OOOConnectionWatcher-CLIENT-" + transport.getConnectionID() + " -> " + msg);
        }
    }
}

