/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object.handshakemanager;

import com.tc.cluster.ClusterInternalEventsGun;
import com.tc.net.ClientID;
import com.tc.object.handshakemanager.ClientHandshakeCallback;
import com.tc.object.handshakemanager.ClientHandshakeManager;
import com.tc.object.msg.ClientHandshakeAckMessage;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.msg.ClientHandshakeMessageFactory;
import com.tc.object.session.SessionManager;
import com.tc.util.Assert;
import com.tc.util.Util;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientHandshakeManagerImpl
implements ClientHandshakeManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClientHandshakeManagerImpl.class);
    private final ClientHandshakeCallback callBacks;
    private final ClientHandshakeMessageFactory chmf;
    private final Logger logger;
    private final SessionManager sessionManager;
    private final String clientVersion;
    private final String uuid;
    private final String name;
    private State state;
    private volatile boolean disconnected;
    private volatile boolean isShutdown = false;
    private final ClusterInternalEventsGun clusterEventsGun;

    public ClientHandshakeManagerImpl(Logger logger, ClientHandshakeMessageFactory chmf, SessionManager sessionManager, ClusterInternalEventsGun clusterEventsGun, String uuid, String name, String clientVersion, ClientHandshakeCallback entities) {
        this.logger = logger;
        this.chmf = chmf;
        this.sessionManager = sessionManager;
        this.clusterEventsGun = clusterEventsGun;
        this.uuid = uuid;
        this.name = name;
        this.clientVersion = clientVersion;
        this.callBacks = entities;
        this.state = State.PAUSED;
        this.disconnected = true;
        this.pauseCallbacks();
    }

    @Override
    public synchronized void shutdown(boolean fromShutdownHook) {
        this.isShutdown = true;
        this.notifyAll();
        this.shutdownCallbacks(fromShutdownHook);
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.isShutdown;
    }

    private boolean checkShutdown() {
        if (this.isShutdown) {
            this.logger.info("Drop handshaking due to client shutting down...");
        }
        return this.isShutdown;
    }

    private void initiateHandshake() {
        this.logger.debug("Initiating handshake...");
        this.changeToStarting();
        ClientHandshakeMessage handshakeMessage = this.chmf.newClientHandshakeMessage(this.uuid, this.name, this.clientVersion);
        this.notifyCallbackOnHandshake(handshakeMessage);
        this.logger.debug("Sending handshake message");
        if (!handshakeMessage.send()) {
            if (handshakeMessage.getChannel().isConnected()) {
                LOGGER.error("handshake not sent but channel is connected", (Throwable)new Exception("FATAL HANDSHAKE ERROR"));
            } else {
                LOGGER.info("handshake failed. channel not connected");
            }
        }
    }

    @Override
    public void fireNodeError() {
        String msg = "Reconnection was rejected from server. This client will never be able to join the cluster again.";
        this.logger.error("Reconnection was rejected from server. This client will never be able to join the cluster again.");
        LOGGER.error("Reconnection was rejected from server. This client will never be able to join the cluster again.");
        this.clusterEventsGun.fireNodeError();
    }

    @Override
    public synchronized void disconnected() {
        boolean wasRunning;
        if (!this.checkShutdown() && (wasRunning = this.changeToPaused())) {
            this.notifyAll();
            this.pauseCallbacks();
            this.sessionManager.newSession();
            this.logger.debug("ClientHandshakeManager moves to " + this.sessionManager.getSessionID());
        }
    }

    @Override
    public synchronized void connected() {
        this.logger.debug("Connected: Unpausing from " + (Object)((Object)this.state));
        if (this.state != State.PAUSED) {
            this.logger.warn("Ignoring unpause while " + (Object)((Object)this.state));
        } else if (!this.checkShutdown()) {
            this.initiateHandshake();
        }
    }

    @Override
    public void acknowledgeHandshake(ClientHandshakeAckMessage handshakeAck) {
        this.acknowledgeHandshake(handshakeAck.getThisNodeId(), handshakeAck.getAllNodes(), handshakeAck.getServerVersion());
    }

    protected synchronized void acknowledgeHandshake(ClientID thisNodeId, ClientID[] clusterMembers, String serverVersion) {
        this.logger.debug("Received Handshake ack");
        if (this.state != State.STARTING) {
            this.logger.warn("Ignoring handshake acknowledgement while " + (Object)((Object)this.state));
        } else {
            this.checkClientServerVersionCompatibility(serverVersion);
            this.changeToRunning();
            this.notifyAll();
            this.unpauseCallbacks();
            this.clusterEventsGun.fireThisNodeJoined(thisNodeId, clusterMembers);
        }
    }

    protected void checkClientServerVersionCompatibility(String serverVersion) {
        if (!Objects.equals(this.clientVersion, serverVersion)) {
            String message = String.format("Client version %s is different from server version %s.", this.clientVersion, serverVersion);
            this.logger.info(message);
        }
    }

    private void shutdownCallbacks(boolean fromShutdownHook) {
        this.callBacks.shutdown(fromShutdownHook);
    }

    private void pauseCallbacks() {
        this.callBacks.pause();
    }

    private void notifyCallbackOnHandshake(ClientHandshakeMessage handshakeMessage) {
        this.callBacks.initializeHandshake(handshakeMessage);
    }

    private void unpauseCallbacks() {
        this.callBacks.unpause();
    }

    @Override
    public synchronized void waitForHandshake() {
        boolean isInterrupted = false;
        try {
            while (this.disconnected && !this.isShutdown) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    this.logger.error("Interrupted while waiting for handshake");
                    isInterrupted = true;
                }
            }
        }
        finally {
            Util.selfInterruptIfNeeded(isInterrupted);
        }
    }

    private boolean changeToPaused() {
        State old = this.state;
        boolean didChangeToPaused = false;
        if (old != State.PAUSED) {
            this.state = State.PAUSED;
            this.logger.debug("Disconnected: Pausing from " + (Object)((Object)old) + ". Disconnect count: " + this.disconnected);
            if (old == State.RUNNING) {
                didChangeToPaused = true;
                this.disconnected = true;
            }
            this.clusterEventsGun.fireOperationsDisabled();
        }
        return didChangeToPaused;
    }

    private void changeToStarting() {
        Assert.assertEquals((Object)this.state, (Object)State.PAUSED);
        this.state = State.STARTING;
    }

    private void changeToRunning() {
        Assert.assertEquals((Object)this.state, (Object)State.STARTING);
        this.state = State.RUNNING;
        this.disconnected = false;
    }

    private static enum State {
        PAUSED,
        STARTING,
        RUNNING;

    }
}

