/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.clustered.client.internal.config.xml;

import java.io.IOException;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ehcache.clustered.client.config.ClusteredStoreConfiguration;
import org.ehcache.clustered.client.config.ClusteringServiceConfiguration;
import org.ehcache.clustered.client.config.Timeouts;
import org.ehcache.clustered.client.config.builders.TimeoutsBuilder;
import org.ehcache.clustered.client.internal.config.xml.ClusteredCacheConstants;
import org.ehcache.clustered.client.internal.store.ClusteredStore;
import org.ehcache.clustered.client.service.ClusteringService;
import org.ehcache.clustered.common.Consistency;
import org.ehcache.clustered.common.ServerSideConfiguration;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.spi.service.ServiceConfiguration;
import org.ehcache.spi.service.ServiceCreationConfiguration;
import org.ehcache.xml.CacheManagerServiceConfigurationParser;
import org.ehcache.xml.CacheServiceConfigurationParser;
import org.ehcache.xml.XmlModel;
import org.ehcache.xml.exceptions.XmlConfigurationException;
import org.ehcache.xml.model.TimeType;
import org.ehcache.xml.model.TimeUnit;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ClusteringServiceConfigurationParser
implements CacheManagerServiceConfigurationParser<ClusteringService>,
CacheServiceConfigurationParser<ClusteredStore.Provider> {
    public static final String CLUSTERED_STORE_ELEMENT_NAME = "clustered-store";
    public static final String CONSISTENCY_ATTRIBUTE_NAME = "consistency";

    public Source getXmlSchema() throws IOException {
        return new StreamSource(ClusteredCacheConstants.XML_SCHEMA.openStream());
    }

    public URI getNamespace() {
        return ClusteredCacheConstants.NAMESPACE;
    }

    public ServiceConfiguration<ClusteredStore.Provider> parseServiceConfiguration(Element fragment) {
        if (CLUSTERED_STORE_ELEMENT_NAME.equals(fragment.getLocalName())) {
            if (fragment.hasAttribute(CONSISTENCY_ATTRIBUTE_NAME)) {
                return new ClusteredStoreConfiguration(Consistency.valueOf(fragment.getAttribute(CONSISTENCY_ATTRIBUTE_NAME).toUpperCase()));
            }
            return new ClusteredStoreConfiguration();
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    public ServiceCreationConfiguration<ClusteringService> parseServiceCreationConfiguration(Element fragment) {
        if ("cluster".equals(fragment.getLocalName())) {
            ServerSideConfig serverConfig = null;
            URI connectionUri = null;
            ArrayList<InetSocketAddress> serverAddresses = new ArrayList<InetSocketAddress>();
            String clusterTierManager = null;
            Duration getTimeout = null;
            Duration putTimeout = null;
            Duration connectionTimeout = null;
            NodeList childNodes = fragment.getChildNodes();
            block20: for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (1 != item.getNodeType()) continue;
                switch (item.getLocalName()) {
                    case "connection": {
                        Attr urlAttribute = ((Element)item).getAttributeNode("url");
                        String urlValue = urlAttribute.getValue();
                        try {
                            connectionUri = new URI(urlValue);
                            continue block20;
                        }
                        catch (URISyntaxException e) {
                            throw new XmlConfigurationException(String.format("Value of %s attribute on XML configuration element <%s> in <%s> is not a valid URI - '%s'", urlAttribute.getName(), item.getNodeName(), fragment.getTagName(), connectionUri), (Throwable)e);
                        }
                    }
                    case "cluster-connection": {
                        clusterTierManager = ((Element)item).getAttribute("cluster-tier-manager");
                        NodeList serverNodes = item.getChildNodes();
                        for (int j = 0; j < serverNodes.getLength(); ++j) {
                            InetSocketAddress address;
                            Node serverNode = serverNodes.item(j);
                            String host = ((Element)serverNode).getAttributeNode("host").getValue();
                            Attr port = ((Element)serverNode).getAttributeNode("port");
                            if (port == null) {
                                address = InetSocketAddress.createUnresolved(host, 0);
                            } else {
                                String portString = port.getValue();
                                address = InetSocketAddress.createUnresolved(host, Integer.parseInt(portString));
                            }
                            serverAddresses.add(address);
                        }
                        continue block20;
                    }
                    case "read-timeout": {
                        getTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "write-timeout": {
                        putTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "connection-timeout": {
                        connectionTimeout = this.processTimeout(fragment, item);
                        continue block20;
                    }
                    case "server-side-config": {
                        serverConfig = this.processServerSideConfig(item);
                        continue block20;
                    }
                    default: {
                        throw new XmlConfigurationException(String.format("Unknown XML configuration element <%s> in <%s>", item.getNodeName(), fragment.getTagName()));
                    }
                }
            }
            try {
                Timeouts timeouts = this.getTimeouts(getTimeout, putTimeout, connectionTimeout);
                if (serverConfig == null) {
                    if (connectionUri != null) {
                        return new ClusteringServiceConfiguration(connectionUri, timeouts);
                    }
                    return new ClusteringServiceConfiguration(serverAddresses, clusterTierManager, timeouts);
                }
                ServerSideConfiguration serverSideConfiguration = serverConfig.defaultServerResource == null ? new ServerSideConfiguration(serverConfig.pools) : new ServerSideConfiguration(serverConfig.defaultServerResource, serverConfig.pools);
                if (connectionUri != null) {
                    return new ClusteringServiceConfiguration(connectionUri, timeouts, serverConfig.autoCreate, serverSideConfiguration);
                }
                return new ClusteringServiceConfiguration(serverAddresses, clusterTierManager, timeouts, serverConfig.autoCreate, serverSideConfiguration);
            }
            catch (IllegalArgumentException e) {
                throw new XmlConfigurationException((Throwable)e);
            }
        }
        throw new XmlConfigurationException(String.format("XML configuration element <%s> in <%s> is not supported", fragment.getTagName(), fragment.getParentNode() == null ? "null" : fragment.getParentNode().getLocalName()));
    }

    private Timeouts getTimeouts(Duration getTimeout, Duration putTimeout, Duration connectionTimeout) {
        TimeoutsBuilder builder = TimeoutsBuilder.timeouts();
        if (getTimeout != null) {
            builder.read(getTimeout);
        }
        if (putTimeout != null) {
            builder.write(putTimeout);
        }
        if (connectionTimeout != null) {
            builder.connection(connectionTimeout);
        }
        return builder.build();
    }

    private Duration processTimeout(Element parentElement, Node timeoutNode) {
        try {
            JAXBContext context = JAXBContext.newInstance((String)TimeType.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            JAXBElement jaxbElement = unmarshaller.unmarshal(timeoutNode, TimeType.class);
            TimeType timeType = (TimeType)jaxbElement.getValue();
            BigInteger amount = timeType.getValue();
            if (amount.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
                throw new XmlConfigurationException(String.format("Value of XML configuration element <%s> in <%s> exceeds allowed value - %s", timeoutNode.getNodeName(), parentElement.getTagName(), amount));
            }
            return Duration.of(amount.longValue(), XmlModel.convertToJavaTimeUnit((TimeUnit)timeType.getUnit()));
        }
        catch (JAXBException e) {
            throw new XmlConfigurationException((Throwable)e);
        }
    }

    private ServerSideConfig processServerSideConfig(Node serverSideConfigElement) {
        ServerSideConfig serverSideConfig = new ServerSideConfig();
        serverSideConfig.autoCreate = Boolean.parseBoolean(((Element)serverSideConfigElement).getAttribute("auto-create"));
        NodeList serverSideNodes = serverSideConfigElement.getChildNodes();
        for (int i = 0; i < serverSideNodes.getLength(); ++i) {
            long quantity;
            Node item = serverSideNodes.item(i);
            if (1 != item.getNodeType()) continue;
            String nodeLocalName = item.getLocalName();
            if ("default-resource".equals(nodeLocalName)) {
                serverSideConfig.defaultServerResource = ((Element)item).getAttribute("from");
                continue;
            }
            if (!"shared-pool".equals(nodeLocalName)) continue;
            Element sharedPoolElement = (Element)item;
            String poolName = sharedPoolElement.getAttribute("name");
            Attr fromAttr = sharedPoolElement.getAttributeNode("from");
            String fromResource = fromAttr == null ? null : fromAttr.getValue();
            Attr unitAttr = sharedPoolElement.getAttributeNode("unit");
            String unit = unitAttr == null ? "B" : unitAttr.getValue();
            MemoryUnit memoryUnit = MemoryUnit.valueOf((String)unit.toUpperCase(Locale.ENGLISH));
            String quantityValue = sharedPoolElement.getFirstChild().getNodeValue();
            try {
                quantity = Long.parseLong(quantityValue);
            }
            catch (NumberFormatException e) {
                throw new XmlConfigurationException("Magnitude of value specified for <shared-pool name=\"" + poolName + "\"> is too large");
            }
            ServerSideConfiguration.Pool poolDefinition = fromResource == null ? new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity)) : new ServerSideConfiguration.Pool(memoryUnit.toBytes(quantity), fromResource);
            if (serverSideConfig.pools.put(poolName, poolDefinition) == null) continue;
            throw new XmlConfigurationException("Duplicate definition for <shared-pool name=\"" + poolName + "\">");
        }
        return serverSideConfig;
    }

    private static final class ServerSideConfig {
        private boolean autoCreate = false;
        private String defaultServerResource = null;
        private final Map<String, ServerSideConfiguration.Pool> pools = new HashMap<String, ServerSideConfiguration.Pool>();

        private ServerSideConfig() {
        }
    }
}

