/*
 * Decompiled with CFR 0.152.
 */
package com.tc.object;

import com.tc.async.api.AbstractEventHandler;
import com.tc.async.api.EventHandler;
import com.tc.async.api.EventHandlerException;
import com.tc.async.api.Sink;
import com.tc.async.api.Stage;
import com.tc.async.api.StageManager;
import com.tc.entity.NetworkVoltronEntityMessage;
import com.tc.entity.ResendVoltronEntityMessage;
import com.tc.entity.VoltronEntityMessage;
import com.tc.entity.VoltronEntityMultiResponse;
import com.tc.entity.VoltronEntityResponse;
import com.tc.exception.EntityBusyException;
import com.tc.exception.EntityReferencedException;
import com.tc.exception.VoltronWrapperException;
import com.tc.logging.ClientIDLogger;
import com.tc.net.ClientID;
import com.tc.net.NodeID;
import com.tc.net.ServerID;
import com.tc.net.protocol.tcm.ClientMessageChannel;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.tcm.TCMessageType;
import com.tc.net.protocol.tcm.UnknownNameException;
import com.tc.object.ClientConfigurationContext;
import com.tc.object.ClientEntityManager;
import com.tc.object.ClientEntityStateManager;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityClientEndpointImpl;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.InFlightMessage;
import com.tc.object.InFlightMonitor;
import com.tc.object.msg.ClientEntityReferenceContext;
import com.tc.object.msg.ClientHandshakeMessage;
import com.tc.object.session.SessionID;
import com.tc.object.tx.TransactionID;
import com.tc.stats.Stats;
import com.tc.text.PrettyPrinter;
import com.tc.tracing.Trace;
import com.tc.util.Assert;
import com.tc.util.Throwables;
import com.tc.util.Util;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.entity.EntityClientEndpoint;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;
import org.terracotta.exception.ConnectionClosedException;
import org.terracotta.exception.EntityException;
import org.terracotta.exception.EntityNotFoundException;
import org.terracotta.exception.EntityServerUncaughtException;

public class ClientEntityManagerImpl
implements ClientEntityManager {
    private final Logger logger;
    private final ClientMessageChannel channel;
    private final ConcurrentMap<TransactionID, InFlightMessage> inFlightMessages;
    private final Sink<InFlightMessage> outbound;
    private final MessagePendingCount requestTickets = new MessagePendingCount();
    private final AtomicLong currentTransactionID;
    private final ClientEntityStateManager stateManager;
    private final ConcurrentMap<ClientInstanceID, EntityClientEndpointImpl<?, ?>> objectStoreMap;
    private final StageManager stages;
    private final boolean reconnectable;
    private final ExecutorService endpointCloser = Executors.newWorkStealingPool();
    private boolean wasBusy = false;

    public ClientEntityManagerImpl(ClientMessageChannel channel, StageManager mgr) {
        this.logger = new ClientIDLogger(channel, LoggerFactory.getLogger(ClientEntityManager.class));
        this.channel = channel;
        this.inFlightMessages = new ConcurrentHashMap<TransactionID, InFlightMessage>();
        this.currentTransactionID = new AtomicLong();
        this.stateManager = new ClientEntityStateManager();
        this.objectStoreMap = new ConcurrentHashMap(10240, 0.75f, 128);
        this.stages = mgr;
        this.outbound = this.createSendStage();
        this.reconnectable = channel.getProductId().isReconnectEnabled();
    }

    public boolean checkBusy() {
        try {
            boolean bl = this.wasBusy;
            return bl;
        }
        finally {
            this.wasBusy = false;
        }
    }

    private synchronized boolean enqueueMessage(InFlightMessage msg, boolean waitUntilRunning) {
        boolean enqueued = true;
        boolean interrupted = false;
        while (waitUntilRunning && !this.stateManager.isRunning() || !this.requestTickets.messagePendingSlotAvailable()) {
            try {
                if (!this.stateManager.isShutdown()) {
                    this.wait();
                    continue;
                }
                enqueued = false;
                break;
            }
            catch (InterruptedException ie) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        if (enqueued) {
            this.inFlightMessages.put(msg.getTransactionID(), msg);
            this.requestTickets.messagePending();
        }
        return enqueued;
    }

    private Sink<InFlightMessage> createSendStage() {
        AbstractEventHandler<InFlightMessage> handler = new AbstractEventHandler<InFlightMessage>(){

            @Override
            public void handleEvent(InFlightMessage first) throws EventHandlerException {
                if (ClientEntityManagerImpl.this.enqueueMessage(first, first.getMessage().getVoltronType() != VoltronEntityMessage.Type.INVOKE_ACTION)) {
                    first.sent();
                    if (first.send()) {
                        if (first.getMessage().getVoltronType() != VoltronEntityMessage.Type.INVOKE_ACTION) {
                            first.waitForAcks();
                        }
                    } else {
                        ClientEntityManagerImpl.this.logger.debug("message not sent.  Make sure resend happens " + first);
                    }
                } else {
                    ClientEntityManagerImpl.this.throwClosedExceptionOnMessage(first, "Connection closed before sending message");
                }
            }
        };
        return this.makeDirectSink(handler);
    }

    private <T> Sink<T> makeDirectSink(final EventHandler<T> handler) {
        return new Sink<T>(){

            @Override
            public void addSingleThreaded(T context) {
                try {
                    handler.handleEvent(context);
                }
                catch (EventHandlerException ee) {
                    throw new RuntimeException(ee);
                }
            }

            @Override
            public void addMultiThreaded(T context) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public void clear() {
            }

            @Override
            public void close() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void enableStatsCollection(boolean enable) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public boolean isStatsCollectionEnabled() {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Stats getStats(long frequency) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public Stats getStatsAndReset(long frequency) {
                throw new UnsupportedOperationException("Not supported yet.");
            }

            @Override
            public void resetStats() {
                throw new UnsupportedOperationException("Not supported yet.");
            }
        };
    }

    @Override
    public EntityClientEndpoint fetchEntity(EntityID entity, long version, ClientInstanceID instance, MessageCodec<? extends EntityMessage, ? extends EntityResponse> codec, Runnable closeHook) throws EntityException {
        return this.internalLookup(entity, version, instance, codec, closeHook);
    }

    @Override
    public void handleMessage(TransactionID tid, byte[] message) {
        InFlightMessage msg = (InFlightMessage)this.inFlightMessages.get(tid);
        if (msg != null) {
            msg.handleMessage(message);
        } else {
            Assert.fail("transaction " + tid + " not found. Ignoring message.");
        }
    }

    @Override
    public void handleMessage(ClientInstanceID clientInstance, byte[] message) {
        EntityClientEndpoint endpoint = (EntityClientEndpoint)this.objectStoreMap.get(clientInstance);
        if (endpoint != null) {
            this.deliverInboundMessage(endpoint, message);
        } else {
            this.logger.info("Instance " + clientInstance + " not found. Ignoring message.");
        }
    }

    private void deliverInboundMessage(EntityClientEndpoint endpoint, byte[] msg) {
        EntityClientEndpointImpl endpointImpl = (EntityClientEndpointImpl)endpoint;
        try {
            endpointImpl.handleMessage(msg);
        }
        catch (MessageCodecException e) {
            Assert.fail(e.getLocalizedMessage());
        }
    }

    @Override
    public byte[] createEntity(EntityID entityID, long version, byte[] config) throws EntityException {
        boolean requiresReplication = true;
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, config, VoltronEntityMessage.Type.CREATE_ENTITY, this.lifecycleAcks());
        return this.sendMessageWhileBusy(message, this.lifecycleAcks(), "ClientEntityManagerImpl.createEntity");
    }

    @Override
    public byte[] reconfigureEntity(EntityID entityID, long version, byte[] config) throws EntityException {
        boolean requiresReplication = true;
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, config, VoltronEntityMessage.Type.RECONFIGURE_ENTITY, this.lifecycleAcks());
        return this.sendMessageWhileBusy(message, this.lifecycleAcks(), "ClientEntityManagerImpl.reconfigureEntity");
    }

    private Set<VoltronEntityMessage.Acks> lifecycleAcks() {
        return Collections.singleton(VoltronEntityMessage.Acks.RETIRED);
    }

    @Override
    public boolean destroyEntity(EntityID entityID, long version) throws EntityException {
        boolean requiresReplication = true;
        byte[] emtpyExtendedData = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithoutClientInstance(entityID, version, requiresReplication, emtpyExtendedData, VoltronEntityMessage.Type.DESTROY_ENTITY, this.lifecycleAcks());
        try {
            this.sendMessageWhileBusy(message, this.lifecycleAcks(), "ClientEntityManagerImpl.destroyEntity");
        }
        catch (EntityReferencedException r) {
            return false;
        }
        return true;
    }

    @Override
    public InFlightMessage invokeActionWithTimeout(EntityID eid, EntityDescriptor entityDescriptor, Set<VoltronEntityMessage.Acks> acks, InFlightMonitor monitor, boolean requiresReplication, boolean shouldBlockGetOnRetire, boolean deferred, long invokeTimeout, TimeUnit units, byte[] payload) throws InterruptedException, TimeoutException {
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(eid, entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.INVOKE_ACTION, acks);
        Trace trace = Trace.newTrace(message, "ClientEntityManagerImpl.invokeAction");
        trace.start();
        InFlightMessage inFlightMessage = this.queueInFlightMessage(message, acks, monitor, shouldBlockGetOnRetire, deferred);
        inFlightMessage.waitForAcks(invokeTimeout, units);
        trace.end();
        return inFlightMessage;
    }

    @Override
    public InFlightMessage invokeAction(EntityID eid, EntityDescriptor entityDescriptor, Set<VoltronEntityMessage.Acks> requestedAcks, InFlightMonitor monitor, boolean requiresReplication, boolean shouldBlockGetOnRetire, boolean deferred, byte[] payload) {
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(eid, entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.INVOKE_ACTION, requestedAcks);
        Trace trace = Trace.newTrace(message, "ClientEntityManagerImpl.invokeAction");
        trace.start();
        InFlightMessage inFlightMessage = this.queueInFlightMessage(message, requestedAcks, monitor, shouldBlockGetOnRetire, deferred);
        inFlightMessage.waitForAcks();
        trace.end();
        return inFlightMessage;
    }

    @Override
    public synchronized PrettyPrinter prettyPrint(PrettyPrinter out) {
        return out;
    }

    @Override
    public void received(TransactionID id) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.received();
        }
    }

    @Override
    public void complete(TransactionID id) {
        this.complete(id, null);
    }

    @Override
    public void complete(TransactionID id, byte[] value) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.setResult(value, null);
        }
    }

    @Override
    public void failed(TransactionID id, EntityException error) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.get(id);
        if (inFlight != null) {
            inFlight.setResult(null, error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void retired(TransactionID id) {
        InFlightMessage inFlight = (InFlightMessage)this.inFlightMessages.remove(id);
        if (inFlight != null) {
            inFlight.retired();
            ClientEntityManagerImpl clientEntityManagerImpl = this;
            synchronized (clientEntityManagerImpl) {
                this.requestTickets.messageRetired();
                this.notify();
            }
        }
    }

    @Override
    public synchronized void pause() {
        this.stateManager.pause();
    }

    @Override
    public synchronized void unpause() {
        this.stateManager.running();
        this.notifyAll();
    }

    @Override
    public synchronized void initializeHandshake(ClientHandshakeMessage handshakeMessage) {
        for (EntityClientEndpointImpl endpoint : this.objectStoreMap.values()) {
            EntityDescriptor descriptor = endpoint.getEntityDescriptor();
            EntityID entityID = endpoint.getEntityID();
            long entityVersion = endpoint.getVersion();
            byte[] extendedReconnectData = endpoint.getExtendedReconnectData();
            ClientEntityReferenceContext context = new ClientEntityReferenceContext(entityID, entityVersion, descriptor.getClientInstanceID(), extendedReconnectData);
            handshakeMessage.addReconnectReference(context);
        }
        Stage<VoltronEntityResponse> responder = this.stages.getStage("request_ack_stage", VoltronEntityResponse.class);
        Stage<VoltronEntityMultiResponse> responderMulti = this.stages.getStage("multi_request_ack_stage", VoltronEntityMultiResponse.class);
        FlushResponse flush = new FlushResponse();
        responder.getSink().addSingleThreaded(flush);
        flush.waitForAccess();
        flush = new FlushResponse();
        responderMulti.getSink().addSingleThreaded(flush);
        flush.waitForAccess();
        for (InFlightMessage inFlight : this.inFlightMessages.values()) {
            VoltronEntityMessage message = inFlight.getMessage();
            ResendVoltronEntityMessage packaged = new ResendVoltronEntityMessage(message.getSource(), message.getTransactionID(), message.getEntityDescriptor(), message.getVoltronType(), message.doesRequireReplication(), message.getExtendedData(), message.getOldestTransactionOnClient());
            handshakeMessage.addResendMessage(packaged);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean fromShutdownHook) {
        Iterator iterator = this;
        synchronized (iterator) {
            if (this.stateManager.isShutdown()) {
                return;
            }
            this.requestTickets.stop();
            this.stateManager.stop();
            this.notifyAll();
        }
        for (InFlightMessage msg : this.inFlightMessages.values()) {
            this.throwClosedExceptionOnMessage(msg, "Connection closed under in-flight message");
        }
        for (EntityClientEndpointImpl endpoint : this.objectStoreMap.values()) {
            try {
                endpoint.didCloseUnexpectedly();
            }
            catch (Throwable t) {
                this.logger.error("error in shutdown", t);
            }
        }
        this.endpointCloser.shutdownNow();
        this.objectStoreMap.clear();
    }

    private void throwClosedExceptionOnMessage(InFlightMessage msg, String description) {
        msg.received();
        msg.setResult(null, new VoltronWrapperException(new ConnectionClosedException(description)));
        msg.retired();
    }

    private <M extends EntityMessage, R extends EntityResponse> EntityClientEndpoint<M, R> internalLookup(final EntityID entity, long version, ClientInstanceID instance, MessageCodec<M, R> codec, final Runnable closeHook) throws EntityException {
        Assert.assertNotNull("Can't lookup null entity descriptor", instance);
        final EntityDescriptor fetchDescriptor = EntityDescriptor.createDescriptorForFetch(entity, version, instance);
        EntityClientEndpointImpl<M, R> resolvedEndpoint = null;
        try {
            byte[] raw = this.internalRetrieve(fetchDescriptor);
            ByteBuffer br = ByteBuffer.wrap(raw);
            long fetchID = br.getLong();
            FetchID fetch = new FetchID(fetchID);
            byte[] config = new byte[br.remaining()];
            br.get(config);
            Assert.assertTrue(null != raw);
            Runnable compoundRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientEntityManagerImpl.this.internalRelease(entity, fetchDescriptor, closeHook);
                    }
                    catch (EntityException e) {
                        Util.printLogAndRethrowError(e, ClientEntityManagerImpl.this.logger);
                    }
                }
            };
            resolvedEndpoint = new EntityClientEndpointImpl<M, R>(entity, version, EntityDescriptor.createDescriptorForInvoke(fetch, instance), this, config, codec, compoundRunnable, this.endpointCloser);
            if (null != this.objectStoreMap.get(instance)) {
                throw Assert.failure("Attempt to add an object that already exists: Object of class " + resolvedEndpoint.getClass() + " [Identity Hashcode : 0x" + Integer.toHexString(System.identityHashCode(resolvedEndpoint)) + "] ");
            }
            this.objectStoreMap.put(instance, resolvedEndpoint);
        }
        catch (EntityNotFoundException notfound) {
            throw notfound;
        }
        catch (EntityException e) {
            this.internalRelease(entity, fetchDescriptor, null);
            throw e;
        }
        catch (Throwable t) {
            this.internalRelease(entity, fetchDescriptor, null);
            throw Throwables.propagate(t);
        }
        return resolvedEndpoint;
    }

    private void internalRelease(EntityID eid, EntityDescriptor entityDescriptor, Runnable closeHook) throws EntityException {
        EnumSet<VoltronEntityMessage.Acks> requestedAcks = EnumSet.of(VoltronEntityMessage.Acks.COMPLETED);
        boolean requiresReplication = true;
        byte[] payload = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(eid, entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.RELEASE_ENTITY, requestedAcks);
        this.sendMessageWhileBusy(message, requestedAcks, "ClientEntityManagerImpl.internalRelease");
        this.objectStoreMap.remove(entityDescriptor.getClientInstanceID());
        if (closeHook != null) {
            closeHook.run();
        }
    }

    private byte[] sendMessageWhileBusy(NetworkVoltronEntityMessage msg, Set<VoltronEntityMessage.Acks> requestedAcks, String traceComponentName) throws EntityException {
        Trace trace = Trace.newTrace(msg, traceComponentName);
        trace.start();
        EntityID eid = msg.getEntityDescriptor().getEntityID();
        while (true) {
            try {
                InFlightMessage inflight = this.queueInFlightMessage(msg, requestedAcks, null, false, false);
                inflight.waitForAcks();
                byte[] byArray = inflight.get();
                return byArray;
            }
            catch (EntityBusyException busy) {
                this.wasBusy = true;
                try {
                    TimeUnit.SECONDS.sleep(2L);
                }
                catch (InterruptedException in) {
                    throw new VoltronWrapperException(new EntityServerUncaughtException(eid.getClassName(), eid.getEntityName(), "", in));
                }
                this.logger.info("Operation delayed:" + (Object)((Object)msg.getVoltronType()) + ", busy wait");
                msg = this.createMessageWithDescriptor(eid, msg.getEntityDescriptor(), msg.doesRequireReplication(), msg.getExtendedData(), msg.getVoltronType(), requestedAcks);
                continue;
            }
            catch (InterruptedException ie) {
                throw new VoltronWrapperException(new EntityServerUncaughtException(eid.getClassName(), eid.getEntityName(), "", ie));
            }
            finally {
                trace.end();
                continue;
            }
            break;
        }
    }

    private byte[] internalRetrieve(EntityDescriptor entityDescriptor) throws EntityException {
        EnumSet<VoltronEntityMessage.Acks> requestedAcks = EnumSet.of(VoltronEntityMessage.Acks.COMPLETED);
        boolean requiresReplication = true;
        byte[] payload = new byte[]{};
        NetworkVoltronEntityMessage message = this.createMessageWithDescriptor(entityDescriptor.getEntityID(), entityDescriptor, requiresReplication, payload, VoltronEntityMessage.Type.FETCH_ENTITY, requestedAcks);
        return this.sendMessageWhileBusy(message, requestedAcks, "ClientEntityManagerImpl.internalRetrieve");
    }

    private InFlightMessage queueInFlightMessage(NetworkVoltronEntityMessage message, Set<VoltronEntityMessage.Acks> requestedAcks, InFlightMonitor monitor, boolean shouldBlockGetOnRetire, boolean isDeferred) {
        InFlightMessage inFlight = new InFlightMessage(message.getEntityID(), message, requestedAcks, monitor, shouldBlockGetOnRetire, isDeferred);
        this.outbound.addSingleThreaded(inFlight);
        return inFlight;
    }

    private NetworkVoltronEntityMessage createMessageWithoutClientInstance(EntityID entityID, long version, boolean requiresReplication, byte[] config, VoltronEntityMessage.Type type, Set<VoltronEntityMessage.Acks> acks) {
        EntityDescriptor entityDescriptor = EntityDescriptor.createDescriptorForLifecycle(entityID, version);
        return this.createMessageWithDescriptor(entityID, entityDescriptor, requiresReplication, config, type, acks);
    }

    private NetworkVoltronEntityMessage createMessageWithDescriptor(EntityID entityID, EntityDescriptor entityDescriptor, boolean requiresReplication, byte[] config, VoltronEntityMessage.Type type, Set<VoltronEntityMessage.Acks> acks) {
        TransactionID transactionID;
        ClientID clientID = this.channel.getClientID();
        TransactionID oldestTransactionPending = transactionID = new TransactionID(this.currentTransactionID.incrementAndGet());
        if (this.reconnectable) {
            for (TransactionID pendingID : this.inFlightMessages.keySet()) {
                if (oldestTransactionPending.compareTo(pendingID) <= 0) continue;
                oldestTransactionPending = pendingID;
            }
        }
        NetworkVoltronEntityMessage message = (NetworkVoltronEntityMessage)this.channel.createMessage(TCMessageType.VOLTRON_ENTITY_MESSAGE);
        message.setContents(clientID, transactionID, entityID, entityDescriptor, type, requiresReplication, config, oldestTransactionPending, acks);
        return message;
    }

    private static class MessagePendingCount {
        private int messagesPending = ClientConfigurationContext.MAX_PENDING_REQUESTS;

        private MessagePendingCount() {
        }

        private int messagePending() {
            Assert.assertTrue(this.messagesPending > 0);
            return --this.messagesPending;
        }

        private int messageRetired() {
            Assert.assertTrue(this.messagesPending < ClientConfigurationContext.MAX_PENDING_REQUESTS);
            return ++this.messagesPending;
        }

        private boolean messagePendingSlotAvailable() {
            return this.messagesPending > 0;
        }

        private void stop() {
            this.messagesPending = 0;
        }
    }

    private static class FlushResponse
    implements VoltronEntityResponse,
    VoltronEntityMultiResponse {
        private boolean accessed = false;

        private FlushResponse() {
        }

        @Override
        public synchronized TransactionID getTransactionID() {
            this.notifyAll();
            this.accessed = true;
            return TransactionID.NULL_ID;
        }

        @Override
        public VoltronEntityMessage.Acks getAckType() {
            return VoltronEntityMessage.Acks.RECEIVED;
        }

        @Override
        public TCMessageType getMessageType() {
            return TCMessageType.VOLTRON_ENTITY_RECEIVED_RESPONSE;
        }

        @Override
        public void hydrate() throws IOException, UnknownNameException {
        }

        @Override
        public void dehydrate() {
        }

        @Override
        public synchronized int replay(VoltronEntityMultiResponse.ReplayReceiver receiver) {
            this.notifyAll();
            this.accessed = true;
            return 0;
        }

        @Override
        public boolean send() {
            return true;
        }

        @Override
        public MessageChannel getChannel() {
            return null;
        }

        @Override
        public NodeID getSourceNodeID() {
            return ServerID.NULL_ID;
        }

        @Override
        public NodeID getDestinationNodeID() {
            return ClientID.NULL_ID;
        }

        @Override
        public SessionID getLocalSessionID() {
            return SessionID.NULL_ID;
        }

        @Override
        public int getTotalLength() {
            return 0;
        }

        @Override
        public boolean addReceived(TransactionID tid) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addRetired(TransactionID tid) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addResult(TransactionID tid, byte[] result) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addResultAndRetire(TransactionID tid, byte[] result) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addServerMessage(TransactionID cid, byte[] message) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public boolean addServerMessage(ClientInstanceID cid, byte[] message) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void stopAdding() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public synchronized void waitForAccess() {
            boolean interrupted = false;
            while (!this.accessed) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    interrupted = true;
                }
            }
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

