/*
 * Decompiled with CFR 0.152.
 */
package com.terracotta.connection;

import com.tc.config.schema.setup.ConfigurationSetupException;
import com.tc.object.ClientBuilderFactory;
import com.tc.object.ClientEntityManager;
import com.tc.object.DistributedObjectClient;
import com.tc.object.DistributedObjectClientFactory;
import com.terracotta.connection.ClientHandle;
import com.terracotta.connection.ClientHandleImpl;
import com.terracotta.connection.TerracottaInternalClient;
import com.terracotta.connection.client.TerracottaClientStripeConnectionConfig;
import java.util.Properties;
import java.util.concurrent.TimeoutException;

public class TerracottaInternalClientImpl
implements TerracottaInternalClient {
    private final DistributedObjectClientFactory clientCreator;
    private volatile ClientHandle clientHandle;
    private volatile boolean shutdown = false;
    private volatile boolean isInitialized = false;

    TerracottaInternalClientImpl(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties props) {
        try {
            this.clientCreator = this.buildClientCreator(stripeConnectionConfig, props);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DistributedObjectClientFactory buildClientCreator(TerracottaClientStripeConnectionConfig stripeConnectionConfig, Properties props) {
        return new DistributedObjectClientFactory(stripeConnectionConfig.getStripeMemberUris(), ClientBuilderFactory.get().create(props), props);
    }

    @Override
    public synchronized void init() throws TimeoutException, InterruptedException, ConfigurationSetupException {
        if (this.isInitialized) {
            return;
        }
        DistributedObjectClient client = this.clientCreator.create();
        if (client == null) {
            throw new TimeoutException();
        }
        this.clientHandle = new ClientHandleImpl(client);
        this.isInitialized = true;
    }

    @Override
    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public synchronized void shutdown() {
        this.shutdown = true;
        try {
            if (this.clientHandle != null) {
                this.clientHandle.shutdown();
            }
        }
        finally {
            this.clientHandle = null;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public ClientEntityManager getClientEntityManager() {
        return this.clientHandle.getClientEntityManager();
    }

    static class ClientShutdownException
    extends Exception {
        private static final long serialVersionUID = 1L;

        ClientShutdownException() {
        }
    }
}

