/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.lease.connection;

import java.net.URI;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionFactory;
import org.terracotta.lease.connection.BasicLeasedConnection;
import org.terracotta.lease.connection.LeasedConnection;
import org.terracotta.lease.connection.LeasedConnectionService;
import org.terracotta.lease.connection.TimeBudget;

public class LeasedConnectionServiceImpl
implements LeasedConnectionService {
    private static final String SCHEME = "terracotta";
    private static final String DEFAULT_LEASED_CONNECTION_TIMEOUT = "150000";

    @Override
    public boolean handlesURI(URI uri) {
        return SCHEME.equals(uri.getScheme());
    }

    @Override
    public LeasedConnection connect(URI uri, Properties properties) throws ConnectionException {
        TimeBudget timeBudget = LeasedConnectionServiceImpl.createTimeBudget(properties);
        Connection connection = ConnectionFactory.connect(uri, properties);
        BasicLeasedConnection leasedConnection = BasicLeasedConnection.create(connection, timeBudget);
        return leasedConnection;
    }

    private static TimeBudget createTimeBudget(Properties properties) {
        String timeoutString = properties.getProperty("connection.timeout", DEFAULT_LEASED_CONNECTION_TIMEOUT);
        long timeout = Long.parseLong(timeoutString);
        return new TimeBudget(timeout, TimeUnit.MILLISECONDS);
    }
}

