/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.connection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.ServiceLoader;
import org.terracotta.connection.Connection;
import org.terracotta.connection.ConnectionException;
import org.terracotta.connection.ConnectionService;
import org.terracotta.connection.URIUtils;

public final class ConnectionFactory {
    public static Connection connect(URI uri, Properties properties) throws ConnectionException {
        ConnectionFactory.validateURI(uri);
        ServiceLoader<ConnectionService> serviceLoader = ServiceLoader.load(ConnectionService.class, ConnectionFactory.class.getClassLoader());
        for (ConnectionService connectionService : serviceLoader) {
            if (!connectionService.handlesURI(uri)) continue;
            return connectionService.connect(uri, properties);
        }
        throw new IllegalArgumentException("Unknown URI " + uri);
    }

    private static void validateURI(URI uri) throws ConnectionException {
        try {
            URIUtils.validateTerracottaURI(uri);
        }
        catch (URISyntaxException e) {
            throw new ConnectionException(e);
        }
    }
}

